/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.dcs.expressions.languageprocessor;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.expressions.model.ExpressionsPackage;
import com._1c.g5.v8.dt.dcs.model.areaTemplate.AreaTemplateParameter;
import com._1c.g5.v8.dt.dcs.model.areaTemplate.DataCompositionExpressionAreaParameter;
import com._1c.g5.v8.dt.dcs.model.common.DcsPackage;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchema;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaCalculatedField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaParameter;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaTemplateDescription;
import com._1c.g5.v8.dt.dcs.model.schema.DataSet;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.dcs.model.schema.NestedDataCompositionSchema;
import com.e1c.langtool.v8.dt.internal.dcs.expressions.languageprocessor.DcsExprNStrCleanupProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.IObjectLanguageProcessor;
import com.e1c.langtool.v8.dt.languageprocessor.LanguageProcessorParameters;
import com.e1c.langtool.v8.dt.sync.EmfObjectProvider;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.util.CancelIndicator;

public class ExpressionsLanguageProcessor
implements IObjectLanguageProcessor {
    private static final String EXPRESSION = "expression";
    @Inject
    private EmfObjectProvider emfObjectProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IDependentModelProvider dependentModelProvider;

    public boolean isSupported(EPackage ePackage) {
        return ExpressionsPackage.eINSTANCE.equals(ePackage);
    }

    public void process(URI objectURI, LanguageProcessorParameters parameters) {
        if (objectURI.isPlatformResource()) {
            IFile currentFile = this.resourceLookup.getPlatformResource(objectURI);
            EObject object = this.emfObjectProvider.getObjectByFile(currentFile);
            this.cleanUpExpressions(object, parameters, currentFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cleanUpExpressions(EObject eObject, LanguageProcessorParameters parameters, IFile currentFile) {
        EObject eObject2 = eObject;
        if (eObject2 instanceof DataCompositionSchema) {
            void schema;
            DataCompositionSchema dataCompositionSchema = (DataCompositionSchema)eObject2;
            DataCompositionSchema cfr_ignored_0 = (DataCompositionSchema)eObject2;
            this.cleanupSchema((DataCompositionSchema)schema, currentFile, parameters);
        }
    }

    private void cleanupSchema(DataCompositionSchema schema, IFile currentFile, LanguageProcessorParameters parameters) {
        EList calculatedFields = schema.getCalculatedFields();
        for (DataCompositionSchemaCalculatedField calculatedField : calculatedFields) {
            EStructuralFeature eAttribute = calculatedField.eClass().getEStructuralFeature(EXPRESSION);
            this.cleanUpExpression((EObject)calculatedField, currentFile, eAttribute, parameters);
            eAttribute = DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_CALCULATED_FIELD__PRESENTATION_EXPRESSION;
            this.cleanUpExpression((EObject)calculatedField, currentFile, eAttribute, parameters);
        }
        EList schemaParameters = schema.getParameters();
        for (DataCompositionSchemaParameter parameter : schemaParameters) {
            EStructuralFeature eAttribute = parameter.eClass().getEStructuralFeature(EXPRESSION);
            this.cleanUpExpression((EObject)parameter, currentFile, eAttribute, parameters);
        }
        schema.getDataSets().stream().map(DataSet::getFields).flatMap(Collection::stream).filter(DataCompositionSchemaDataSetField.class::isInstance).forEach(field -> {
            DataCompositionSchemaDataSetField dataSetField = (DataCompositionSchemaDataSetField)field;
            EAttribute eAttribute = DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD__PRESENTATION_EXPRESSION;
            this.cleanUpExpression((EObject)dataSetField, currentFile, (EStructuralFeature)eAttribute, parameters);
            dataSetField.getOrderExpressions().forEach(orderExpression -> this.cleanUpExpression((EObject)orderExpression, currentFile, (EStructuralFeature)DcsPackage.Literals.DATA_COMPOSITION_ORDER_EXPRESSION__EXPRESSION, parameters));
        });
        EList templates = schema.getTemplates();
        for (DataCompositionSchemaTemplateDescription template : templates) {
            EList templateParameters = template.getParameters();
            for (AreaTemplateParameter templateParameter : templateParameters) {
                if (!(templateParameter instanceof DataCompositionExpressionAreaParameter)) continue;
                EStructuralFeature eAttribute = templateParameter.eClass().getEStructuralFeature(EXPRESSION);
                this.cleanUpExpression((EObject)templateParameter, currentFile, eAttribute, parameters);
            }
        }
        EList nestedSchemas = schema.getNestedSchemas();
        for (NestedDataCompositionSchema nestedSchema : nestedSchemas) {
            this.cleanupSchema(nestedSchema.getSchema(), currentFile, parameters);
        }
    }

    private void cleanUpExpression(EObject eObject, IFile file, EStructuralFeature eAttribute, LanguageProcessorParameters parameters) {
        if (eObject.eGet(eAttribute) == null) {
            return;
        }
        IPath basePath = file.getProjectRelativePath().removeFileExtension().addFileExtension("dcsexpr");
        Expressions expr = (Expressions)this.dependentModelProvider.getDependentModel(eObject, eAttribute, basePath, CancelIndicator.NullImpl);
        List<String> codes = parameters.getTranslateLanguages().stream().map(l -> l.getLanguageCode()).toList();
        DcsExprNStrCleanupProcessor processor = new DcsExprNStrCleanupProcessor(expr, parameters.getDefaultLanguageCode(), codes, parameters.isKeepLanguages());
        try {
            processor.process((IProgressMonitor)new NullProgressMonitor());
            eObject.eSet(eAttribute, (Object)processor.getText());
        }
        finally {
            this.dependentModelProvider.unload((EObject)expr);
        }
    }
}

