/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.form.translator;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.form.model.AbstractDataPath;
import com._1c.g5.v8.dt.form.model.Form;
import com._1c.g5.v8.dt.form.model.FormPackage;
import com._1c.g5.v8.dt.form.model.PropertyInfo;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.v8.dt.form.translator.DataPathSegmentsTranslationCache;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProviderDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class DataPathLastSegmentNameProvider
implements INamedEObjectNameProviderDelegate {
    @Inject
    private IV8ProjectManager v8ProjectManager;

    public Pair<String, String> getTranslatedName(EObject object, IProjectTranslationProvider translationProvider) {
        AbstractDataPath dp;
        if (object instanceof AbstractDataPath && !(dp = (AbstractDataPath)object).getSegments().isEmpty()) {
            String name = this.getName(object);
            DataPathSegmentsTranslationCache cache = (DataPathSegmentsTranslationCache)translationProvider.getCache(DataPathSegmentsTranslationCache.class);
            List<String> translation = cache.getOrComputeTranslation(dp);
            if (translation != null) {
                String value = translation.get(dp.getSegments().size() - 1);
                return new Pair((Object)name, (Object)value);
            }
        }
        return null;
    }

    public String getName(EObject object) {
        if (object instanceof AbstractDataPath) {
            AbstractDataPath dp = (AbstractDataPath)object;
            if (!dp.getSegments().isEmpty() && !dp.getObjects().isEmpty()) {
                return (String)dp.getSegments().get(dp.getSegments().size() - 1);
            }
            if (!dp.getSegments().isEmpty() && dp.getObjects().isEmpty()) {
                String name = (String)dp.getSegments().get(dp.getSegments().size() - 1);
                IBmObject top = ((IBmObject)object).bmGetTopObject();
                if (top instanceof Form) {
                    Object properties = ((Form)top).propertyInfos();
                    PropertyInfo current = null;
                    int i = 0;
                    while (i < dp.getSegments().size()) {
                        String segment = (String)dp.getSegments().get(i);
                        Optional<PropertyInfo> property = properties.stream().filter(p -> p.getNameRu().equals(segment) || p.getName().equals(segment)).findAny();
                        if (property.isPresent()) {
                            current = property.get();
                            if (i < dp.getSegments().size() - 1) {
                                properties = current.getPropertyInfos();
                            }
                        } else {
                            return name;
                        }
                        ++i;
                    }
                    if (current != null) {
                        IV8Project v8Project = this.v8ProjectManager.getProject((EObject)dp);
                        if (ScriptVariant.RUSSIAN.equals((Object)v8Project.getScriptVariant())) {
                            return current.getNameRu();
                        }
                        return current.getName();
                    }
                }
                return name;
            }
        }
        return null;
    }

    public Collection<EClass> getSupportEClass() {
        return List.of(FormPackage.Literals.ABSTRACT_DATA_PATH);
    }
}

