/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.form.translator;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaCalculatedField;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.form.model.AbstractDataPath;
import com._1c.g5.v8.dt.form.model.DataPathReferredObject;
import com._1c.g5.v8.dt.form.model.DynamicListExtInfo;
import com._1c.g5.v8.dt.form.model.Form;
import com._1c.g5.v8.dt.form.model.FormAttribute;
import com._1c.g5.v8.dt.form.model.FormAttributeExtInfo;
import com._1c.g5.v8.dt.form.model.PropertyInfo;
import com._1c.g5.v8.dt.form.util.DatapathUtil;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.form.translator.FormDynamicListInfoCache;
import com.e1c.langtool.v8.dt.internal.form.FormPlugin;
import com.e1c.langtool.v8.dt.translator.AbstractStringTranslationCache;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Provider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DataPathSegmentsTranslationCache
extends AbstractStringTranslationCache {
    private INamedEObjectNameProvider namedEObjectNameProvider;
    private IProjectTranslationProvider translationProvider;
    private IFeatureSettingsService featureSettingsService;

    public void init(IProjectTranslationProvider translationProvider) {
        this.translationProvider = translationProvider;
        this.namedEObjectNameProvider = (INamedEObjectNameProvider)FormPlugin.getDefault().getInjector().getInstance(INamedEObjectNameProvider.class);
        this.featureSettingsService = (IFeatureSettingsService)FormPlugin.getDefault().getInjector().getInstance(IFeatureSettingsService.class);
    }

    public @Nullable List<String> getTranslation(@NonNull AbstractDataPath source) {
        URI uri = EcoreUtil.getURI((EObject)source);
        return this.getTranslation(uri, (List<String>)source.getSegments());
    }

    public @Nullable List<String> getOrComputeTranslation(@NonNull AbstractDataPath source) {
        URI uri = EcoreUtil.getURI((EObject)source);
        Provider provider = () -> this.computeTranslation(source);
        return this.getTranslation(uri, (List<String>)source.getSegments(), (Provider<List<String>>)provider);
    }

    public @Nullable List<String> getTranslation(@NonNull AbstractDataPath source, @NonNull Provider<List<String>> provider) {
        URI uri = EcoreUtil.getURI((EObject)source);
        return this.getTranslation(uri, (List<String>)source.getSegments(), provider);
    }

    public @Nullable List<String> getTranslation(@NonNull URI formUri, @NonNull List<String> segments, @NonNull Provider<List<String>> provider) {
        List<String> translatedSegments;
        Provider stringProvider;
        if (segments.isEmpty() || !formUri.hasPath()) {
            return null;
        }
        for (String segment : segments) {
            if (!StringUtils.isNullOrEmpty((String)segment)) continue;
            return null;
        }
        String key = this.getKey(formUri, segments);
        String translation = this.get(key, stringProvider = () -> {
            List translatedSegments = (List)provider.get();
            if (translatedSegments != null && this.checkAppropriate(segments, translatedSegments)) {
                return String.join((CharSequence)".", translatedSegments);
            }
            return String.join((CharSequence)".", segments);
        });
        if (StringUtils.isNotEmpty((String)translation) && this.checkAppropriate(segments, translatedSegments = Arrays.asList(translation.split("\\.")))) {
            return translatedSegments;
        }
        return null;
    }

    public @Nullable List<String> getTranslation(@NonNull URI formUri, @NonNull List<String> segments) {
        if (segments.isEmpty() || !formUri.hasPath()) {
            return null;
        }
        for (String segment : segments) {
            if (!StringUtils.isNullOrEmpty((String)segment)) continue;
            return null;
        }
        String key = this.getKey(formUri, segments);
        String translation = this.get(key);
        if (StringUtils.isNotEmpty((String)translation)) {
            List<String> translatedSegments = Arrays.asList(translation.split("\\."));
            if (this.checkAppropriate(segments, translatedSegments)) {
                return translatedSegments;
            }
            this.remove(key);
        }
        return null;
    }

    private String getKey(URI formUri, List<String> segments) {
        return String.valueOf(formUri.trimFragment()) + ":" + String.join((CharSequence)".", segments);
    }

    private boolean checkAppropriate(List<String> source, List<String> target) {
        if (source.size() != target.size()) {
            return false;
        }
        for (String segment : target) {
            if (!StringUtils.isNullOrEmpty((String)segment)) continue;
            return false;
        }
        return true;
    }

    private List<String> computeTranslation(AbstractDataPath source) {
        EList segments = source.getSegments();
        ArrayList<String> translated = new ArrayList<String>((Collection<String>)segments);
        EList objects = source.getObjects();
        ScriptVariant variant = this.translationProvider.getProject().getScriptVariant();
        FormAttribute dynamicListAttribue = null;
        for (DataPathReferredObject refObject : objects) {
            String segment;
            int index = refObject.getSegmentIdx();
            if (index >= segments.size()) continue;
            String newSegment = segment = (String)segments.get(index);
            EObject obj = refObject.getObject();
            if (index == 1 && dynamicListAttribue != null) {
                newSegment = this.getDynamidListFieldSegmentTranslation(dynamicListAttribue, segment, index);
                if (obj instanceof DuallyNamedElement && segment.equals(newSegment)) {
                    DuallyNamedElement dually = (DuallyNamedElement)obj;
                    if (segment.equals(dually.getName()) && !dually.getName().equalsIgnoreCase(dually.getNameRu())) {
                        newSegment = this.getDynamidListFieldSegmentTranslation(dynamicListAttribue, dually.getNameRu(), index);
                    } else if (segment.equals(dually.getNameRu()) && !dually.getName().equalsIgnoreCase(dually.getNameRu())) {
                        newSegment = this.getDynamidListFieldSegmentTranslation(dynamicListAttribue, dually.getName(), index);
                    }
                }
            } else if (index > 2 && ("\u0422\u0435\u043a\u0443\u0449\u0438\u0435\u0414\u0430\u043d\u043d\u044b\u0435".equalsIgnoreCase((String)segments.get(index - 1)) || "CurrentData".equalsIgnoreCase((String)segments.get(index - 1))) && this.isCustormQuery(((DataPathReferredObject)objects.get(index - 2)).getObject())) {
                FormAttribute previousAttribue = (FormAttribute)((DataPathReferredObject)objects.get(index - 2)).getObject();
                if (previousAttribue != null) {
                    newSegment = this.getDynamidListFieldSegmentTranslation(previousAttribue, segment, index);
                }
            } else if (obj != null) {
                obj = EcoreUtil.resolve((EObject)obj, (EObject)source);
                newSegment = this.getSegmentTranslation(obj, segment);
                if (index == 0 && this.isCustormQuery(obj)) {
                    dynamicListAttribue = (FormAttribute)obj;
                }
            }
            if (StringUtils.isNullOrEmpty((String)newSegment)) {
                if (!FormPlugin.getDefault().isDebugging()) continue;
                System.out.println(MessageFormat.format("Empty dataPath segment translation detected in: \"{0}\" for index {1}", EcoreUtil.getURI((EObject)source), index));
                continue;
            }
            translated.set(index, newSegment);
        }
        if (DatapathUtil.isElementDataPath((AbstractDataPath)source)) {
            boolean isRu = ScriptVariant.RUSSIAN.equals((Object)variant);
            translated.set(0, isRu ? "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b" : "Items");
            translated.set(2, isRu ? "\u0422\u0435\u043a\u0443\u0449\u0438\u0435\u0414\u0430\u043d\u043d\u044b\u0435" : "CurrentData");
        }
        if (!segments.isEmpty() && objects.isEmpty()) {
            this.updateTranslationbyPropertyInfo(source, translated);
        }
        return translated;
    }

    private void updateTranslationbyPropertyInfo(AbstractDataPath dp, List<String> translated) {
        IBmObject top = dp.bmGetTopObject();
        if (top instanceof Form) {
            Object properties = ((Form)top).propertyInfos();
            ScriptVariant variant = this.translationProvider.getProject().getScriptVariant();
            FormAttribute attribute = null;
            int i = 0;
            while (i < dp.getSegments().size()) {
                String segment = (String)dp.getSegments().get(i);
                Optional<PropertyInfo> property = properties.stream().filter(p -> p.getNameRu().equals(segment) || p.getName().equals(segment)).findAny();
                if (property.isPresent()) {
                    PropertyInfo current = property.get();
                    if (i < dp.getSegments().size() - 1) {
                        properties = current.getPropertyInfos();
                    }
                    String name = ScriptVariant.RUSSIAN.equals((Object)variant) ? current.getNameRu() : current.getName();
                    Object source = current.getSource();
                    if (source instanceof FormAttribute) {
                        attribute = (FormAttribute)source;
                    }
                    if (source instanceof EObject) {
                        String newSegment = this.getSegmentTranslation((EObject)source, name);
                        if (StringUtils.isNotEmpty((String)newSegment)) {
                            translated.set(i, newSegment);
                        }
                        if (name.equalsIgnoreCase(newSegment) && this.isCustomQuery(attribute) && StringUtils.isNotEmpty((String)(newSegment = this.getDynamidListFieldSegmentTranslation(attribute, segment, i)))) {
                            translated.set(i, newSegment);
                        }
                    }
                } else {
                    return;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCustomQuery(FormAttribute attribute) {
        FormAttributeExtInfo res = attribute.getExtInfo();
        boolean customQuery = false;
        FormAttributeExtInfo formAttributeExtInfo = res;
        if (formAttributeExtInfo instanceof DynamicListExtInfo) {
            void extInfo;
            DynamicListExtInfo dynamicListExtInfo = (DynamicListExtInfo)formAttributeExtInfo;
            DynamicListExtInfo cfr_ignored_0 = (DynamicListExtInfo)formAttributeExtInfo;
            customQuery = extInfo.isCustomQuery();
        }
        return customQuery;
    }

    private String getSegmentTranslation(EObject obj, String name) {
        if (!this.translationProvider.getProject().isChangeDefaultLanguage()) {
            return name;
        }
        Pair translation = this.namedEObjectNameProvider.getTranslatedName(obj, this.translationProvider);
        if (translation != null) {
            if (obj instanceof DuallyNamedElement && !name.contains((CharSequence)translation.getKey())) {
                DuallyNamedElement dually = (DuallyNamedElement)obj;
                if (dually.getName().equals(name) && dually.getNameRu().equals(translation.getKey())) {
                    return this.replaceWithDifferenceSuffix(dually.getName(), dually.getNameRu(), (String)translation.getValue());
                }
                if (dually.getNameRu().equals(name) && dually.getName().equals(translation.getKey())) {
                    return this.replaceWithDifferenceSuffix(dually.getNameRu(), dually.getName(), (String)translation.getValue());
                }
            }
            return name.replace((CharSequence)translation.getKey(), (CharSequence)translation.getValue());
        }
        return name;
    }

    private String replaceWithDifferenceSuffix(String first, String second, String value) {
        int index = 0;
        int i = 0;
        while (i < first.length() && i < second.length()) {
            char c2;
            char c = first.charAt(i);
            if (c != (c2 = second.charAt(i))) break;
            ++index;
            ++i;
        }
        if (index > 0 && index < second.length() && index < first.length()) {
            String suffix = second.substring(index);
            String sourceSuffix = first.substring(index);
            if (value.endsWith(suffix)) {
                value = value.substring(0, value.length() - suffix.length()).concat(sourceSuffix);
            }
        }
        return value;
    }

    private boolean isCustormQuery(EObject source) {
        return source instanceof FormAttribute && ((FormAttribute)source).getExtInfo() instanceof DynamicListExtInfo && ((DynamicListExtInfo)((FormAttribute)source).getExtInfo()).isCustomQuery();
    }

    private String getDynamidListFieldSegmentTranslation(FormAttribute attribute, String segment, int segmentIndex) {
        Assert.isLegal((boolean)(attribute.getExtInfo() instanceof DynamicListExtInfo));
        DynamicListExtInfo extInfo = (DynamicListExtInfo)attribute.getExtInfo();
        FormDynamicListInfoCache cache = (FormDynamicListInfoCache)this.translationProvider.getCache(FormDynamicListInfoCache.class);
        Map<String, String> fieldNames = cache.getFieldNames(extInfo);
        Optional trans = Optional.ofNullable(fieldNames.get(segment));
        if (trans.isPresent()) {
            return trans.get();
        }
        if (segmentIndex == 1) {
            TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
            for (DataCompositionSchemaCalculatedField calculatedField : extInfo.getCalculatedFields()) {
                String dataPath = calculatedField.getDataPath();
                if (!segment.equals(dataPath)) continue;
                EFeatureSettings featureSettings = this.featureSettingsService.getSettings((EStructuralFeature)DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_CALCULATED_FIELD__DATA_PATH, (EObject)calculatedField);
                trans = this.translationProvider.getOptionalTranslation((EObject)calculatedField, featureSettings, language);
                return trans.orElse(segment);
            }
        }
        return segment;
    }
}

