/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.form.translator;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.form.model.DynamicListExtInfo;
import com._1c.g5.v8.dt.form.model.FormAttribute;
import com._1c.g5.v8.dt.form.model.FormPackage;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.form.FormPlugin;
import com.e1c.langtool.v8.dt.ql.translator.QlTextEditor;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.SessionCache;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.util.CancelIndicator;

public class FormDynamicListInfoCache
implements SessionCache {
    private final IResourceLookup resourceLookup;
    private final IDependentQuerySchemaProvider dependentModelProvider;
    private final Map<URI, DynamicListInfo> cache = new ConcurrentHashMap<URI, DynamicListInfo>();
    private IProjectTranslationProvider translationProvider;

    public FormDynamicListInfoCache() {
        this.resourceLookup = (IResourceLookup)FormPlugin.getDefault().getInjector().getInstance(IResourceLookup.class);
        this.dependentModelProvider = (IDependentQuerySchemaProvider)FormPlugin.getDefault().getInjector().getInstance(IDependentQuerySchemaProvider.class);
    }

    public void clear() {
        this.cache.clear();
    }

    public void clear(@NonNull URI dynamicListInfoUri) {
        this.cache.remove(dynamicListInfoUri);
    }

    public void init(IProjectTranslationProvider translationProvider) {
        this.translationProvider = translationProvider;
    }

    public String getQueryText(DynamicListExtInfo source) {
        DynamicListInfo dynamicListInfo = this.getDynamicListInfo(source, this.translationProvider);
        if (dynamicListInfo == null) {
            return source.getQueryText();
        }
        return dynamicListInfo.getQueryText();
    }

    public @NonNull Map<String, String> getFieldNames(@NonNull DynamicListExtInfo source) {
        DynamicListInfo dynamicListInfo = this.getDynamicListInfo(source, this.translationProvider);
        if (dynamicListInfo == null) {
            return Collections.emptyMap();
        }
        return dynamicListInfo.getFieldNames();
    }

    private DynamicListInfo getDynamicListInfo(DynamicListExtInfo source, IProjectTranslationProvider translationProvider) {
        URI uri = EcoreUtil.getURI((EObject)source);
        if (uri == null || !uri.hasFragment() || !uri.hasPath()) {
            return null;
        }
        Provider provider = () -> this.computeDynamicListInfo(source, translationProvider);
        return this.cache.computeIfAbsent(uri, k -> (DynamicListInfo)provider.get());
    }

    private DynamicListInfo computeDynamicListInfo(DynamicListExtInfo source, IProjectTranslationProvider translationProvider) {
        String queryText;
        Object fieldNames;
        block9: {
            Assert.isLegal((boolean)source.isCustomQuery());
            IFile file = this.resourceLookup.getPlatformResource((EObject)source);
            if (file == null || StringUtils.isBlank((String)source.getQueryText())) {
                return new DynamicListInfo(source.getQueryText(), (Map<String, String>)ImmutableMap.of());
            }
            QuerySchema query = this.dependentModelProvider.getQuerySchema((EObject)source, (EStructuralFeature)FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__QUERY_TEXT, CancelIndicator.NullImpl);
            if (query == null) {
                FormPlugin.log(FormPlugin.createWarningStatus("Can't create form dynamic list query object from text: \n\n" + (String)source.eGet((EStructuralFeature)FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__QUERY_TEXT)));
                return new DynamicListInfo(source.getQueryText(), (Map<String, String>)ImmutableMap.of());
            }
            fieldNames = ImmutableMap.of();
            queryText = source.getQueryText();
            try {
                try {
                    QlTextEditor qlProcessor = QlTextEditor.create((IProjectTranslationProvider)translationProvider, (QuerySchema)query, (boolean)true);
                    qlProcessor.process((IProgressMonitor)new NullProgressMonitor());
                    if (!Strings.isNullOrEmpty((String)queryText) && !queryText.equals(qlProcessor.getProcessedText())) {
                        List fieldMaps;
                        EObject parent = source.eContainer();
                        if (parent instanceof FormAttribute && !(fieldMaps = qlProcessor.getFieldMaps()).isEmpty() && fieldMaps.get(fieldMaps.size() - 1) != null) {
                            fieldNames = (Map)fieldMaps.get(fieldMaps.size() - 1);
                        }
                        queryText = qlProcessor.getProcessedText();
                    }
                }
                catch (Exception e) {
                    FormPlugin.logError(e);
                    this.dependentModelProvider.unload(query);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.dependentModelProvider.unload(query);
                throw throwable;
            }
            this.dependentModelProvider.unload(query);
        }
        return new DynamicListInfo(queryText, (Map<String, String>)fieldNames);
    }

    private final class DynamicListInfo {
        private final String queryText;
        private final Map<String, String> fieldNames;

        public DynamicListInfo(String queryText, Map<String, String> fieldNames) {
            this.queryText = queryText;
            this.fieldNames = Map.copyOf(fieldNames);
        }

        public String getQueryText() {
            return this.queryText;
        }

        public Map<String, String> getFieldNames() {
            return this.fieldNames;
        }
    }
}

