/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.form.translator;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.dt.form.model.Form;
import com._1c.g5.v8.dt.form.model.FormAttribute;
import com._1c.g5.v8.dt.form.model.FormCommand;
import com._1c.g5.v8.dt.form.model.FormCommandPanelGlobalCommandSource;
import com._1c.g5.v8.dt.form.model.FormItem;
import com._1c.g5.v8.dt.form.model.FormPackage;
import com._1c.g5.v8.dt.form.model.FormStandardCommand;
import com._1c.g5.v8.dt.form.model.FormStandardCommandSource;
import com._1c.g5.v8.dt.mcore.Command;
import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.metadata.dbview.DbViewDef;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameService;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameServiceDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

@Singleton
public final class FormSymbolicNameServiceDelegate
implements ITranslatedSymbolicNameServiceDelegate {
    @Inject
    private ITranslatedSymbolicNameService symbolicNameService;

    public String generateCommonSymbolicName(EObject targetObject, EObject contextObject, IProjectTranslationProvider translationProvider) {
        return null;
    }

    public String convertUriToCommonSymbolicName(URI targetUri) {
        return null;
    }

    public String generateContextSpecificSymbolicName(EObject targetObject, EObject contextObject, EReference contextFeature, IProjectTranslationProvider translationProvider) {
        if (contextObject.eClass().getEPackage() != FormPackage.eINSTANCE) {
            return null;
        }
        if (contextFeature == FormPackage.Literals.EVENT_HANDLER__EVENT) {
            return this.generateEventName((Event)targetObject);
        }
        if (contextFeature == FormPackage.Literals.REPORT_FORM_EXT_INFO__USER_SETTINGS_GROUP || contextFeature == FormPackage.Literals.DYNAMIC_LIST_TABLE_EXT_INFO__USER_SETTINGS_GROUP) {
            return this.generateFormItemName((FormItem)targetObject, translationProvider);
        }
        if (contextFeature == FormPackage.Literals.ADDITION__SOURCE) {
            return this.generateFormItemName((FormItem)targetObject, translationProvider);
        }
        if (contextFeature == FormPackage.Literals.COMMAND_BAR_EXT_INFO__COMMAND_SOURCE || contextFeature == FormPackage.Literals.POPUP_GROUP_EXT_INFO__COMMAND_SOURCE || contextFeature == FormPackage.Literals.BUTTON_GROUP_EXT_INFO__COMMAND_SOURCE) {
            return this.generateStandardCommandSourceName((FormStandardCommandSource)targetObject, translationProvider);
        }
        if (contextFeature == FormPackage.Literals.FORM_STANDARD_COMMAND_SOURCE__EXCLUDED_COMMANDS) {
            return this.generateFormStandardCommandSourceExcludedCommandName((FormStandardCommand)targetObject);
        }
        if (contextFeature == FormPackage.Literals.BUTTON__COMMAND_NAME || contextFeature == FormPackage.Literals.FORM_COMMAND_INTERFACE_ITEM__COMMAND) {
            return this.generateCommandName((Command)targetObject, translationProvider);
        }
        if (contextFeature == FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__MAIN_TABLE) {
            return this.generateDynamicListExtInfoMainTableName((DbViewDef)targetObject, translationProvider);
        }
        if (contextFeature == FormPackage.Literals.REPORT_FORM_EXT_INFO__REPORT_RESULT || contextFeature == FormPackage.Literals.REPORT_FORM_EXT_INFO__DETAILS_INFORMATION || contextFeature == FormPackage.Literals.REPORT_FORM_EXT_INFO__CURRENT_VARIANT_PRESENTATION_FIELD) {
            return this.generateReportFormExtInfoReferencedAttributeName((FormAttribute)targetObject, translationProvider);
        }
        return null;
    }

    public String convertUriToContextSpecificSymbolicName(URI targetUri, EObject contextObject, EReference contextFeature) {
        if (contextObject.eClass().getEPackage() != FormPackage.eINSTANCE) {
            return null;
        }
        if (contextFeature == FormPackage.Literals.EVENT_HANDLER__EVENT) {
            return null;
        }
        if (contextFeature == FormPackage.Literals.REPORT_FORM_EXT_INFO__USER_SETTINGS_GROUP || contextFeature == FormPackage.Literals.DYNAMIC_LIST_TABLE_EXT_INFO__USER_SETTINGS_GROUP) {
            return this.generateFormItemName(targetUri);
        }
        if (contextFeature == FormPackage.Literals.ADDITION__SOURCE) {
            return this.generateFormItemName(targetUri);
        }
        if (contextFeature == FormPackage.Literals.COMMAND_BAR_EXT_INFO__COMMAND_SOURCE || contextFeature == FormPackage.Literals.POPUP_GROUP_EXT_INFO__COMMAND_SOURCE || contextFeature == FormPackage.Literals.BUTTON_GROUP_EXT_INFO__COMMAND_SOURCE) {
            return this.generateStandardCommandSourceName(targetUri);
        }
        if (contextFeature == FormPackage.Literals.FORM_STANDARD_COMMAND_SOURCE__EXCLUDED_COMMANDS) {
            return this.generateFormStandardCommandSourceExcludedCommandName(targetUri);
        }
        if (contextFeature == FormPackage.Literals.BUTTON__COMMAND_NAME || contextFeature == FormPackage.Literals.FORM_COMMAND_INTERFACE_ITEM__COMMAND) {
            return this.generateCommandName(targetUri);
        }
        if (contextFeature == FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__MAIN_TABLE) {
            return this.generateDynamicListExtInfoMainTableName(targetUri);
        }
        if (contextFeature == FormPackage.Literals.REPORT_FORM_EXT_INFO__REPORT_RESULT || contextFeature == FormPackage.Literals.REPORT_FORM_EXT_INFO__DETAILS_INFORMATION || contextFeature == FormPackage.Literals.REPORT_FORM_EXT_INFO__CURRENT_VARIANT_PRESENTATION_FIELD) {
            return this.generateReportFormExtInfoReferencedAttributeName(targetUri);
        }
        return null;
    }

    private String generateReportFormExtInfoReferencedAttributeName(URI targetUri) {
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        return BmUriUtil.decodeCollectionItemId((String)path.substring("/attributes:".length()));
    }

    private String generateDynamicListExtInfoMainTableName(URI targetUri) {
        String subpath;
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        if (!path.startsWith("/dbViewDefs")) {
            return null;
        }
        String topObjectFqn = BmUriUtil.extractTopObjectFqn((URI)targetUri);
        switch (subpath = path.substring("/dbViewDefs".length())) {
            case "/allConstantsSelectView": {
                if (topObjectFqn.equals("Configuration")) {
                    return "Constants";
                }
                return null;
            }
            case "/filterCriterionSelectView": {
                return topObjectFqn;
            }
            case "/mainView": {
                return topObjectFqn;
            }
            case "/changeView": {
                return topObjectFqn + ".Changes";
            }
            case "/routePointView": {
                return topObjectFqn + ".Points";
            }
            case "/boundaryView": {
                return topObjectFqn + ".Boundaries";
            }
            case "/sliceSelectViewFirst": {
                return topObjectFqn + ".SliceFirst";
            }
            case "/sliceSelectViewLast": {
                return topObjectFqn + ".SliceLast";
            }
            case "/balanceSelectView": {
                return topObjectFqn + ".Balance";
            }
            case "/turnoverSelectView": {
                return topObjectFqn + ".Turnovers";
            }
            case "/balanceAndTurnoverSelectView": {
                return topObjectFqn + ".BalanceAndTurnovers";
            }
            case "/extDimensionsView": {
                return topObjectFqn + ".ExtDimensions";
            }
            case "/drCrTurnoverSelectView": {
                return topObjectFqn + ".DrCrTurnover";
            }
            case "/recordsWithExtDimensionSelectView": {
                return topObjectFqn + ".RecordsWithExtDimensions";
            }
            case "/bpTaskAddressingSelectView": {
                return topObjectFqn + ".TasksByExecutive";
            }
        }
        return null;
    }

    private String generateCommandName(URI targetUri) {
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        if (path.startsWith("/formCommands:")) {
            return "Form.Command." + BmUriUtil.decodeCollectionItemId((String)path.substring("/formCommands:".length()));
        }
        if (path.startsWith("/commands:")) {
            return "Form.StandardCommand." + BmUriUtil.decodeCollectionItemId((String)path.substring("/commands:".length()));
        }
        int lastColonIndex = path.lastIndexOf(58);
        if (lastColonIndex == -1) {
            return null;
        }
        int lastSlashIndex = path.lastIndexOf(47, lastColonIndex);
        if (lastSlashIndex == -1) {
            return null;
        }
        if (!path.substring(lastSlashIndex + 1, lastColonIndex).equals("commands")) {
            return null;
        }
        int precedingColonIndex = path.lastIndexOf(58, lastSlashIndex);
        if (precedingColonIndex == -1) {
            return null;
        }
        String itemName = BmUriUtil.decodeCollectionItemId((String)path.substring(precedingColonIndex + 1, lastSlashIndex));
        String commandName = BmUriUtil.decodeCollectionItemId((String)path.substring(lastColonIndex + 1));
        return "Form.Item." + itemName + ".StandardCommand." + commandName;
    }

    private String generateFormStandardCommandSourceExcludedCommandName(URI targetUri) {
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        return BmUriUtil.decodeCollectionItemId((String)path.substring(path.lastIndexOf(58) + 1));
    }

    private String generateStandardCommandSourceName(URI targetUri) {
        String fragment = targetUri.fragment();
        if (BmUriUtil.isTopObjectFragment((String)fragment)) {
            return "Form";
        }
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        if (path.equals("/" + FormPackage.Literals.FORM__COMMAND_PANEL_GLOBAL_COMMAND_SOURCE.getName())) {
            return "FormCommandPanelGlobalCommands";
        }
        return BmUriUtil.decodeCollectionItemId((String)path.substring(path.lastIndexOf(58) + 1));
    }

    private String generateFormItemName(URI targetUri) {
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        return BmUriUtil.decodeCollectionItemId((String)path.substring(path.lastIndexOf(58) + 1));
    }

    private String generateCommandName(Command command, IProjectTranslationProvider translationProvider) {
        EStructuralFeature containingFeature = command.eContainingFeature();
        if (containingFeature == FormPackage.Literals.FORM__FORM_COMMANDS) {
            String name = translationProvider.getOptionalTranslation((EObject)command, McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, translationProvider.getProject().getDefaultLanguage()).orElse(((FormCommand)command).getName());
            return "Form.Command." + name;
        }
        if (containingFeature == FormPackage.Literals.FORM_STANDARD_COMMAND_SOURCE__COMMANDS) {
            EObject container = command.eContainer();
            if (container instanceof Form) {
                return "Form.StandardCommand." + ((FormStandardCommand)command).getName();
            }
            String name = translationProvider.getOptionalTranslation(container, McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, translationProvider.getProject().getDefaultLanguage()).orElse(((FormItem)container).getName());
            return "Form.Item." + name + ".StandardCommand." + ((FormStandardCommand)command).getName();
        }
        return null;
    }

    private String generateDynamicListExtInfoMainTableName(DbViewDef targetObject, IProjectTranslationProvider translationProvider) {
        String symbolicName = this.symbolicNameService.generateSymbolicName((EObject)targetObject, targetObject.eContainer(), FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__MAIN_TABLE, translationProvider);
        if (symbolicName != null) {
            return symbolicName;
        }
        return targetObject.getName();
    }

    private String generateEventName(Event event) {
        return event.getName();
    }

    private String generateFormItemName(FormItem formItem, IProjectTranslationProvider translationProvider) {
        return translationProvider.getOptionalTranslation((EObject)formItem, McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, translationProvider.getProject().getDefaultLanguage()).orElse(formItem.getName());
    }

    private String generateFormStandardCommandSourceExcludedCommandName(FormStandardCommand command) {
        return command.getName();
    }

    private String generateReportFormExtInfoReferencedAttributeName(FormAttribute attribute, IProjectTranslationProvider translationProvider) {
        return translationProvider.getOptionalTranslation((EObject)attribute, McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, translationProvider.getProject().getDefaultLanguage()).orElse(attribute.getName());
    }

    private String generateStandardCommandSourceName(FormStandardCommandSource commandSource, IProjectTranslationProvider translationProvider) {
        if (commandSource instanceof Form) {
            return "Form";
        }
        if (commandSource instanceof FormCommandPanelGlobalCommandSource) {
            return "FormCommandPanelGlobalCommands";
        }
        String name = translationProvider.getOptionalTranslation((EObject)commandSource, McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, translationProvider.getProject().getDefaultLanguage()).orElse(((FormItem)commandSource).getName());
        return "Item." + name;
    }
}

