/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.resourcestorage;

import com.e1c.langtool.v8.dt.internal.resourcestorage.ExternalDependenciesModule;
import com.e1c.langtool.v8.dt.internal.resourcestorage.ServiceModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt.resourcestorage";
    private static Activator plugin;
    private volatile Injector injector;
    private BundleContext bundleContext;

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        Activator.log(Activator.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static void logError(String message, Throwable throwable) {
        Activator.log(Activator.createErrorStatus(message, throwable));
    }

    public static void logWarning(String message) {
        Activator.log(Activator.createWarningStatus(message));
    }

    public static void logWarning(String message, Exception throwable) {
        Activator.log(Activator.createWarningStatus(message, throwable));
    }

    public static void logInfo(String message) {
        Activator.log(Activator.createInfoStatus(message));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public static IStatus createInfoStatus(String message) {
        return new Status(1, PLUGIN_ID, 0, message, null);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.bundleContext = bundleContext;
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.bundleContext = null;
        this.injector = null;
        plugin = null;
        super.stop(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    public IEclipsePreferences getPreferences(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        return projectScope.getNode(PLUGIN_ID);
    }

    protected BundleContext getContext() {
        return this.bundleContext;
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            Activator.log(Activator.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

