/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.builder.ActionType;
import com.e1c.langtool.builder.TranslationBuilder;
import com.e1c.langtool.history.db.HistoryDataBaseException;
import com.e1c.langtool.history.db.IProjectTranslationStorage;
import com.e1c.langtool.history.db.query.Criteries;
import com.e1c.langtool.history.db.query.ExpressionBuilder;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.v8.dt.internal.resourcestorage.Activator;
import com.e1c.langtool.v8.dt.resourcestorage.IV8FileNameConverter;
import com.e1c.langtool.v8.dt.resourcestorage.validation.ValidationJob;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class DependentTranslationBuilder
extends TranslationBuilder {
    public static final String BUILDER_ID = "com.e1c.langtool.v8.dt.resourcestorage.dependentTranslationBuilder";
    @Inject
    @Named(value="Common")
    private IV8FileNameConverter commonStorageNameConverter;
    @Inject
    @Named(value="Context")
    private IV8FileNameConverter contextStorageNameConverter;
    @Inject
    private IProjectTranslationStorage projectTranslationStorage;
    private boolean needCheckCommonDicts;

    protected ITranslatingProject getTranslatingProject() {
        this.injectMembers();
        ITranslatingProject translatingProject = super.getTranslatingProject();
        return this.translatingProjectManager.getTranslatingForExternalProject(this.getProject()).orElse(translatingProject);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.injectMembers();
        ITranslatingProject translatingProject = this.getTranslatingProject();
        Collection langs = this.translatingProjectManager.getLanguagesForExternalProject(this.getProject());
        langs.forEach(lang -> {
            IExpression expression = ExpressionBuilder.where((IExpression)Criteries.projectEqual((String)translatingProject.getProject().getName())).and((IExpression)Criteries.langEqual((String)lang.getLanguageCode())).build();
            try {
                this.projectTranslationStorage.deleteTranslations(expression);
            }
            catch (HistoryDataBaseException e) {
                Activator.logError(e);
            }
        });
    }

    protected boolean processResource(IResource resource, ActionType actionType, IProgressMonitor monitor) {
        block17: {
            IV8FileNameConverter fileNameConverter;
            this.injectMembers();
            String fileExtension = resource.getFileExtension();
            if (resource.getType() != 1 || fileExtension == null) break block17;
            switch (fileExtension) {
                case "dict": {
                    this.needCheckCommonDicts = true;
                    fileNameConverter = this.commonStorageNameConverter;
                    break;
                }
                case "lsdict": {
                    fileNameConverter = this.commonStorageNameConverter;
                    break;
                }
                case "lstr": 
                case "nstr": 
                case "trans": {
                    fileNameConverter = this.contextStorageNameConverter;
                    break;
                }
                default: {
                    return false;
                }
            }
            fileNameConverter.getV8File(resource.getFullPath()).forEach(file -> {
                boolean bl = super.processResource((IResource)file, actionType, monitor);
            });
            return false;
        }
        return super.processResource(resource, actionType, monitor);
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject[] result = super.build(kind, args, monitor);
        if (this.needCheckCommonDicts) {
            this.startValidationJob();
        }
        return result;
    }

    private void startValidationJob() {
        boolean found = false;
        Job[] jobs = Job.getJobManager().find((Object)"Dictionary-Validation-family");
        int i = 0;
        while (i < jobs.length) {
            Job job = jobs[i];
            if (job.belongsTo((Object)this.getProject())) {
                found = true;
                job.cancel();
                job.schedule(500L);
            }
            ++i;
        }
        if (!found) {
            ValidationJob job = new ValidationJob(this.getProject());
            job.schedule(500L);
        }
    }

    private void injectMembers() {
        if (this.translatingProjectManager == null || this.commonStorageNameConverter == null || this.contextStorageNameConverter == null) {
            Activator.getDefault().getInjector().injectMembers((Object)this);
        }
    }
}

