/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureCollectorFactory;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.v8.dt.resourcestorage.IV8FileNameConverter;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;

public class FileFeatureCollectorFactory
implements FeatureCollectorFactory {
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    @Named(value="Context")
    private IV8FileNameConverter nameConverter;

    public boolean isSupport(Object object) {
        if (!(object instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)object;
        if (!this.nameConverter.isTranslation(file)) {
            return false;
        }
        Set<IFile> files = this.nameConverter.getV8File(file);
        if (files == null || files.isEmpty()) {
            return false;
        }
        for (IFile vfile : files) {
            if (!this.collectingService.hasCollector((Object)vfile)) continue;
            return true;
        }
        return false;
    }

    public Set<FeatureValueCollector> createCollectors(Object object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        if (!this.isSupport(object)) {
            return Sets.newLinkedHashSet();
        }
        IFile file = (IFile)object;
        Set<IFile> v8files = this.nameConverter.getV8File(file);
        if (v8files == null || v8files.isEmpty()) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet collectors = Sets.newLinkedHashSet();
        for (IFile v8file : v8files) {
            TranslationSource source;
            Collection collectorsSet;
            if (!this.collectingService.hasCollector((Object)v8file) || (collectorsSet = this.collectingService.createCollectors(source = TranslationUtils.getTranslationSource((Object)v8file), parameters, addAction)) == null) continue;
            collectors.addAll(collectorsSet);
        }
        return collectors;
    }
}

