/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.resourcestorage.Activator;
import com.e1c.langtool.v8.dt.resourcestorage.ITranslationsFile;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class QnTranslationsFile
implements ITranslationsFile {
    private String languageCode;
    private volatile boolean dirty = false;
    private IFile file;
    protected final boolean keyCaseSensitive;
    protected final boolean valueCaseSensitive;
    private String comment;
    protected final Map<FeatureKey, String> storage;
    protected final Map<FeatureKey, String> comments;
    protected volatile Map<String, Long> counterCache = null;

    public QnTranslationsFile(String languageCode, IFile file, boolean keyCaseSensitive, boolean valueCaseSensitive, String comment) {
        this.languageCode = languageCode;
        this.file = file;
        this.keyCaseSensitive = keyCaseSensitive;
        this.valueCaseSensitive = valueCaseSensitive;
        this.comment = comment;
        if (!this.keyCaseSensitive) {
            Comparator comparator = (o1, o2) -> o1.compareToIgnoreCase(o2);
            this.storage = new ConcurrentSkipListMap<FeatureKey, String>(comparator);
            this.comments = new ConcurrentSkipListMap<FeatureKey, String>(comparator);
        } else {
            this.storage = new ConcurrentSkipListMap<FeatureKey, String>();
            this.comments = new ConcurrentSkipListMap<FeatureKey, String>();
        }
    }

    @Override
    public void store(IProgressMonitor monitor) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.store(out, this.comment);
        try {
            if (!this.file.getProject().isAccessible()) {
                return;
            }
            ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
            if (this.file.exists()) {
                this.file.setContents((InputStream)input, true, true, monitor);
            } else {
                this.file.create((InputStream)input, true, monitor);
            }
            this.dirty = false;
        }
        catch (CoreException e) {
            Activator.logError(e);
        }
    }

    public void store(Writer writer, String comments) throws IOException {
        this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments, false);
    }

    public void store(OutputStream out, String comments) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)), comments, false);
    }

    @Override
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Override
    public String setTranslation(FeatureKey featureKey, String value, String comment) {
        String result = this.storage.put(featureKey, value);
        if (StringUtils.isNullOrEmpty((String)comment)) {
            this.comments.remove(featureKey);
        } else {
            this.comments.put(featureKey, comment);
        }
        this.markDirty();
        return result;
    }

    @Override
    public String getTranslation(FeatureKey featureKey) {
        return this.storage.get(featureKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComment(FeatureKey featureKey) {
        Map<FeatureKey, String> map = this.comments;
        synchronized (map) {
            return this.comments.get(featureKey);
        }
    }

    @Override
    public String removeTranslation(FeatureKey featureKey) {
        String removedValue = this.storage.remove(featureKey);
        this.comments.remove(featureKey);
        if (removedValue != null) {
            this.markDirty();
        }
        return removedValue;
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
        this.counterCache = null;
    }

    @Override
    public synchronized void load() {
        this.storage.clear();
        this.comments.clear();
        this.dirty = false;
        this.counterCache = null;
        if (this.file == null || !this.file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStreamReader reader = new InputStreamReader(this.file.getContents(), StandardCharsets.UTF_8);){
                this.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            Activator.logError(e);
        }
    }

    @Override
    public synchronized void delete() {
        if (this.file != null && this.file.exists()) {
            try {
                this.file.delete(true, null);
            }
            catch (CoreException e) {
                Activator.logError(e);
            }
        }
    }

    public synchronized void load(Reader reader) throws IOException {
        this.load0(new LineReader(reader));
    }

    @Override
    public Collection<FeatureKey> getTranslationKeys(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<FeatureKey> keys = this.keyCaseSensitive ? new ArrayList() : new TreeSet((o1, o2) -> o1.compareToIgnoreCase(o2));
        for (Map.Entry<FeatureKey, String> entry : this.storage.entrySet()) {
            if (!entry.getValue().equals(value) && (this.valueCaseSensitive || !entry.getValue().equalsIgnoreCase(value))) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUniqueValue(String value) {
        Long counter;
        if (this.counterCache == null) {
            QnTranslationsFile qnTranslationsFile = this;
            synchronized (qnTranslationsFile) {
                if (this.counterCache == null) {
                    this.updateCounterCache();
                }
            }
        }
        return (counter = this.counterCache.get(this.valueCaseSensitive ? value : value.toLowerCase())) == null || counter < 2L;
    }

    protected synchronized void updateCounterCache() {
        this.counterCache = this.storage.values().stream().collect(Collectors.groupingBy(s -> this.valueCaseSensitive ? s : s.toLowerCase(), Collectors.counting()));
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public void setFile(IFile file) {
        this.file = file;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            QnTranslationsFile.writeComments(bw, comments);
            bw.newLine();
        }
        QnTranslationsFile qnTranslationsFile = this;
        synchronized (qnTranslationsFile) {
            ArrayList<FeatureKey> keys = new ArrayList<FeatureKey>(this.storage.keySet());
            keys.sort(null);
            boolean firstLine = true;
            for (FeatureKey key : keys) {
                String keyComment = this.comments.get(key);
                if (!StringUtils.isBlank((String)keyComment)) {
                    if (!firstLine) {
                        bw.newLine();
                    }
                    String[] lines = keyComment.split(System.lineSeparator());
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        QnTranslationsFile.writeComments(bw, " " + line);
                        ++i;
                    }
                    firstLine = false;
                }
                String val = this.storage.get(key);
                String keyString = null;
                int segmentCount = key.getSegmentCount();
                switch (segmentCount) {
                    case 0: {
                        keyString = "";
                        break;
                    }
                    case 1: {
                        keyString = this.saveConvert(key.getFirstSegment(), true);
                        break;
                    }
                    default: {
                        StringBuilder builder = new StringBuilder();
                        builder.append(this.saveConvert(key.getFirstSegment(), true));
                        int i = 1;
                        while (i < segmentCount) {
                            builder.append('.');
                            builder.append(this.saveConvert(key.getSegment(i), true));
                            ++i;
                        }
                        keyString = builder.toString();
                    }
                }
                if (val == null) {
                    val = "";
                }
                val = this.saveConvert(val, false);
                bw.write(keyString + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        bw.write("#");
        int len = comments.length();
        int current = 0;
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        while (current < len) {
            char c = comments.charAt(current);
            if (c == '\n' || c == '\r') {
                if (last != current) {
                    bw.write(comments.substring(last, current));
                }
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
                last = current + 1;
            }
            ++current;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private String saveConvert(String theString, boolean escapeSpaceAndDot) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': 
                    case '.': {
                        if (x == 0 || escapeSpaceAndDot) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(aChar);
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        if (x + 1 != len && theString.charAt(x + 1) == '\n') break;
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private void load0(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            char c = '\u0000';
            int keyLen = 0;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            while (keyLen < limit) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
                ++keyLen;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            FeatureKey key = this.loadConvertKey(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            if (System.lineSeparator() != "\n") {
                value = value.replace("\n", System.lineSeparator());
            }
            this.storage.put(key, value);
            if (lr.comment == null) continue;
            String keyComment = String.join((CharSequence)System.lineSeparator(), lr.comment.split("\\n"));
            this.comments.put(key, keyComment);
        }
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private FeatureKey loadConvertKey(char[] in, int off, int len, char[] convtBuf) {
        ArrayList segments = Lists.newArrayList();
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 116) {
                    aChar = 9;
                } else {
                    if (aChar == 114) continue;
                    if (aChar == 110) {
                        aChar = 10;
                    } else if (aChar == 102) {
                        aChar = 12;
                    }
                }
                out[outLen++] = aChar;
                continue;
            }
            if (aChar == 46) {
                segments.add(new String(out, 0, outLen));
                out = convtBuf;
                outLen = 0;
                continue;
            }
            out[outLen++] = aChar;
        }
        if (outLen > 0) {
            segments.add(new String(out, 0, outLen));
        }
        return SegmentFeatureKey.create((List)segments);
    }

    class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;
        String comment = null;
        char[] commentBuf = new char[1024];

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            this.commentBuf = new char[1024];
            this.comment = null;
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        if (isCommentLine) {
                            this.commentBuf[len++] = 10;
                            this.commentBuf = this.increaseBuffer(this.commentBuf, len);
                        } else {
                            this.commentBuf = new char[1024];
                        }
                        isCommentLine = true;
                        skipWhiteSpace = true;
                        appendedLineBegin = true;
                        continue;
                    }
                    if (isCommentLine) {
                        this.comment = new String(this.commentBuf, 0, len);
                        this.commentBuf = new char[1024];
                        len = 0;
                    } else {
                        this.comment = null;
                        this.commentBuf = new char[1024];
                    }
                    isCommentLine = false;
                }
                if (c != '\n' && c != '\r') {
                    if (isCommentLine) {
                        this.commentBuf[len++] = c;
                        this.commentBuf = this.increaseBuffer(this.commentBuf, len);
                    } else {
                        this.lineBuf[len++] = c;
                        this.lineBuf = this.increaseBuffer(this.lineBuf, len);
                    }
                    if (c == '\\' && !isCommentLine) {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isNewLine = true;
                    skipWhiteSpace = true;
                    if (isCommentLine) {
                        appendedLineBegin = true;
                    }
                    if (c != '\r') continue;
                    skipLF = true;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }

        private char[] increaseBuffer(char[] currentBuf, int len) {
            if (len == currentBuf.length) {
                int newLength = currentBuf.length * 2;
                if (newLength < 0) {
                    newLength = Integer.MAX_VALUE;
                }
                char[] buf = new char[newLength];
                System.arraycopy(currentBuf, 0, buf, 0, currentBuf.length);
                return buf;
            }
            return currentBuf;
        }
    }
}

