/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.sync.DependentContentComputer;
import com.e1c.langtool.v8.dt.internal.resourcestorage.Activator;
import com.e1c.langtool.v8.dt.resourcestorage.IV8FileNameConverter;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class TransDependentContentComputer
implements DependentContentComputer {
    @Inject
    @Named(value="Context")
    private IV8FileNameConverter nameConverter;

    public Collection<IFile> computeDependentContentToSynchronize(IFile source, boolean sourceRemoved, IProgressMonitor monitor) {
        if (!this.nameConverter.isTranslation(source)) {
            return Collections.emptyList();
        }
        Set<IFile> v8files = this.nameConverter.getV8File(source);
        if (v8files != null && !v8files.isEmpty()) {
            Set<IFile> dependent = v8files.stream().filter(IResource::exists).collect(Collectors.toSet());
            if (!this.nameConverter.isInterface(source)) {
                for (IFile file : dependent) {
                    if (!(file.getParent() instanceof IFolder)) continue;
                    dependent.addAll(this.getChildren((IFolder)file.getParent()));
                }
            }
            return dependent;
        }
        return Collections.emptyList();
    }

    private Collection<IFile> getChildren(IFolder parent) {
        HashSet result = Sets.newHashSet();
        try {
            IResource[] members = parent.members();
            int i = 0;
            while (i < members.length) {
                IResource resource = members[i];
                String fileExtension = resource.getFileExtension();
                if (resource instanceof IFile && fileExtension != null) {
                    if (!(fileExtension.equals("trans") || fileExtension.equals("nstr") || fileExtension.equals("lstr"))) {
                        result.add((IFile)resource);
                    }
                } else if (resource instanceof IFolder) {
                    result.addAll(this.getChildren((IFolder)resource));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Activator.logError(e);
        }
        return result;
    }
}

