/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.resourcestorage.QnTranslationsFile;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;

public class UniqueDictTranslationsFile
extends QnTranslationsFile {
    protected Map<Long, Collection<FeatureKey>> keysByValue = Maps.newConcurrentMap();

    public UniqueDictTranslationsFile(String languageCode, IFile file, boolean keyCaseSensitive, boolean valueCaseSensitive, String comment) {
        super(languageCode, file, keyCaseSensitive, valueCaseSensitive, comment);
    }

    @Override
    public Collection<FeatureKey> getTranslationKeys(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        Collection keys = this.keysByValue.computeIfAbsent(this.hash(value), k -> this.createFeatureKeySet());
        Set<FeatureKey> copy = this.createFeatureKeySet();
        copy.addAll(keys);
        return copy;
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        super.load(reader);
        this.updateCounterCache();
        this.updateKeysByValue();
        Collection duplicating = this.counterCache.entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (String item : duplicating) {
            ArrayList<FeatureKey> keys = new ArrayList<FeatureKey>(this.getTranslationKeys(item));
            int i = 0;
            while (i < keys.size() - 1) {
                FeatureKey featureKey = (FeatureKey)keys.get(i);
                this.storage.remove(featureKey);
                this.comments.remove(featureKey);
                ++i;
            }
        }
        if (!duplicating.isEmpty()) {
            this.updateCounterCache();
            this.keysByValue.clear();
            this.updateKeysByValue();
        }
    }

    @Override
    public String removeTranslation(FeatureKey featureKey) {
        String removedValue = super.removeTranslation(featureKey);
        if (removedValue != null) {
            this.keysByValue.remove(this.hash(removedValue));
        }
        return removedValue;
    }

    @Override
    public String setTranslation(FeatureKey featureKey, String value, String comment) {
        String result = super.setTranslation(featureKey, value, comment);
        if (StringUtils.isNotEmpty((String)value)) {
            Collection keys = this.keysByValue.computeIfAbsent(this.hash(value), k -> this.createFeatureKeySet());
            keys.add(featureKey);
        } else {
            this.keysByValue.remove(this.hash(value));
        }
        return result;
    }

    private void updateKeysByValue() {
        for (Map.Entry entry : this.storage.entrySet()) {
            Collection keys = this.keysByValue.computeIfAbsent(this.hash((String)entry.getValue()), k -> this.createFeatureKeySet());
            keys.add((FeatureKey)entry.getKey());
        }
    }

    private Set<FeatureKey> createFeatureKeySet() {
        if (this.keyCaseSensitive) {
            return new LinkedHashSet<FeatureKey>();
        }
        return new TreeSet<FeatureKey>((o1, o2) -> o1.compareToIgnoreCase(o2));
    }

    private long hash(String string) {
        String lower = this.valueCaseSensitive ? string : string.toLowerCase();
        long h = 1125899906842597L;
        int len = lower.length();
        int i = 0;
        while (i < len) {
            h = 31L * h + (long)lower.charAt(i);
            ++i;
        }
        return h;
    }
}

