/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.internal.resourcestorage.Activator;
import com.e1c.langtool.v8.dt.resourcestorage.AbstractV8FileNameConverter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class V8FileNameConverter
extends AbstractV8FileNameConverter {
    private static final String FILE_EXTENSION_MDO = "mdo";
    private static final String FILE_EXTENSION_BSL = "bsl";
    private static final Set<String> BSL_NAMES = ImmutableSet.of((Object)"ObjectModule".toLowerCase(), (Object)"ManagerModule".toLowerCase(), (Object)"ValueManagerModule".toLowerCase(), (Object)"RecordSetModule".toLowerCase(), (Object)"CommandModule".toLowerCase(), (Object)"ManagedApplicationModule".toLowerCase(), (Object[])new String[]{"OrdinaryApplicationModule".toLowerCase(), "SessionModule".toLowerCase(), "ExternalConnectionModule".toLowerCase(), "Module".toLowerCase()});

    @Override
    public IPath getTranslationPath(IPath v8Path, boolean isLocalizable, TranslateLanguage language) {
        Assert.isLegal((v8Path != null ? 1 : 0) != 0, (String)"Argument 'v8Path' may not be null");
        Assert.isLegal((language != null ? 1 : 0) != 0, (String)"Argument 'language' may not be null");
        Assert.isLegal((!Strings.isNullOrEmpty((String)language.getLanguageCode()) ? 1 : 0) != 0, (String)"language code of the language argument may not be null or empty");
        if (!V8FileNameConverter.hasRootFolder(v8Path)) {
            return null;
        }
        String translationFileExtension = isLocalizable ? (FILE_EXTENSION_BSL.equals(v8Path.getFileExtension()) ? "nstr" : "lstr") : "trans";
        AbstractV8FileNameConverter.FileName fileName = new AbstractV8FileNameConverter.FileName(V8FileNameConverter.getNameSegment(v8Path), language.getLanguageCode(), translationFileExtension);
        IPath newPath = v8Path.removeLastSegments(1).append(fileName.toString()).addFileExtension(translationFileExtension);
        IProject parentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(v8Path.segment(0));
        this.injectFields();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(parentProject);
        IProject externalProject = this.translatingProjectManager.getLanguageProject(translatingProject, language);
        if (externalProject != null) {
            return externalProject.getFullPath().append(newPath.removeFirstSegments(1));
        }
        return null;
    }

    private IPath getSourcePathWithoutLastSegment(IPath translationPath) {
        this.injectFields();
        IProject externalProject = ResourcesPlugin.getWorkspace().getRoot().getFile(translationPath).getProject();
        return this.translatingProjectManager.getTranslatingForExternalProject(externalProject).map(translatingProject -> translatingProject.getProject().getFullPath().append(translationPath.removeFirstSegments(1))).orElse(null);
    }

    @Override
    public Set<IPath> getV8Path(IPath translationPath) {
        if (!this.isTranslation(translationPath)) {
            return Collections.emptySet();
        }
        HashSet paths = Sets.newHashSet();
        IPath newPath = this.getSourcePathWithoutLastSegment(translationPath);
        if (newPath == null) {
            return Collections.emptySet();
        }
        AbstractV8FileNameConverter.FileName fileName = new AbstractV8FileNameConverter.FileName(translationPath.lastSegment());
        if (FILE_EXTENSION_MDO.equals(fileName.segment)) {
            newPath = newPath.removeLastSegments(1);
            newPath = newPath.append(newPath.lastSegment()).addFileExtension(FILE_EXTENSION_MDO);
            paths.add(newPath);
        } else {
            newPath = newPath.removeLastSegments(1).append(fileName.segment);
            String segment = fileName.segment.toLowerCase();
            if (BSL_NAMES.contains(segment)) {
                newPath = newPath.addFileExtension(FILE_EXTENSION_BSL);
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("WSDefinition")) {
                newPath = newPath.addFileExtension("wsdl");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("Schedule")) {
                newPath = newPath.addFileExtension("schedule");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("Rights")) {
                newPath = newPath.addFileExtension("rights");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("Flowchart")) {
                newPath = newPath.addFileExtension("scheme");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("Package")) {
                newPath = newPath.addFileExtension("xdto");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("Template")) {
                paths.add(newPath.removeFileExtension().addFileExtension("bin"));
                paths.add(newPath.removeFileExtension().addFileExtension("mxlx"));
                paths.add(newPath.removeFileExtension().addFileExtension("dcs"));
                paths.add(newPath.removeFileExtension().addFileExtension("dcss"));
                paths.add(newPath.removeFileExtension().addFileExtension("htmldoc"));
                paths.add(newPath.removeFileExtension().addFileExtension("addin"));
            } else if (segment.equalsIgnoreCase("ClientApplicationInterface")) {
                newPath = newPath.addFileExtension("cai");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("CommandInterface")) {
                newPath = newPath.addFileExtension("cmi");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("Form")) {
                newPath = newPath.addFileExtension("form");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("ConditionalAppearance")) {
                newPath = newPath.addFileExtension("dcssca");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("SpreadsheetData")) {
                newPath = newPath.addFileExtension("mxlx");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("PlannerSettings")) {
                newPath = newPath.addFileExtension("pnrs");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("ListSettings")) {
                newPath = newPath.addFileExtension("dcss");
                paths.add(newPath);
            } else if (segment.equalsIgnoreCase("Chart")) {
                newPath = newPath.addFileExtension("chart");
                paths.add(newPath);
            } else if (newPath.segmentCount() > 1 && newPath.removeLastSegments(1).lastSegment().equalsIgnoreCase("Help")) {
                newPath = newPath.addFileExtension("html");
                paths.add(newPath);
            } else {
                newPath = newPath.addFileExtension(FILE_EXTENSION_MDO);
                paths.add(newPath);
            }
        }
        return paths;
    }

    private void injectFields() {
        if (this.translatingProjectManager == null) {
            Activator.getDefault().getInjector().injectMembers((Object)this);
        }
    }

    protected static String getNameSegment(IPath path) {
        IPath newPath = null;
        if (path.getFileExtension().equals(FILE_EXTENSION_MDO)) {
            newPath = path.removeFileExtension().removeLastSegments(1);
            newPath = newPath.append(FILE_EXTENSION_MDO);
        } else {
            newPath = path.removeFileExtension();
        }
        return newPath.lastSegment();
    }
}

