/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage.validation;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.internal.resourcestorage.Activator;
import com.e1c.langtool.v8.dt.resourcestorage.DictionaryRow;
import com.e1c.langtool.v8.dt.resourcestorage.IV8FileNameConverter;
import com.e1c.langtool.v8.dt.resourcestorage.TranslationFileRows;
import com.e1c.langtool.v8.dt.resourcestorage.TranslationsFileReader;
import com.e1c.langtool.v8.dt.resourcestorage.validation.CheckContext;
import com.e1c.langtool.v8.dt.resourcestorage.validation.IDictionaryStorageCheck;
import com.e1c.langtool.v8.dt.resourcestorage.validation.NotUniqueTranslationKeyCheck;
import com.e1c.langtool.v8.dt.resourcestorage.validation.SpecialSymbolCountCheck;
import com.e1c.langtool.v8.dt.resourcestorage.validation.StorageCheckAcceptor;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class CommonStorageValidator {
    private static final List<Class<? extends IDictionaryStorageCheck>> VALIDATORS_LIST = List.of(NotUniqueTranslationKeyCheck.class, SpecialSymbolCountCheck.class);
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    @Named(value="Common")
    private IV8FileNameConverter nameConverter;

    public void validate(IProject project, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Optional translating = this.translatingProjectManager.getTranslatingForExternalProject(project);
        if (translating.isEmpty() || !((ITranslatingProject)translating.get()).isTranslating()) {
            return;
        }
        IProject translatingProject = ((ITranslatingProject)translating.get()).getProject();
        List<StorageID> segments = this.storageSettingsManager.getReadStorageIds(translatingProject).stream().filter(s -> "com.e1c.langtool.v8.dt.resourcestorage.common".equals(s.getProviderId())).collect(Collectors.toList());
        ProjectSettings settings = new ProjectSettings(translatingProject);
        Collection languages = this.translatingProjectManager.getLanguagesForExternalProject(project);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)languages.size());
        for (TranslateLanguage language : languages) {
            if (monitor.isCanceled() || !TranslationOption.MODEL_AND_INTERFACE.equals((Object)language.getOption())) continue;
            this.checkLanguage(translatingProject, settings, segments, language, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private void checkLanguage(IProject project, ProjectSettings settings, List<StorageID> segments, TranslateLanguage language, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        List<IDictionaryStorageCheck> validators = VALIDATORS_LIST.stream().map(this::createValidator).filter(Objects::nonNull).collect(Collectors.toList());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)segments.size());
        for (StorageID segment : segments) {
            if (monitor.isCanceled()) {
                return;
            }
            this.checkSegment(project, settings, language, segment, validators, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private IDictionaryStorageCheck createValidator(Class<? extends IDictionaryStorageCheck> clazz) {
        try {
            return (IDictionaryStorageCheck)Activator.getDefault().getInjector().getInstance(clazz);
        }
        catch (Exception e) {
            Activator.logError(e);
            return null;
        }
    }

    private void checkSegment(IProject project, ProjectSettings settings, TranslateLanguage language, StorageID storageId, List<IDictionaryStorageCheck> validators, IProgressMonitor monitor) {
        IFile segmentFile = this.segmentFile(project, storageId, language);
        if (segmentFile == null || !segmentFile.isAccessible()) {
            return;
        }
        StorageCheckAcceptor acceptor = new StorageCheckAcceptor(segmentFile);
        TranslationsFileReader reader = new TranslationsFileReader(segmentFile);
        TranslationFileRows dictionary = new TranslationFileRows(language.getLanguageCode(), segmentFile, settings.modelKeyCaseSensitive, settings.modelValueCaseSensitive, null);
        CheckContext context = new CheckContext(segmentFile, storageId.getSegment(), language, settings, dictionary);
        boolean isSucess = reader.read(dictionary);
        if (!isSucess) {
            return;
        }
        int total = dictionary.getRows().size();
        total = total * validators.size() + total;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
        for (DictionaryRow row : dictionary.getRows()) {
            if (monitor.isCanceled()) {
                return;
            }
            for (IDictionaryStorageCheck validator : validators) {
                if (monitor.isCanceled()) {
                    return;
                }
                validator.validate(row, acceptor, context, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        try {
            ResourcesPlugin.getWorkspace().run(m -> {
                if (monitor.isCanceled()) {
                    return;
                }
                acceptor.clean();
                if (monitor.isCanceled()) {
                    return;
                }
                acceptor.flush(m);
            }, null, 1, (IProgressMonitor)subMonitor.newChild(total));
        }
        catch (CoreException e) {
            Activator.logError(e);
        }
        subMonitor.done();
    }

    private IFile segmentFile(IProject project, StorageID storageId, TranslateLanguage language) {
        try {
            IPath path = project.getFullPath().append("src").append(storageId.getSegment());
            IFile segmentFile = this.nameConverter.getTranslationFile(path, false, language);
            return segmentFile;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static final class ProjectSettings {
        protected final boolean interfaceKeyCaseSensitive;
        protected final boolean modelKeyCaseSensitive;
        protected final boolean modelValueCaseSensitive;
        protected final boolean modelValueUnique;

        public ProjectSettings(IProject p) {
            IEclipsePreferences pref = Activator.getDefault().getPreferences(p);
            this.interfaceKeyCaseSensitive = pref.getBoolean("dictionaryInterfaceKeyCaseSensitive", false);
            this.modelKeyCaseSensitive = pref.getBoolean("dictionaryModelKeyCaseSensitive", false);
            this.modelValueCaseSensitive = pref.getBoolean("dictionaryModelValueCaseSensitive", false);
            this.modelValueUnique = pref.getBoolean("dictionaryModelValueUnique", true);
        }
    }
}

