/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage.validation;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.v8.dt.resourcestorage.DictionaryRow;
import com.e1c.langtool.v8.dt.resourcestorage.validation.CheckContext;
import com.e1c.langtool.v8.dt.resourcestorage.validation.ICheckAcceptor;
import com.e1c.langtool.v8.dt.resourcestorage.validation.IDictionaryStorageCheck;
import com.e1c.langtool.v8.dt.resourcestorage.validation.Messages;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.core.runtime.IProgressMonitor;

public class NotUniqueTranslationKeyCheck
implements IDictionaryStorageCheck {
    private static final String ID = "NotUniqueTranslationCheck";
    private final Map<String, List<String>> existKeys = Maps.newHashMap();

    @Override
    public void validate(DictionaryRow row, ICheckAcceptor acceptor, CheckContext context, IProgressMonitor monitor) {
        FeatureKey key = row.getKey();
        if (key.getSegments().size() == 0) {
            return;
        }
        this.existKeys.compute(key.toString(), (keyDict, segmentList) -> {
            if (segmentList == null) {
                segmentList = new ArrayList<String>();
            }
            segmentList.add(context.getSegment());
            if (segmentList.size() > 1) {
                acceptor.acceptWarning(ID, MessageFormat.format(Messages.NotUniqueTranslationCheck_Message, this.segmentDescription((List<String>)segmentList), keyDict), row);
            }
            return segmentList;
        });
    }

    private Object segmentDescription(List<String> segmentList) {
        StringJoiner builder = new StringJoiner(", ");
        segmentList.forEach(segemnt -> {
            StringJoiner stringJoiner2 = builder.add((CharSequence)segemnt);
        });
        return "\"" + builder.toString() + "\"";
    }
}

