/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.md.help;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.Help;
import com._1c.g5.v8.dt.md.help.MdHelpUtil;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.core.ext.IResourceContentImporterExtension;
import com.e1c.langtool.v8.dt.internal.md.help.AbstractHelpPageExtension;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class HelpPageImporterExtension
extends AbstractHelpPageExtension
implements IResourceContentImporterExtension {
    private static final String ORIG_DATA_STREAM = "original_data";
    private static final String HELP_PATH = "Help";
    private static final String HTML_EXTENSION = "html";
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IResourceLookup resourceLookup;

    public Collection<EClass> targets() {
        return TOP_HELP_HOLDERS;
    }

    public void afterImport(IBmEngine engine, IBmTransaction transaction, Resource resource, IPath path, IBmObject importedObject) {
        IProject project = this.resourceLookup.getProject((EObject)importedObject);
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return;
        }
        for (TranslateLanguage language : translating.getInterfaceLanguages()) {
            IPath helpPath;
            IFile pageFile;
            IProject sourceProject = this.translatingProjectManager.getLanguageProject(translating, language);
            if (sourceProject == null || sourceProject.equals((Object)project) || !(pageFile = sourceProject.getFile(helpPath = path.removeLastSegments(1).append(HELP_PATH).append(language.getLanguageCode()).addFileExtension(HTML_EXTENSION))).exists()) continue;
            this.importContent(transaction, importedObject, language);
        }
    }

    private void importContent(IBmTransaction transaction, IBmObject importedObject, TranslateLanguage language) {
        Help help = MdHelpUtil.getHelp((EObject)importedObject);
        if (help != null) {
            MdHelpUtil.getHelpPage((Help)help, (String)language.getLanguageCode(), (IBmTransaction)transaction);
        }
    }
}

