/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.md.help;

import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.core.lifecycle.ProjectContext;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.ide.ConfigurationFileSystemSupport;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com._1c.g5.v8.dt.mcore.HelpPage;
import com._1c.g5.v8.dt.md.IExternalPropertyManagerRegistry;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

@LifecycleService(name="HelpPageProjectFileSystemSupportExtension")
@Singleton
public class HelpPageProjectFileSystemSupportExtension {
    private final ITranslatingProjectManager translatingProjectManager;
    private final IProjectFileSystemSupportProvider projectFileSystemSupportProvider;
    private final IBmModelManager bmModelManager;
    private final IExternalPropertyManagerRegistry externalPropertyManagerRegistry;

    @Inject
    public HelpPageProjectFileSystemSupportExtension(IProjectFileSystemSupportProvider projectFileSystemSupportProvider, ITranslatingProjectManager translatingProjectManager, IBmModelManager bmModelManager, IExternalPropertyManagerRegistry externalPropertyManagerRegistry) {
        this.projectFileSystemSupportProvider = projectFileSystemSupportProvider;
        this.translatingProjectManager = translatingProjectManager;
        this.bmModelManager = bmModelManager;
        this.externalPropertyManagerRegistry = externalPropertyManagerRegistry;
    }

    @LifecycleParticipant(phase=LifecyclePhase.INITIALIZATION, dependsOn={"DtProjectManager"})
    public void init(ProjectContext projectContext) {
        IDtProject dtProject = projectContext.getProject();
        IProject project = dtProject.getWorkspaceProject();
        if (project == null) {
            return;
        }
        this.projectFileSystemSupportProvider.registerProjectFileSystemSupportExtension(project, (IProjectFileSystemSupport)new HelpPageProjectFileSystemSupport(dtProject, project, this.translatingProjectManager, this.bmModelManager, this.externalPropertyManagerRegistry));
    }

    private static class HelpPageProjectFileSystemSupport
    extends ConfigurationFileSystemSupport {
        private final IProject project;
        private final ITranslatingProjectManager translatingProjectManager;

        public HelpPageProjectFileSystemSupport(IDtProject dtProject, IProject project, ITranslatingProjectManager translatingProjectManager, IBmModelManager bmModelManager, IExternalPropertyManagerRegistry externalPropertyManagerRegistry) {
            super(dtProject, project, bmModelManager, externalPropertyManagerRegistry);
            this.project = project;
            this.translatingProjectManager = translatingProjectManager;
        }

        public IFile getFile(EObject eObject) {
            if (!(eObject instanceof HelpPage)) {
                return null;
            }
            IFile result = super.getFile(eObject);
            HelpPage page = (HelpPage)eObject;
            ITranslatingProject translating = this.translatingProjectManager.getProject(this.project);
            Map<String, TranslateLanguage> languageCodes = this.getLanguageCodes(translating);
            if (!languageCodes.isEmpty() && languageCodes.containsKey(page.getLang())) {
                TranslateLanguage language = languageCodes.get(page.getLang());
                IProject languageProject = this.translatingProjectManager.getLanguageProject(translating, language);
                if (this.project != null && !this.project.equals((Object)languageProject)) {
                    result = languageProject.getFile(result.getProjectRelativePath());
                }
            }
            return result;
        }

        public IFile getFile(EObject eObject, EReference feature) {
            return null;
        }

        public IPath getPath(EObject eObject) {
            return super.getPath(eObject);
        }

        public IPath getPath(EObject context, EReference feature) {
            return super.getPath(context, feature);
        }

        private Map<String, TranslateLanguage> getLanguageCodes(ITranslatingProject translating) {
            HashMap languageCodes = Maps.newHashMap();
            if (translating != null && translating.isTranslating()) {
                translating.getInterfaceLanguages().forEach(l -> languageCodes.put(l.getLanguageCode(), l));
            }
            return languageCodes;
        }
    }
}

