/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.help.sync;

import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.mcore.Help;
import com._1c.g5.v8.dt.mcore.HelpPage;
import com._1c.g5.v8.dt.metadata.mdclass.BasicDbObject;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.htmldocument.sync.AbstractHtmlPageSynchronizer;
import com.e1c.langtool.v8.dt.htmldocument.sync.HtmlUtils;
import com.e1c.langtool.v8.dt.internal.md.help.HelpPlugin;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public class HelpPageSynchronizer
extends AbstractHtmlPageSynchronizer {
    private static final String ID = "com.e1c.langtool.v8.dt.md.help.HelpPage";
    private static final Pattern HTML_NAME_PATTERN = Pattern.compile("^(?<name>.+?)[/,\\\\]Help[/,\\\\](?<lang>[^\\.]+)\\.(?i)html$", 256);
    private static final String LANG_PATTERN_GROUP = "lang";
    @Inject
    private TranslationPreferences preferences;

    public String getId() {
        return ID;
    }

    public Collection<IResource> synchronize(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        IPath sourcePath = sourceFile.getProjectRelativePath();
        Matcher matcher = HTML_NAME_PATTERN.matcher(sourcePath.toString());
        if (!matcher.find()) {
            return result;
        }
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(sourcePath);
        if (fqn == null || fqn.isEmpty()) {
            if (HelpPlugin.getDefault().isDebugging()) {
                System.out.println("FQN is empty. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        if (!sourceFile.isAccessible() || !(session instanceof BmSyncSession)) {
            if (HelpPlugin.getDefault().isDebugging()) {
                System.out.println("Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        BmSyncSession bmSession = (BmSyncSession)session;
        IProjectTranslationProvider translationProvider = bmSession.getTranslationProvider();
        TranslationProperties properties = this.preferences.getTranslationProperties(sourceProject.getProject());
        String languageCode = matcher.group(LANG_PATTERN_GROUP);
        List languageCodes = this.getLanguageCodes(bmSession.getTranslationProvider());
        if (!languageCodes.contains(languageCode) && !properties.fillEmptyHelpTranslationFromSource()) {
            return result;
        }
        IBmModel model = this.modelManager.getModel(sourceProject.getProject());
        if (model == null) {
            return result;
        }
        boolean newTransaction = false;
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(false);
            newTransaction = true;
        }
        try {
            EObject owner = HtmlUtils.resolveObject((IBmTransaction)transaction, (QualifiedName)fqn.skipLast(2), (IQualifiedNameConverter)this.qualifiedNameConverter);
            if (owner == null) {
                if (HelpPlugin.getDefault().isDebugging()) {
                    System.out.println("Owner not found. Cannot synchronize file: " + sourceFile.getFullPath().toString());
                }
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            String translatedFqn = this.topObjectFqnGenerator.generateFqn(owner, translationProvider);
            String filePath = null;
            if (translatedFqn != null) {
                QualifiedName newFqn = this.qualifiedNameConverter.toQualifiedName(translatedFqn);
                if (newFqn.getSegmentCount() == 2) {
                    filePath = this.qualifiedNameFilePathConverter.getFilePath(newFqn);
                    Path path = new Path(filePath);
                    filePath = path.removeLastSegments(1).append(sourcePath.removeFirstSegments(sourcePath.segmentCount() - 2)).toString();
                } else {
                    newFqn = newFqn.append(fqn.skipFirst(fqn.skipLast(2).getSegmentCount()));
                    filePath = this.qualifiedNameFilePathConverter.getFilePath(newFqn);
                }
            }
            if (filePath == null) {
                if (HelpPlugin.getDefault().isDebugging()) {
                    System.out.println("Target file path is empty. Cannot synchronize file: " + sourceFile.getFullPath().toString());
                }
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            IFile targetFile = target.getProject().getFile(filePath);
            if (languageCodes.contains(languageCode)) {
                try {
                    this.synchronize(sourceFile, targetFile, bmSession);
                    result.add(targetFile);
                }
                catch (IOException | CoreException e) {
                    IStatus status = HelpPlugin.createErrorStatus(MessageFormat.format("Failed synchronizing file: \"{0}\" to: \"{1}\"", sourceFile, targetFile), e);
                    HelpPlugin.log(status);
                    LinkedHashSet linkedHashSet = result;
                    if (newTransaction) {
                        transaction.rollback();
                    }
                    return linkedHashSet;
                }
            }
            if (properties.fillEmptyHelpTranslationFromSource()) {
                this.synchronizeDependentEmptyLanguages(owner, sourceFile, sourceProject, targetFile, target, properties, bmSession, result);
            }
            LinkedHashSet linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newTransaction) {
                transaction.rollback();
            }
        }
    }

    private void synchronizeDependentEmptyLanguages(EObject eObject, IFile sourceFile, ITranslatingProject sourceProject, IFile targetFile, ITranslatedProject target, TranslationProperties properties, BmSyncSession bmSession, Collection<IResource> result) {
        Help help = ((BasicDbObject)eObject).getHelp();
        List<String> langs = this.getPages(help);
        block2: for (TranslateLanguage language : sourceProject.getInterfaceLanguages()) {
            if (langs.contains(language.getLanguageCode())) continue;
            TranslateLanguage newLang = properties.getLanguageToFillEmptyInterfaceTranslation(language);
            if (newLang == null) {
                return;
            }
            HashSet checked = Sets.newHashSet((Object[])new String[]{language.getLanguageCode()});
            while (newLang != null && !checked.contains(newLang.getLanguageCode())) {
                if (!langs.contains(newLang.getLanguageCode())) {
                    checked.add(newLang.getLanguageCode());
                    newLang = properties.getLanguageToFillEmptyInterfaceTranslation(newLang);
                    continue;
                }
                String sourceLangCode = sourceFile.getFullPath().removeFileExtension().lastSegment();
                if (!sourceLangCode.equals(newLang.getLanguageCode())) continue block2;
                IPath targetPath = targetFile.getProjectRelativePath().removeLastSegments(1).append(language.getLanguageCode()).addFileExtension("html");
                IFile tFile = target.getProject().getFile(targetPath);
                try {
                    this.synchronize(sourceFile, tFile, bmSession);
                    result.add((IResource)tFile);
                    checked.add(newLang.getLanguageCode());
                }
                catch (IOException | CoreException e) {
                    IStatus status = HelpPlugin.createErrorStatus(MessageFormat.format("Failed synchronizing file: \"{0}\" to: \"{1}\"", sourceFile, tFile), e);
                    HelpPlugin.log(status);
                }
            }
        }
    }

    private List<String> getPages(Help help) {
        return help.getPages().stream().map(HelpPage::getLang).collect(Collectors.toList());
    }
}

