/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.yandex.ui;

import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.InvalidAccessKeyException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.external.cache.ITranslationCacheManager;
import com.e1c.langtool.ui.ViewUtils;
import com.e1c.langtool.ui.external.AbstractTranslationPreferencePage;
import com.e1c.langtool.ui.external.ExternalTranslationView;
import com.e1c.langtool.yandex.YandexPreferenceConstants;
import com.e1c.langtool.yandex.internal.ui.UiPlugin;
import com.e1c.langtool.yandex.ui.Messages;
import com.google.inject.Inject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class YandexTranslatePreferencePage
extends AbstractTranslationPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.e1c.langtool.yandex.ui.yandexTranslatePreferencePage";
    private static final String GETTING_KEY_URL = "https://cloud.yandex.ru/docs/iam/operations/api-key/create";
    private Text folderIdText;
    protected Text apiKeyText;
    private Text modelText;

    @Inject
    public YandexTranslatePreferencePage(ITranslationCacheManager translationCacheManager) {
        super(translationCacheManager, "com.e1c.langtool.yandex.yandexTranslateProvider");
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.e1c.langtool.yandex");
        this.setPreferenceStore((IPreferenceStore)prefs);
        this.setDescription(Messages.YandexTranslatePreferencePage_Description);
    }

    protected void createAccessKeyGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(Messages.YandexTranslatePreferencePage_Access_group_text);
        new Label((Composite)group, 0).setText(Messages.YandexTranslatePreferencePage_Folder_ID);
        this.folderIdText = new Text((Composite)group, 0x400800);
        this.folderIdText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.folderIdText.setMessage(Messages.YandexTranslatePreferencePage_Folder_ID_message);
        new Label((Composite)group, 0).setText(Messages.YandexTranslatePreferencePage_API_key);
        this.apiKeyText = new Text((Composite)group, 0x400800);
        this.apiKeyText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.apiKeyText.setMessage(Messages.YandexTranslatePreferencePage_API_key_message);
        new Label((Composite)group, 0);
        Composite composite = new Composite((Composite)group, 0);
        GridData gridData = new GridData(131072, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, true);
        composite.setLayout((Layout)layout);
        this.createCheckAccessKeyButton(composite);
        this.createGetAccessKeyLink(composite);
        Group group2 = new Group(parent, 0);
        group2.setLayoutData((Object)new GridData(4, 4, true, false));
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setText(Messages.YandexTranslatePreferencePage_Model_ID_group_text);
        new Label((Composite)group2, 0).setText(Messages.YandexTranslatePreferencePage_Model_ID);
        this.modelText = new Text((Composite)group2, 2048);
        this.modelText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.modelText.setMessage(Messages.YandexTranslatePreferencePage_Model_ID_message);
    }

    protected String getAccessKey() {
        return this.apiKeyText.getText();
    }

    protected void reloadView() {
        ExternalTranslationView view = (ExternalTranslationView)ViewUtils.getView((String)"com.e1c.langtool.yandex.ui.yandexTranslateView");
        if (view != null && !view.isInitialized()) {
            ViewUtils.reloadView((String)"com.e1c.langtool.yandex.ui.yandexTranslateView");
        }
    }

    protected SelectionListener createLinkSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)YandexTranslatePreferencePage.GETTING_KEY_URL);
            }
        };
    }

    protected boolean checkAccessKey(String key) {
        String folderId = this.folderIdText.getText();
        IExternalTranslationManager translationManger = (IExternalTranslationManager)UiPlugin.getDefault().getInjector().getInstance(IExternalTranslationManager.class);
        IExternalTranslationProvider provider = translationManger.getTranslationProviderRegistry().getExternalTranslationProvider("com.e1c.langtool.yandex.yandexTranslateProvider");
        String currentKey = this.doGetPreferenceStore().getString("apiKey");
        String currentFolderId = this.doGetPreferenceStore().getString("folderId");
        this.doGetPreferenceStore().setValue("apiKey", key);
        this.doGetPreferenceStore().setValue("folderId", folderId);
        try {
            try {
                provider.getLanguages("en");
            }
            catch (InvalidAccessKeyException exc) {
                this.doGetPreferenceStore().setValue("apiKey", currentKey);
                this.doGetPreferenceStore().setValue("folderId", currentFolderId);
                return false;
            }
            catch (TranslationServiceException e) {
                throw e;
            }
        }
        finally {
            this.doGetPreferenceStore().setValue("apiKey", currentKey);
            this.doGetPreferenceStore().setValue("folderId", currentFolderId);
        }
        return true;
    }

    protected void performDefaults() {
        this.doGetPreferenceStore().setValue("folderId", YandexPreferenceConstants.DEFAULT_FOLDER_ID);
        this.doGetPreferenceStore().setValue("apiKey", YandexPreferenceConstants.DEFAULT_API_KEY);
        this.doGetPreferenceStore().setValue("modelId", YandexPreferenceConstants.DEFAULT_MODEL_ID);
        super.performDefaults();
    }

    protected void storeValues() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String oldValue = preferenceStore.getString("apiKey");
        String folderIdOldValue = preferenceStore.getString("folderId");
        String newApiKey = this.apiKeyText.getText();
        String folderIdNewValue = this.folderIdText.getText();
        if (!oldValue.equals(newApiKey) || !folderIdOldValue.equals(folderIdNewValue)) {
            this.isApiKeyValueChanged = true;
            preferenceStore.setValue("apiKey", newApiKey);
            preferenceStore.setValue("folderId", folderIdNewValue);
        }
        String newModel = this.modelText.getText();
        preferenceStore.setValue("modelId", newModel);
    }

    protected void initializeValues() {
        this.folderIdText.setText(this.getPreferenceStore().getString("folderId"));
        this.apiKeyText.setText(this.getPreferenceStore().getString("apiKey"));
        this.modelText.setText(this.getPreferenceStore().getString("modelId"));
    }
}

