/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.commands;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.ui.generatestring.GenerateTranslationStringsWizard;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateTranslationStringsHandler
extends AbstractHandler {
    @Inject
    private Provider<GenerateTranslationStringsWizard> provider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        Map<IProject, Collection<TranslationSource>> projectSelection = this.getSelectedObjects(selection);
        for (IProject project : projectSelection.keySet()) {
            if (project == null) continue;
            GenerateTranslationStringsWizard wizard = this.getGenerateTranslationStringsWizard();
            wizard.init(project, projectSelection.get(project));
            WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (IWizard)wizard);
            dialog.open();
            break;
        }
        return null;
    }

    private Map<IProject, Collection<TranslationSource>> getSelectedObjects(ISelection selection) {
        HashMap projectSelection = Maps.newHashMap();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            for (Object element : strucSelection) {
                if (element instanceof IProject) {
                    Collection elements = (Collection)projectSelection.get(element);
                    if (elements != null) continue;
                    projectSelection.put((IProject)element, Lists.newArrayList());
                    continue;
                }
                TranslationSource source = TranslationUtils.getTranslationSource(element);
                if (source == null || source.getProject() == null) continue;
                Collection elements = (Collection)projectSelection.get(source.getProject());
                if (elements == null) {
                    elements = Lists.newArrayList();
                }
                elements.add(source);
                projectSelection.put(source.getProject(), elements);
            }
        }
        return projectSelection;
    }

    private GenerateTranslationStringsWizard getGenerateTranslationStringsWizard() {
        return (GenerateTranslationStringsWizard)((Object)this.provider.get());
    }
}

