/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.commands;

import com.e1c.langtool.ignore.TransIgnoreFile;
import com.e1c.langtool.ignore.TransIgnoreFileUtil;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class IgnoreResourceTranslationHandler
extends AbstractHandler {
    @Inject
    private ITranslatingProjectManager projectManager;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Map<IPath, List<IResource>> resources = this.getResources(event).stream().filter(r -> this.projectManager.getProject(r.getProject()).isTranslating()).collect(Collectors.groupingBy(r -> r.getFullPath().removeLastSegments(1)));
        for (Map.Entry<IPath, List<IResource>> entry : resources.entrySet()) {
            this.addIgnoreFile(entry.getKey(), entry.getValue());
        }
        return null;
    }

    private Collection<IResource> getResources(ExecutionEvent event) {
        ArrayList items = Lists.newArrayList();
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object item : sel) {
                if (item instanceof IFolder) {
                    items.add((IFolder)item);
                    continue;
                }
                if (!(item instanceof IFile)) continue;
                items.add((IFile)item);
            }
        }
        List folders = items.stream().filter(IFolder.class::isInstance).map(IResource::getFullPath).collect(Collectors.toList());
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            IResource res = (IResource)iterator.next();
            IPath path = res.getFullPath();
            if (!(res instanceof IFile) || !folders.stream().anyMatch(f -> f.isPrefixOf(path))) continue;
            iterator.remove();
        }
        return items;
    }

    private void addIgnoreFile(final IPath path, final List<IResource> values) {
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path.append(".transignore"));
        Job job = new Job("Saving ignore file"){

            protected IStatus run(IProgressMonitor monitor) {
                TransIgnoreFile ignoreFile = TransIgnoreFileUtil.createNew((IPath)file.getProjectRelativePath().removeLastSegments(1));
                if (file.exists()) {
                    try {
                        TransIgnoreFileUtil.load((TransIgnoreFile)ignoreFile, (IFile)file);
                    }
                    catch (IOException | CoreException e) {
                        String message = MessageFormat.format("Cannot read trans ignore file: {0}", file);
                        IStatus status = UiPlugin.createErrorStatus(message, e);
                        UiPlugin.log(status);
                        return status;
                    }
                }
                for (IResource source : values) {
                    IPath pathToIgnore = source.getFullPath().removeFirstSegments(path.segmentCount());
                    if (ignoreFile.ignoreAllChildren(source.getProjectRelativePath())) continue;
                    if (source instanceof IFolder) {
                        ignoreFile.addLine((TransIgnoreFile.Line)new TransIgnoreFile.Rule(pathToIgnore.toString() + "/*", "*"));
                        continue;
                    }
                    ignoreFile.addLine((TransIgnoreFile.Line)new TransIgnoreFile.Rule(pathToIgnore.toString(), "*"));
                }
                try {
                    TransIgnoreFileUtil.save((TransIgnoreFile)ignoreFile, (IFile)file, (IProgressMonitor)monitor);
                }
                catch (IOException | CoreException e) {
                    return UiPlugin.createErrorStatus(MessageFormat.format("Error while saving file: {0}", file.getFullPath()), e);
                }
                return Status.OK_STATUS;
            }
        };
        if (file.isAccessible()) {
            job.setRule((ISchedulingRule)file);
        }
        job.schedule();
    }
}

