/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.common.tools;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class CustomText
extends Text {
    public static final int DEFAULT_MAX_HEIGHT = 80;
    public static final int DEFAULT_MIN_HEIGHT = 26;
    private int maxHeight = 80;
    private int minHeight = 26;
    private ControlDecoration errorDecorator;
    private boolean emptyText = true;

    public CustomText(Composite parent, int style, int errorDectorationPos, String errorMsg) {
        super(parent, style);
        this.initErrorDecorator(errorDectorationPos, errorMsg);
        this.initMessageHandler();
    }

    public CustomText(Composite parent, int style, String errorMsg) {
        this(parent, style, 16512, errorMsg);
    }

    public void setMaxHeight(int height) {
        if (height >= 0 || height > this.minHeight) {
            this.maxHeight = height;
        }
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMinHeight(int height) {
        if (height >= 0 || height < this.maxHeight) {
            this.minHeight = height;
        }
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void showError() {
        this.errorDecorator.show();
        this.errorDecorator.showHoverText(this.errorDecorator.getDescriptionText());
    }

    public void hideError() {
        this.errorDecorator.hide();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point preferredSize = super.computeSize(wHint, hHint, changed);
        int height = Math.max(preferredSize.y, this.minHeight);
        return new Point(preferredSize.x, Math.min(height, this.maxHeight));
    }

    public void setText(String string) {
        if (!string.isEmpty()) {
            this.emptyText = false;
            this.setTextFont(TextFontType.ACTIVE);
            super.setText(string);
        } else {
            this.emptyText = true;
            this.setTextFont(TextFontType.NON_ACTIVE);
            super.setText(this.getMessage());
        }
    }

    public void setMessage(String message) {
        super.setMessage(message);
        this.emptyText = true;
        this.setTextFont(TextFontType.NON_ACTIVE);
        super.setText(message);
    }

    protected void checkSubclass() {
    }

    private void initErrorDecorator(int position, String errorMsg) {
        this.errorDecorator = new ControlDecoration((Control)this, position);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image errorIcon = fieldDecoration.getImage();
        this.errorDecorator.setImage(errorIcon);
        this.errorDecorator.setDescriptionText(errorMsg);
        this.errorDecorator.hide();
        this.addModifyListener(event -> this.errorDecorator.hide());
    }

    private void initMessageHandler() {
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (CustomText.this.getText().length() == 0) {
                    CustomText.this.emptyText = true;
                } else if (CustomText.this.emptyText) {
                    CustomText.this.emptyText = false;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (CustomText.this.emptyText) {
                    CustomText.this.setTextFont(TextFontType.NON_ACTIVE);
                    CustomText.super.setText(CustomText.this.getMessage());
                }
            }

            public void focusGained(FocusEvent e) {
                CustomText.this.setTextFont(TextFontType.ACTIVE);
                if (CustomText.this.emptyText) {
                    CustomText.super.setText("");
                }
            }
        });
    }

    private void setTextFont(TextFontType type) {
        if (type == TextFontType.ACTIVE) {
            this.setForeground(this.getDisplay().getSystemColor(2));
        } else if (type == TextFontType.NON_ACTIVE) {
            this.setForeground(this.getDisplay().getSystemColor(16));
        }
    }

    private static enum TextFontType {
        ACTIVE,
        NON_ACTIVE;

    }
}

