/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.preferences;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.internal.ui.preferences.Messages;
import com.e1c.langtool.internal.ui.preferences.TranslationPreferences;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TranslationRootPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String LANGUAGE_CODE_REGEX = "[a-z]+[a-zA-Z_-]*";
    protected final Map<Text, String> errors = new HashMap<Text, String>();
    private Button keyTreeHierarchical;
    private Button keyTreeExpanded;
    private Text showLanguagesInTree;
    private Button showInterface;
    private Button showModel;
    private Button showComputed;
    private Button showChildObjects;
    private Button showSubresources;
    private Button showAllValues;
    private Button hideFilledTranslation;
    private List<String> showOnlyLanguagesList;
    private ListViewer viewer;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(UiPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore prefs = this.getPreferenceStore();
        Composite field = null;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.TranslationRootPreferencePage_Cotect_translation_panel);
        field = this.createFieldComposite((Composite)group);
        this.showInterface = new Button(field, 32);
        this.showInterface.setSelection(prefs.getBoolean("showInterface"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Show_interface_strings);
        field = this.createFieldComposite((Composite)group);
        this.showModel = new Button(field, 32);
        this.showModel.setSelection(prefs.getBoolean("showModel"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Show_model_strings);
        field = this.createFieldComposite((Composite)group);
        this.showComputed = new Button(field, 32);
        this.showComputed.setSelection(prefs.getBoolean("showComputed"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Show_items_with_any_extra_strings_translation);
        field = this.createFieldComposite((Composite)group);
        this.showChildObjects = new Button(field, 32);
        this.showChildObjects.setSelection(prefs.getBoolean("showChildObjects"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Show_items_from_child_objects);
        field = this.createFieldComposite((Composite)group);
        this.showSubresources = new Button(field, 32);
        this.showSubresources.setSelection(prefs.getBoolean("showSubresources"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Show_items_from_sub_resources);
        field = this.createFieldComposite((Composite)group);
        this.showAllValues = new Button(field, 32);
        this.showAllValues.setSelection(prefs.getBoolean("showAllValues"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Show_all_values);
        field = this.createFieldComposite((Composite)group);
        this.hideFilledTranslation = new Button(field, 32);
        this.hideFilledTranslation.setSelection(prefs.getBoolean("hideFilledTranslation"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Hide_items_with_filled_translation);
        field = this.createFieldComposite((Composite)group);
        this.keyTreeHierarchical = new Button(field, 32);
        this.keyTreeHierarchical.setSelection(prefs.getBoolean("keyTreeHierarchical"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Key_tree_is_hierarchical_by_default);
        field = this.createFieldComposite((Composite)group);
        this.keyTreeExpanded = new Button(field, 32);
        this.keyTreeExpanded.setSelection(prefs.getBoolean("keyTreeExpanded"));
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_Key_tree_is_expanded_by_default);
        field = this.createFieldComposite((Composite)group);
        new Label(field, 0).setText(Messages.TranslationRootPreferencePage_How_many_languages_to_show_them_in_tree);
        this.showLanguagesInTree = new Text(field, 2048);
        this.showLanguagesInTree.setText(prefs.getString("showLanguagesInTree"));
        this.showLanguagesInTree.setTextLimit(3);
        GridData gd = new GridData();
        gd.widthHint = 50;
        this.showLanguagesInTree.setLayoutData((Object)gd);
        this.showLanguagesInTree.addKeyListener((KeyListener)new IntTextValidatorKeyListener(Messages.TranslationRootPreferencePage_The_language_number_must_be_numeric));
        this.showOnlyLanguagesList = Lists.newArrayList((Object[])TranslationPreferences.getShowOnlyLanguages());
        Group group2 = new Group(composite, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        group2.setLayout((Layout)gridLayout2);
        GridData data2 = new GridData(768);
        group2.setLayoutData((Object)data2);
        group2.setText(Messages.TranslationRootPreferencePage_Show_only_listed_language_codes_for_me);
        this.viewer = new ListViewer((Composite)group2);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput(this.showOnlyLanguagesList);
        GridData gd2 = new GridData();
        gd2.widthHint = 150;
        this.viewer.getControl().setLayoutData((Object)gd2);
        Composite buttonsCompsite = new Composite((Composite)group2, 0);
        GridLayout buttonlayout = new GridLayout(1, false);
        buttonsCompsite.setLayout((Layout)buttonlayout);
        buttonsCompsite.setLayoutData((Object)new GridData(256));
        Button addButton = new Button(buttonsCompsite, 8);
        addButton.setText(Messages.TranslationRootPreferencePage_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog input = new InputDialog(TranslationRootPreferencePage.this.getShell(), Messages.TranslationRootPreferencePage_Input_language_code, Messages.TranslationRootPreferencePage_Language_code, "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (StringUtils.isNullOrEmpty((String)newText)) {
                            return Messages.TranslationRootPreferencePage_Language_code_cannot_be_empty;
                        }
                        if (!newText.matches(TranslationRootPreferencePage.LANGUAGE_CODE_REGEX)) {
                            return Messages.TranslationRootPreferencePage_Language_code_can_starts_from_a_z_and_contains_only_A_Z;
                        }
                        return null;
                    }
                });
                if (input.open() == 0 && !TranslationRootPreferencePage.this.showOnlyLanguagesList.contains(input.getValue())) {
                    TranslationRootPreferencePage.this.showOnlyLanguagesList.add(input.getValue());
                    TranslationRootPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button removeButton = new Button(buttonsCompsite, 8);
        removeButton.setText(Messages.TranslationRootPreferencePage_Remove);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TranslationRootPreferencePage.this.viewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)TranslationRootPreferencePage.this.viewer.getSelection();
                    for (Object sel : ss) {
                        TranslationRootPreferencePage.this.showOnlyLanguagesList.remove(sel);
                    }
                    TranslationRootPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        removeButton.setEnabled(false);
        return composite;
    }

    public boolean performOk() {
        IPreferenceStore prefs = this.getPreferenceStore();
        prefs.setValue("showInterface", this.showInterface.getSelection());
        prefs.setValue("showModel", this.showModel.getSelection());
        prefs.setValue("showComputed", this.showComputed.getSelection());
        prefs.setValue("showChildObjects", this.showChildObjects.getSelection());
        prefs.setValue("showSubresources", this.showSubresources.getSelection());
        prefs.setValue("showAllValues", this.showAllValues.getSelection());
        prefs.setValue("hideFilledTranslation", this.hideFilledTranslation.getSelection());
        prefs.setValue("keyTreeHierarchical", this.keyTreeHierarchical.getSelection());
        prefs.setValue("keyTreeExpanded", this.keyTreeExpanded.getSelection());
        prefs.setValue("showLanguagesInTree", this.showLanguagesInTree.getText());
        ArrayList list = Lists.newArrayList();
        this.showOnlyLanguagesList.forEach(language -> {
            if (StringUtils.isNotEmpty((String)language) && !list.contains(language)) {
                list.add(language.trim());
            }
        });
        String showOnlyLanguages = String.join((CharSequence)",", list);
        prefs.setValue("showOnlyLanguages", showOnlyLanguages);
        return super.performOk();
    }

    protected Composite createFieldComposite(Composite parent) {
        return this.createFieldComposite(parent, 0);
    }

    protected Composite createFieldComposite(Composite parent, int indent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = indent;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected class IntTextValidatorKeyListener
    extends KeyAdapter {
        private String errMsg = null;

        public IntTextValidatorKeyListener(String errMsg) {
            this.errMsg = errMsg;
        }

        public void keyReleased(KeyEvent event) {
            Text text = (Text)event.widget;
            String value = text.getText();
            event.doit = value.matches("^\\d*$");
            if (event.doit) {
                TranslationRootPreferencePage.this.errors.remove(text);
                if (TranslationRootPreferencePage.this.errors.isEmpty()) {
                    TranslationRootPreferencePage.this.setErrorMessage(null);
                    TranslationRootPreferencePage.this.setValid(true);
                } else {
                    TranslationRootPreferencePage.this.setErrorMessage(TranslationRootPreferencePage.this.errors.values().iterator().next());
                }
            } else {
                TranslationRootPreferencePage.this.errors.put(text, this.errMsg);
                TranslationRootPreferencePage.this.setErrorMessage(this.errMsg);
                TranslationRootPreferencePage.this.setValid(false);
            }
        }
    }
}

