/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.view;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.internal.ui.view.FeatureValueCellEditorValidator;
import com.e1c.langtool.internal.ui.view.FeatureValueTextCellEditor;
import com.e1c.langtool.internal.ui.view.LanguageFeatureValueItem;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class LanguageItemViewerTextEditingSupport
extends EditingSupport {
    @Inject
    private ValidatorRegistry registry;
    @Inject
    private ITranslationStorageManager translationStorageManager;
    private final TextCellEditor cellEditor;
    private final IEditingContext context;
    private final IProject project;
    private final StorageID storageId;

    public LanguageItemViewerTextEditingSupport(ColumnViewer viewer, IEditingContext context, IProject project, StorageID storageId) {
        super(viewer);
        this.cellEditor = new FeatureValueTextCellEditor((Composite)viewer.getControl());
        this.context = context;
        this.project = project;
        this.storageId = storageId;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof LanguageFeatureValueItem) {
            final LanguageFeatureValueItem item = (LanguageFeatureValueItem)element;
            final FeatureValue fv = item.getFeatureValue();
            FeatureValueValidator.ValidationContext validationContext = new FeatureValueValidator.ValidationContext(){

                public IProject getProject() {
                    return LanguageItemViewerTextEditingSupport.this.project;
                }

                public TranslationKey getTranslationKey() {
                    return fv.getContextKey();
                }

                public TranslateLanguage getLanguage() {
                    return item.getLanguage();
                }

                public ITranslationStorageProvider.Storage getStorage() {
                    return LanguageItemViewerTextEditingSupport.this.translationStorageManager.getStorage(LanguageItemViewerTextEditingSupport.this.project, LanguageItemViewerTextEditingSupport.this.storageId);
                }
            };
            this.init();
            this.cellEditor.setValidator((ICellEditorValidator)new FeatureValueCellEditorValidator(this.registry, validationContext));
        } else {
            this.cellEditor.setValidator(null);
        }
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        if (element instanceof LanguageFeatureValueItem) {
            LanguageFeatureValueItem item = (LanguageFeatureValueItem)element;
            FeatureValue value = item.getFeatureValue();
            return TranslationUtils.isValidFeatureForLanguage((FeatureSettings)value.getContextKey().getFeatureSettings(), (TranslateLanguage)item.getLanguage());
        }
        return false;
    }

    protected Object getValue(Object element) {
        String textValue = null;
        if (element instanceof LanguageFeatureValueItem) {
            LanguageFeatureValueItem item = (LanguageFeatureValueItem)element;
            FeatureValue value = item.getFeatureValue();
            textValue = this.context.getTranslation(this.storageId, (TranslationKey)value, item.getLanguage());
        }
        if (textValue == null) {
            textValue = "";
        }
        return textValue;
    }

    protected void setValue(Object element, Object newValue) {
        if (element instanceof LanguageFeatureValueItem) {
            LanguageFeatureValueItem item = (LanguageFeatureValueItem)element;
            FeatureValue fv = item.getFeatureValue();
            this.context.setTranslation(this.storageId, (TranslationKey)fv, item.getLanguage(), (String)newValue);
        }
        this.getViewer().refresh(element);
    }

    private void init() {
        if (this.registry == null) {
            UiPlugin.getDefault().getInjector().injectMembers((Object)this);
        }
    }
}

