/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.view;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.internal.ui.view.FeatureValueTextCellEditor;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.ui.storage.MultiStorageEditorDialog;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class MultiStorageFeatureValueTextCellEditor
extends FeatureValueTextCellEditor {
    private final IEditingContext editingContext;
    private final TranslateLanguage language;
    private final Supplier<StorageID> currentStorageId;
    private FeatureValue featueValue;
    private @NonNull Button button;

    public MultiStorageFeatureValueTextCellEditor(Composite parent, IEditingContext context, TranslateLanguage language, Supplier<StorageID> storageId) {
        super(parent);
        this.editingContext = context;
        this.language = language;
        this.currentStorageId = storageId;
    }

    public MultiStorageFeatureValueTextCellEditor(Composite parent, int style, IEditingContext context, TranslateLanguage language, Supplier<StorageID> storageId) {
        super(parent, style);
        this.editingContext = context;
        this.language = language;
        this.currentStorageId = storageId;
    }

    protected Control createControl(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        composite.setBackground(parent.getBackground());
        this.text = (Text)super.createControl(composite);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.button = new Button(composite, 8);
        GridData layoutData = new GridData(4, 4, false, true);
        if (parent instanceof Tree) {
            layoutData.widthHint = ((Tree)parent).getItemHeight();
        } else if (parent instanceof Table) {
            layoutData.widthHint = ((Table)parent).getItemHeight();
        }
        this.button.setLayoutData((Object)layoutData);
        this.button.setImage(TransSharedImages.getImage("com.e1c.langtool.ui/elcl16/3dots.png"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String stringValue = (String)MultiStorageFeatureValueTextCellEditor.this.getValue();
                MultiStorageEditorDialog dialog = MultiStorageEditorDialog.create(composite.getShell(), MultiStorageFeatureValueTextCellEditor.this.editingContext, MultiStorageFeatureValueTextCellEditor.this.getFeatueValue().getContextKey(), MultiStorageFeatureValueTextCellEditor.this.language, MultiStorageFeatureValueTextCellEditor.this.currentStorageId);
                if (dialog.open() == 0) {
                    boolean newValidState;
                    String value = MultiStorageFeatureValueTextCellEditor.this.editingContext.getTranslation(MultiStorageFeatureValueTextCellEditor.this.currentStorageId.get(), (TranslationKey)MultiStorageFeatureValueTextCellEditor.this.getFeatueValue(), MultiStorageFeatureValueTextCellEditor.this.language);
                    String newValue = value = value.replace("\r\n", "\n");
                    if (newValue != null && (newValidState = MultiStorageFeatureValueTextCellEditor.this.isCorrect(newValue))) {
                        MultiStorageFeatureValueTextCellEditor.this.markDirty();
                        MultiStorageFeatureValueTextCellEditor.this.doSetValue(newValue);
                        MultiStorageFeatureValueTextCellEditor.this.fireApplyEditorValue();
                    }
                } else {
                    MultiStorageFeatureValueTextCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    MultiStorageFeatureValueTextCellEditor.this.fireCancelEditor();
                }
            }
        });
        return composite;
    }

    public FeatureValue getFeatueValue() {
        return this.featueValue;
    }

    public void setFeatueValue(FeatureValue featueValue) {
        this.featueValue = featueValue;
    }
}

