/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.view;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.ui.view.IQuerySelectionService;
import com.e1c.langtool.query.IApplicable;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.storage.StorageID;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SelectableTextCellEditor
extends TextCellEditor {
    private final String sourceLanguage;
    private final String targetLanguage;
    private final FeatureValue featureValue;
    private final StorageID storageId;
    private final String projectName;
    private final IQuerySelectionService selectionService;
    private ApplicableTranslationQuery query;

    public SelectableTextCellEditor(FeatureValue featureValue, String targetLanguage, String sourceLanguage, IQuerySelectionService selectionService, String projectName, StorageID storageId) {
        this.featureValue = featureValue;
        this.targetLanguage = targetLanguage;
        this.sourceLanguage = sourceLanguage;
        this.selectionService = selectionService;
        this.storageId = storageId;
        this.projectName = projectName;
    }

    public SelectableTextCellEditor(Composite parent, FeatureValue featureValue, String targetLanguage, String sourceLanguage, IQuerySelectionService selectionService, String projectName, StorageID storageId) {
        super(parent);
        this.featureValue = featureValue;
        this.targetLanguage = targetLanguage;
        this.sourceLanguage = sourceLanguage;
        this.selectionService = selectionService;
        this.storageId = storageId;
        this.projectName = projectName;
    }

    public SelectableTextCellEditor(Composite parent, int style, FeatureValue featureValue, String targetLanguage, String sourceLanguage, IQuerySelectionService selectionService, String projectName, StorageID storageId) {
        super(parent, style);
        this.featureValue = featureValue;
        this.targetLanguage = targetLanguage;
        this.sourceLanguage = sourceLanguage;
        this.selectionService = selectionService;
        this.storageId = storageId;
        this.projectName = projectName;
    }

    public void activate() {
        super.activate();
        this.selectionService.fireQuery(this.getQuery());
    }

    private ISingleTranslationQuery getQuery() {
        if (this.query == null) {
            this.query = new ApplicableTranslationQuery();
        }
        return this.query;
    }

    protected class ApplicableTranslationQuery
    implements IContextTranslationQuery,
    IApplicable {
        protected ApplicableTranslationQuery() {
        }

        public String getText() {
            return SelectableTextCellEditor.this.featureValue.getContextKey().getValue();
        }

        public String getSourceLanguage() {
            return SelectableTextCellEditor.this.sourceLanguage;
        }

        public String getTargetLanguage() {
            return SelectableTextCellEditor.this.targetLanguage;
        }

        public boolean isProcessingNeeded() {
            return SelectableTextCellEditor.this.featureValue.getContextKey().getFeatureSettings().isCamelCase();
        }

        public void apply(final String translation) {
            Display display;
            if (SelectableTextCellEditor.this.text != null && StringUtils.isNotEmpty((String)translation) && !SelectableTextCellEditor.this.text.getText().equals(translation) && !(display = SelectableTextCellEditor.this.text.getDisplay()).isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SelectableTextCellEditor.this.activate();
                        SelectableTextCellEditor.this.text.setText(translation);
                        SelectableTextCellEditor.this.text.setVisible(true);
                        SelectableTextCellEditor.this.setFocus();
                    }
                });
            }
        }

        public FeatureValue getFeatureValue() {
            return SelectableTextCellEditor.this.featureValue;
        }

        public StorageID getStorageId() {
            return SelectableTextCellEditor.this.storageId;
        }

        public String getProjectName() {
            return SelectableTextCellEditor.this.projectName;
        }
    }
}

