/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui;

import com.e1c.langtool.ui.Messages;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SearchText
extends Composite {
    private static final int SEARCH_TEXT_KEYPRESS_DELAY = 1000;
    private Text text;
    private int modifyDelay;
    private List<String> history = new ArrayList<String>();
    private ListenerList<SearchModifyListener> postSearchModifyListeners = new ListenerList();
    private ModifyListener listener = new TimeredModifyListener();

    public SearchText(Composite parent) {
        this(parent, 2048);
    }

    public SearchText(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        Font font = parent.getFont();
        int textStyle = 900;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.text = new Text((Composite)this, textStyle);
        this.text.setFont(font);
        this.text.setMessage(Messages.SearchText_Message);
        this.text.setToolTipText(Messages.SearchText_Tooltip);
        this.setModifyDelay(1000);
        this.text.addModifyListener(this.listener);
        this.text.setLayoutData((Object)new GridData(768));
    }

    public Text getTextControl() {
        return this.text;
    }

    public int getModifyDelay() {
        return this.modifyDelay;
    }

    public void addPostSearchModifyListener(SearchModifyListener listener) {
        this.postSearchModifyListeners.add((Object)listener);
    }

    public void removePostSearchModifyListener(SearchModifyListener listener) {
        this.postSearchModifyListeners.remove((Object)listener);
    }

    public void setModifyDelay(int modifyDelay) {
        this.modifyDelay = modifyDelay;
    }

    protected void fireSearchModify(final SearchTextModifyEvent e) {
        for (final SearchModifyListener l : this.postSearchModifyListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    l.modifyText(e);
                }
            });
        }
    }

    public static interface SearchModifyListener
    extends EventListener {
        public void modifyText(SearchTextModifyEvent var1);
    }

    public class SearchTextModifyEvent
    extends EventObject {
        private static final long serialVersionUID = -2861867376159544744L;
        private final String text;

        public SearchTextModifyEvent(Object source, String text) {
            super(source);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    private class TimeredModifyListener
    implements ModifyListener {
        private Timer searchDelayTimer;
        private String currentSearchString = "";

        private TimeredModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (this.searchDelayTimer != null) {
                this.searchDelayTimer.cancel();
            }
            this.searchDelayTimer = new Timer();
            this.searchDelayTimer.schedule(new TimerTask(){
                private String text;
                {
                    this.text = ((TimeredModifyListener)TimeredModifyListener.this).SearchText.this.text.getText();
                }

                @Override
                public void run() {
                    if (TimeredModifyListener.this.currentSearchString != null && !TimeredModifyListener.this.currentSearchString.equals(this.text)) {
                        TimeredModifyListener.this.currentSearchString = this.text;
                        SearchTextModifyEvent e = new SearchTextModifyEvent(((TimeredModifyListener)TimeredModifyListener.this).SearchText.this.text, this.text);
                        SearchText.this.fireSearchModify(e);
                        if (!((TimeredModifyListener)TimeredModifyListener.this).SearchText.this.history.contains(this.text)) {
                            ((TimeredModifyListener)TimeredModifyListener.this).SearchText.this.history.add(this.text);
                        }
                    }
                }
            }, SearchText.this.modifyDelay);
        }
    }
}

