/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class TableViewerColumnComparator
extends ViewerComparator {
    private static final boolean DISABLE_FIX_FOR_364735 = Boolean.getBoolean("eclipse.disable.fix.for.bug364735");
    private int[] sortOrder;
    private final Map<Integer, Integer> directions = new HashMap<Integer, Integer>();
    private static final int DESCENDING = 1;
    private static final int ASCENDING = 0;

    public TableViewerColumnComparator() {
        this.sortOrder = new int[1];
        this.directions.put(0, 0);
    }

    public int getDirection(int column) {
        int direction = this.directions.get(column);
        return direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (this.directions.containsKey(column)) {
            int direction = 1 - this.directions.get(column);
            this.setColumn(column, direction);
        } else {
            this.setColumn(column, 0);
        }
    }

    public void setColumn(int column, int direction) {
        this.directions.clear();
        if (direction == 0 || direction == 1) {
            this.directions.put(column, direction);
        } else {
            this.directions.put(column, 0);
        }
        this.sortOrder = new int[]{column};
    }

    public void addColumn(int column) {
        if (this.directions.containsKey(column)) {
            int direction = 1 - this.directions.get(column);
            this.directions.put(column, direction);
        } else {
            this.addColumn(column, 0);
        }
    }

    public void addColumn(int column, int direction) {
        if (direction == 0 || direction == 1) {
            this.directions.put(column, direction);
        } else {
            this.directions.put(column, 0);
        }
        int[] old = (int[])this.sortOrder.clone();
        this.sortOrder = new int[old.length + 1];
        System.arraycopy(this.sortOrder, 0, old, 0, old.length);
        this.sortOrder[old.length] = column;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        int rc = 0;
        int i = 0;
        while (i < this.sortOrder.length) {
            int column = this.sortOrder[i];
            String name1 = this.getLabel(viewer, e1, column);
            String name2 = this.getLabel(viewer, e2, column);
            rc = this.getComparator().compare(name1, name2);
            int direction = this.directions.get(column);
            if (direction == 1) {
                rc = -rc;
            }
            if (rc != 0) {
                return rc;
            }
            ++i;
        }
        return rc;
    }

    private String getLabel(Viewer viewer, Object e1, int column) {
        String name1;
        if (viewer == null || !(viewer instanceof ContentViewer)) {
            name1 = e1.toString();
        } else {
            IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
            if (prov instanceof ILabelProvider) {
                ILabelProvider lprov = (ILabelProvider)prov;
                if (lprov instanceof DecoratingLabelProvider && !DISABLE_FIX_FOR_364735) {
                    DecoratingLabelProvider dprov = (DecoratingLabelProvider)lprov;
                    lprov = dprov.getLabelProvider();
                }
                name1 = lprov.getText(e1);
            } else {
                name1 = prov instanceof ITableLabelProvider ? ((ITableLabelProvider)prov).getColumnText(e1, column) : e1.toString();
            }
        }
        if (name1 == null) {
            name1 = "";
        }
        return name1;
    }
}

