/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.ui.StorageTranslationCache;
import com.e1c.langtool.ui.tree.IFeatureValueItem;
import com.e1c.langtool.ui.tree.ITreeItem;
import com.e1c.langtool.ui.tree.ITreeItemContainer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.TreeColumn;

public class TextSearchFilter
extends ViewerFilter {
    private String searchText = "";
    private String patternString;
    private StorageTranslationCache translationCache;
    private boolean checkFilledTranslation = false;
    private boolean checkIgnoreCase;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String columnText;
        if (!(element instanceof ITreeItem)) {
            return true;
        }
        if (element instanceof IFeatureValueItem) {
            FeatureValue value = ((IFeatureValueItem)element).getFeatureValue();
            if (this.checkFilledTranslation && this.translationCache != null && this.translationCache.hasTranslation(value)) {
                return false;
            }
        }
        if (StringUtils.isNullOrEmpty((String)this.searchText) || this.patternString == null) {
            return true;
        }
        TreeColumn[] columns = ((TreeViewer)viewer).getTree().getColumns();
        IBaseLabelProvider labelProvider = ((TreeViewer)viewer).getLabelProvider();
        if (labelProvider instanceof ITableLabelProvider) {
            int i = 0;
            while (i < columns.length) {
                String columnText2;
                TreeColumn treeColumn = columns[i];
                if (treeColumn.getWidth() != 0 && this.isValiedText(columnText2 = ((ITableLabelProvider)labelProvider).getColumnText(element, i))) {
                    return true;
                }
                ++i;
            }
        } else if (labelProvider instanceof ILabelProvider && this.isValiedText(columnText = ((ILabelProvider)labelProvider).getText(element))) {
            return true;
        }
        if (element instanceof ITreeItemContainer) {
            for (ITreeItem item : ((ITreeItemContainer)element).getChildren()) {
                if (!this.select(viewer, element, item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCheckFilledTranslation() {
        return this.checkFilledTranslation;
    }

    public void setCheckFilledTranslation(boolean checkFilledTranslation) {
        this.checkFilledTranslation = checkFilledTranslation;
    }

    public StorageTranslationCache getTranslationCache() {
        return this.translationCache;
    }

    public void setTranslationCache(StorageTranslationCache translationCache) {
        this.translationCache = translationCache;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
        this.patternString = null;
        this.checkIgnoreCase = false;
        boolean isRegex = false;
        try {
            Pattern.compile(searchText);
            if (searchText.matches("\\W")) {
                isRegex = true;
                this.patternString = searchText;
            }
        }
        catch (PatternSyntaxException e) {
            isRegex = false;
        }
        if (!isRegex) {
            try {
                this.patternString = ".*" + searchText + ".*";
                Pattern.compile(this.patternString);
                this.checkIgnoreCase = searchText.equals(searchText.toLowerCase());
            }
            catch (PatternSyntaxException e2) {
                this.patternString = null;
            }
        }
    }

    private boolean isValiedText(String text) {
        return StringUtils.isNotEmpty((String)text) && (text.matches(this.patternString) || this.checkIgnoreCase && text.toLowerCase().contains(this.searchText) || text.contains(this.searchText));
    }
}

