/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.flags.ui.SharedImages;
import com.e1c.langtool.internal.ui.preferences.TranslationPreferences;
import com.e1c.langtool.internal.ui.view.ContainerFeatureValueItem;
import com.e1c.langtool.internal.ui.view.LanguageColumnEditingSupport;
import com.e1c.langtool.internal.ui.view.LanguageFeatureValueItem;
import com.e1c.langtool.internal.ui.view.LanguageItemViewerTextEditingSupport;
import com.e1c.langtool.internal.ui.view.PinTranslationViewAction;
import com.e1c.langtool.internal.ui.view.QuerySelectionProvider;
import com.e1c.langtool.internal.ui.view.SingleLanguageFeatureValueItem;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.ui.Messages;
import com.e1c.langtool.ui.SearchText;
import com.e1c.langtool.ui.StorageTranslationCache;
import com.e1c.langtool.ui.TextSearchFilter;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.ui.collector.FeatureValueCollectingResult;
import com.e1c.langtool.ui.collector.ISelectionCollectingService;
import com.e1c.langtool.ui.collector.SelectionCollectingEvent;
import com.e1c.langtool.ui.collector.SelectionCollectingRequester;
import com.e1c.langtool.ui.collector.SelectionCollectingStatus;
import com.e1c.langtool.ui.tree.AbstractTreeFactory;
import com.e1c.langtool.ui.tree.FeatureTreeComparator;
import com.e1c.langtool.ui.tree.FeatureTreeContentProvider;
import com.e1c.langtool.ui.tree.GroupItem;
import com.e1c.langtool.ui.tree.IFeatureTree;
import com.e1c.langtool.ui.tree.IFeatureValueItem;
import com.e1c.langtool.ui.tree.ITreeItem;
import com.e1c.langtool.ui.tree.ITreeItemContainer;
import com.e1c.langtool.ui.tree.ResourceItem;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class TranslationsView
extends ViewPart
implements SelectionCollectingRequester {
    public static final String GROUP_TRANSLATION_STORAGE = "translation.storage";
    public static final String GROUP_PREFERENCES = "preferences";
    public static final String GROUP_STORAGE = "storage";
    public static final String GROUP_SHOW = "group.show";
    public static final String ID = "com.e1c.langtool.ui.TranslationsView";
    protected static final String PREFERENCE_PAGE_ID = "com.e1c.langtool.ui";
    private static final String COLUMN_DATA_NAME = "name";
    private static final String COLUNM_NAME_KEY = "key";
    private static final String COLUNM_NAME_VALUE = "value";
    private static final String COLUMN_DATA_INDEX = "index";
    @Inject
    private ISelectionCollectingService collectingService;
    @Inject
    private IStorageSettingsManager settingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private ValidatorRegistry registry;
    private PageBook pagebook;
    private Composite translationsPage;
    private Label disableTranslationsPage;
    private Composite collectingProcessPage;
    private SearchText searchText;
    private TextSearchFilter searchFilter;
    private TreeViewer viewer;
    private TreeColumnLayout tableColumnLayout;
    private TreeViewerColumn valueColumn;
    private IAction showInterfaceAction;
    private IAction showModelAction;
    private IAction showComputedAction;
    private IAction hideFilledTranslationAction;
    private IAction pinTranslationViewAction;
    private IAction refreshAction;
    private IAction showChildObjectsAction;
    private IAction showSubresourcesAction;
    private IAction showAllValuesAction;
    private IAction expandAllAction;
    private IAction collapseAllAction;
    private IAction defaultStorageAction;
    private IAction flatModeAction;
    private IAction hierarhicalModeAction;
    private IAction preferencesAction;
    private IAction copyAction;
    private IAction pasteAction;
    private IAction findAction;
    private IAction deleteTranslationAction;
    private QuerySelectionProvider selectionProvider;
    private ITreeContentProvider contentProvider;
    private Cursor waitCursor;
    private Cursor defaultCursor;
    private Clipboard clipboard;
    private ViewerTreeFactory treeFactory;
    private IFeatureTree featureTree;
    private Map<String, TreeViewerColumn> languageColumns;
    private final List<TranslateLanguage> languages = Lists.newArrayList();
    private boolean languagesInColumns = true;
    private ITableLabelProvider labelProvider;
    @Deprecated
    private StorageTranslationCache translationCache;
    private Map<String, TranslateLanguage> languageCodesCache = Maps.newHashMap();
    private StorageValueChangedListener storageChangeListener;
    private FeatureTreeComparator comparator;
    private StorageID currentStorage;
    private ICollectingParameters parameters;
    private FeatureValueCollectingResult collectingResult;

    public void createPartControl(Composite parent) {
        this.clipboard = new Clipboard(parent.getDisplay());
        Font font = parent.getFont();
        this.pagebook = new PageBook(parent, 0);
        this.waitCursor = this.pagebook.getDisplay().getSystemCursor(1);
        this.defaultCursor = this.pagebook.getDisplay().getSystemCursor(0);
        this.translationsPage = new Composite((Composite)this.pagebook, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.translationsPage);
        this.translationsPage.setLayoutData((Object)new GridData(1808));
        this.searchText = new SearchText(this.translationsPage);
        this.searchText.setLayoutData(new GridData(768));
        this.searchText.getTextControl().setToolTipText(Messages.TranslationsView_SearchText_ToolTip);
        this.treeFactory = new ViewerTreeFactory();
        this.featureTree = this.treeFactory.createFeatureTree();
        Composite viewerComposite = new Composite(this.translationsPage, 0);
        viewerComposite.setLayout((Layout)new GridLayout());
        viewerComposite.setLayoutData((Object)new GridData(1808));
        viewerComposite.setFont(font);
        this.viewer = new TreeViewer(viewerComposite, 68354);
        this.contentProvider = new FeatureTreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(font);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setToolTipText(Messages.TranslationsView_TreeViewer_ToolTip);
        this.tableColumnLayout = new TreeColumnLayout();
        viewerComposite.setLayout((Layout)this.tableColumnLayout);
        this.createViewerColumns();
        this.labelProvider = new NlsLableProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.searchFilter = new TextSearchFilter();
        this.viewer.addFilter((ViewerFilter)this.searchFilter);
        this.searchText.addPostSearchModifyListener(e -> {
            Display display = this.viewer.getControl().getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    this.searchFilter.setSearchText(e.getText());
                    this.viewer.getControl().setRedraw(false);
                    this.viewer.refresh();
                    if (StringUtils.isNotEmpty((String)e.getText()) || TranslationPreferences.getKeyTreeExpanded()) {
                        this.viewer.expandAll();
                    }
                    this.viewer.getControl().setRedraw(true);
                });
            }
        });
        this.comparator = new FeatureTreeComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        if (this.viewer.getTree().getColumnCount() > 0) {
            this.comparator.setColumn(0, 0);
            int dir = this.comparator.getDirection(0);
            this.viewer.getTree().setSortDirection(dir);
            this.viewer.getTree().setSortColumn(this.viewer.getTree().getColumn(0));
        }
        this.viewer.setInput((Object)this.featureTree);
        this.viewer.addSelectionChangedListener(event -> this.featureTree.setSelection((ITreeItem)event.getStructuredSelection().getFirstElement()));
        this.selectionProvider = new QuerySelectionProvider(this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.disableTranslationsPage = new Label((Composite)this.pagebook, 0);
        this.disableTranslationsPage.setText(Messages.TranslationsView_Translations_have_not_enabled_for_this_project_yet);
        this.pagebook.showPage((Control)this.disableTranslationsPage);
        this.parameters = new ICollectingParameters(){

            public boolean useCache() {
                return true;
            }

            public boolean isContinueAfterFirstError() {
                return false;
            }

            public boolean isCollectSubResources() {
                return TranslationsView.this.showSubresourcesAction.isChecked();
            }

            public boolean isCollectModelStrings() {
                return TranslationsView.this.showModelAction.isChecked();
            }

            public boolean isCollectInterfaceStrings() {
                return TranslationsView.this.showInterfaceAction.isChecked();
            }

            public boolean isCollectEmptyValue() {
                return TranslationsView.this.showAllValuesAction.isChecked();
            }

            public boolean isCollectChildObjects() {
                return TranslationsView.this.showChildObjectsAction.isChecked();
            }

            public Set<TranslateLanguage> getLanguages() {
                return Collections.emptySet();
            }

            public Collection<Exception> getErrors() {
                return new ArrayList<Exception>();
            }

            public boolean isKeepLanguagesMode() {
                return false;
            }

            public ICollectingParameters.CollectModelType getCollectModelType() {
                if (TranslationsView.this.showComputedAction.isChecked()) {
                    return ICollectingParameters.CollectModelType.ANY;
                }
                return ICollectingParameters.CollectModelType.NONE;
            }
        };
        this.collectingProcessPage = new Composite((Composite)this.pagebook, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.collectingProcessPage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.collectingProcessPage);
        Label collectingLabel = new Label(this.collectingProcessPage, 0);
        collectingLabel.setText(Messages.TranslationsView_Collecting_translatable_strings);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)collectingLabel);
        collectingLabel.setAlignment(0x1000000);
        this.collectingService.addRequester(this, this.getSite().getWorkbenchWindow());
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.createContextMenu();
        this.hookGlobalActions();
        this.getSite().getPage().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)this.pagebook, "com.e1c.langtool.ui.translations_view_context");
        this.storageChangeListener = new StorageValueChangedListener();
    }

    public void setFocus() {
        this.pagebook.setFocus();
    }

    public void dispose() {
        this.collectingService.removeRequester(this);
        if (this.storageChangeListener != null && this.getProject() != null && this.currentStorage != null) {
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.getProject(), this.currentStorage);
            storage.removeValueChangedListener((IStorageValueChangedListener)this.storageChangeListener);
        }
        this.storageChangeListener = null;
        if (this.collectingResult != null && !this.collectingResult.isDisposed()) {
            this.collectingResult.dispose();
        }
        this.collectingResult = null;
        this.parameters = null;
        TransferData[] available = this.clipboard.getAvailableTypes();
        int i = 0;
        while (i < available.length) {
            if (TextTransfer.getInstance().isSupportedType(available[i])) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
                break;
            }
            ++i;
        }
        this.clipboard.dispose();
        super.dispose();
    }

    @Override
    public ICollectingParameters getCollectingParameters() {
        return this.parameters;
    }

    @Override
    public boolean canProcessPart(IWorkbenchPart part) {
        return this != part;
    }

    @Override
    public void statusChanged(SelectionCollectingEvent event) {
        if (this.pagebook.isDisposed() || this.pagebook.getDisplay().isDisposed()) {
            return;
        }
        SelectionCollectingStatus status = event.getStatus();
        switch (status) {
            case UPDATED: {
                this.pagebook.getDisplay().asyncExec(() -> this.updateCollectingResult(event.getCurrentCollectingResult()));
                break;
            }
            case COLLECTING: {
                this.pagebook.getDisplay().asyncExec(() -> this.updateCollecting(event.getCurrentCollectingResult()));
                break;
            }
            default: {
                this.pagebook.getDisplay().asyncExec(() -> this.updateNotCollecting(event.getCurrentCollectingResult()));
            }
        }
    }

    public boolean isPinned() {
        return this.pinTranslationViewAction != null && this.pinTranslationViewAction.isChecked();
    }

    private void updateCollecting(FeatureValueCollectingResult result) {
        if (this.isPinned()) {
            return;
        }
        this.collectingResult = result;
        this.pagebook.showPage((Control)this.collectingProcessPage);
        this.refreshAction.setEnabled(false);
    }

    private void updateNotCollecting(FeatureValueCollectingResult result) {
        if (this.isPinned()) {
            return;
        }
        this.collectingResult = result;
        this.pagebook.showPage((Control)this.disableTranslationsPage);
        this.refreshAction.setEnabled(false);
    }

    private void updateCollectingResult(FeatureValueCollectingResult result) {
        boolean projectChanged;
        if (this.isPinned()) {
            return;
        }
        ITranslatingProject oldProject = this.getCurrentProject();
        boolean bl = projectChanged = result == null && oldProject != null || result != null && oldProject != result.getProject();
        if (projectChanged) {
            this.beforeProjectChanged();
        }
        this.collectingResult = result;
        if (projectChanged) {
            this.afterProjectChanged();
        }
        this.pagebook.showPage((Control)this.translationsPage);
        this.updateValues();
        this.pagebook.setCursor(this.defaultCursor);
        this.refreshAction.setEnabled(true);
    }

    private void beforeProjectChanged() {
        this.setCurrentStorageId(null);
    }

    private void afterProjectChanged() {
        this.translationCache = null;
        if (this.getProject() != null) {
            StorageID id = this.settingsManager.getSettingsOrDefault(this.getProject()).getEdit().getStorageId();
            this.setCurrentStorageId(id);
            this.translationCache = new StorageTranslationCache(this.getCurrentProject());
            this.translationCache.setStorageManager(this.storageManager);
            this.translationCache.setStorageSettingsManager(this.settingsManager);
            this.translationCache.setLanguages(this.languages);
        }
        this.searchFilter.setTranslationCache(this.translationCache);
    }

    private @Nullable String getTranslation(FeatureValue fv, String languageCode) {
        String result = null;
        TranslateLanguage language = this.languageCodesCache.get(languageCode);
        if (this.isTranslating() && language != null && this.currentStorage != null && fv != null) {
            result = this.collectingResult.getEditingContext().getTranslation(this.currentStorage, (TranslationKey)fv, language);
        }
        return result;
    }

    private void updateValues() {
        this.featureTree.getChildren().clear();
        if (this.collectingResult != null && !this.collectingResult.isDisposed()) {
            if (!this.isTranslating()) {
                this.pagebook.showPage((Control)this.disableTranslationsPage);
                return;
            }
            this.pagebook.setCursor(this.waitCursor);
            this.createUpdateLanguageColumns();
            this.updateTreeMode();
        }
        this.pagebook.setCursor(this.defaultCursor);
    }

    private void setCurrentStorageId(StorageID currentStorage) {
        ITranslationStorageProvider.Storage storage;
        if (this.getProject() != null && this.currentStorage != null && (storage = this.storageManager.getStorage(this.getProject(), this.currentStorage)) != null) {
            storage.removeValueChangedListener((IStorageValueChangedListener)this.storageChangeListener);
        }
        if (this.getProject() != null && currentStorage != null && (storage = this.storageManager.getStorage(this.getProject(), currentStorage)) != null) {
            storage.addValueChangedListener((IStorageValueChangedListener)this.storageChangeListener);
        }
        this.currentStorage = currentStorage;
        if (this.currentStorage == null) {
            this.pagebook.showPage((Control)this.disableTranslationsPage);
        }
        this.viewer.refresh();
    }

    private @Nullable ITranslatingProject getCurrentProject() {
        if (this.collectingResult == null || this.collectingResult.isDisposed()) {
            return null;
        }
        return this.collectingResult.getProject();
    }

    private boolean isSingleLanguage() {
        return this.languages != null && this.languages.size() == 1;
    }

    private boolean isReadOnly() {
        if (this.currentStorage == null && this.getProject() != null) {
            return true;
        }
        StorageSettings settings = (StorageSettings)this.settingsManager.getSettingsOrDefault(this.getProject()).allStorageSettings().get(this.currentStorage);
        return settings == null || settings.isReadOnly();
    }

    public boolean isTranslating() {
        if (this.collectingResult == null || this.collectingResult.isDisposed()) {
            return false;
        }
        ITranslatingProject project = this.collectingResult.getProject();
        return project != null && project.isTranslating();
    }

    private SelectionListener getSelectionAdapter(TreeColumn column, int index) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            this.comparator.setColumn(index);
            int dir = this.comparator.getDirection(index);
            this.viewer.getTree().setSortDirection(dir);
            this.viewer.getTree().setSortColumn(column);
            this.viewer.refresh();
        });
    }

    protected void createViewerColumns() {
        Pair keyColumnPair = new Pair((Object)COLUNM_NAME_KEY, (Object)Messages.TranslationsView_Column_name_Key);
        Pair valueColumnPair = new Pair((Object)COLUNM_NAME_VALUE, (Object)Messages.TranslationsView_Column_name_Value);
        ArrayList columnHeaders = Lists.newArrayList((Object[])new Pair[]{keyColumnPair, valueColumnPair});
        int i = 0;
        while (i < columnHeaders.size()) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
            column.getColumn().setText((String)((Pair)columnHeaders.get(i)).getValue());
            this.tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100));
            column.getColumn().setMoveable(true);
            column.getColumn().setData(COLUMN_DATA_NAME, ((Pair)columnHeaders.get(i)).getKey());
            if (COLUNM_NAME_VALUE.equals(((Pair)columnHeaders.get(i)).getKey())) {
                this.valueColumn = column;
            }
            column.getColumn().addSelectionListener(this.getSelectionAdapter(column.getColumn(), i));
            ++i;
        }
        this.languageColumns = Maps.newHashMap();
        this.createUpdateLanguageColumns();
    }

    protected void createUpdateLanguageColumns() {
        int n;
        TreeViewerColumn column;
        String languageCode;
        if (this.getProject() == null) {
            this.hideAllLanguageColumns();
            return;
        }
        ArrayList showOnlyLanguages = Lists.newArrayList((Object[])TranslationPreferences.getShowOnlyLanguages());
        if (!showOnlyLanguages.isEmpty()) {
            this.languages.clear();
            for (TranslateLanguage language : this.getCurrentProject().getInterfaceLanguages()) {
                if (!showOnlyLanguages.contains(language.getLanguageCode())) continue;
                this.languages.add(language);
            }
        } else {
            this.languages.clear();
            this.languages.addAll(this.getCurrentProject().getInterfaceLanguages());
        }
        if (this.translationCache != null) {
            this.translationCache.setLanguages(this.languages);
        }
        boolean bl = this.languagesInColumns = this.languages.size() < TranslationPreferences.getShowLanguagesInTree();
        if (this.languages.isEmpty()) {
            this.hideAllLanguageColumns();
            return;
        }
        if (!this.languagesInColumns) {
            this.hideAllLanguageColumns();
            this.languageCodesCache.clear();
            for (TranslateLanguage language : this.languages) {
                String languageCode2 = language.getLanguageCode();
                if (!StringUtils.isNotEmpty((String)languageCode2)) continue;
                this.languageCodesCache.put(languageCode2, language);
            }
            this.valueColumn.setEditingSupport((EditingSupport)new LanguageItemViewerTextEditingSupport((ColumnViewer)this.viewer, this.collectingResult.getEditingContext(), this.getProject(), this.currentStorage));
            this.selectionProvider.setEnableViewerSelection(true);
            return;
        }
        this.valueColumn.setEditingSupport(null);
        this.selectionProvider.setEnableViewerSelection(this.isSingleLanguage());
        HashSet languageCodes = Sets.newHashSet();
        for (TranslateLanguage translateLanguage : this.languages) {
            languageCode = translateLanguage.getLanguageCode();
            languageCodes.add(languageCode);
        }
        for (Map.Entry entry : this.languageColumns.entrySet()) {
            languageCode = (String)entry.getKey();
            if (languageCodes.contains(languageCode)) {
                languageCodes.remove(languageCode);
                continue;
            }
            column = (TreeViewerColumn)entry.getValue();
            this.tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(0, false));
            column.getColumn().setWidth(0);
        }
        int n2 = 100;
        int width = this.viewer.getTree().getSize().x;
        int i = 0;
        while (i < this.viewer.getTree().getColumns().length) {
            column = this.viewer.getTree().getColumns()[i];
            width -= column.getWidth();
            ++i;
        }
        if (width > 0 && !languageCodes.isEmpty()) {
            n = Math.max(n2, width /= languageCodes.size());
        }
        this.languageCodesCache.clear();
        TranslateLanguage sourceLanguage = this.getCurrentProject().getDefaultLanguage();
        for (TranslateLanguage language : this.languages) {
            String languageCode3 = language.getLanguageCode();
            if (StringUtils.isNotEmpty((String)languageCode3)) {
                this.languageCodesCache.put(languageCode3, language);
            }
            languageCodes.add(languageCode3);
            TreeViewerColumn column2 = this.languageColumns.get(languageCode3);
            if (column2 == null) {
                column2 = new TreeViewerColumn(this.viewer, 0);
                this.languageColumns.put(languageCode3, column2);
                String columnText = language.getPresentation();
                if (StringUtils.isNullOrEmpty((String)columnText)) {
                    columnText = language.getName();
                }
                column2.getColumn().setText(columnText);
                column2.getColumn().setMoveable(true);
                column2.getColumn().setData(COLUMN_DATA_NAME, (Object)languageCode3);
                int index = this.viewer.getTree().getColumnCount() - 1;
                column2.getColumn().setData(COLUMN_DATA_INDEX, (Object)index);
                column2.getColumn().addSelectionListener(this.getSelectionAdapter(column2.getColumn(), index));
            }
            int columnIndex = (Integer)column2.getColumn().getData(COLUMN_DATA_INDEX);
            LanguageColumnEditingSupport editingSupport = this.isSingleLanguage() ? new LanguageColumnEditingSupport((ColumnViewer)this.viewer, columnIndex, sourceLanguage, language, this.collectingResult.getEditingContext(), null, this.getProject(), () -> this.currentStorage) : new LanguageColumnEditingSupport((ColumnViewer)this.viewer, columnIndex, sourceLanguage, language, this.collectingResult.getEditingContext(), this.selectionProvider, this.getProject(), () -> this.currentStorage);
            column2.setEditingSupport((EditingSupport)editingSupport);
            column2.getColumn().setImage(SharedImages.getLanguageFlagImage((IProject)this.getProject(), (String)languageCode3));
            this.tableColumnLayout.setColumnData((Widget)column2.getColumn(), null);
            if (column2.getColumn().getWidth() == 0) {
                column2.getColumn().setWidth(n);
            }
            this.tableColumnLayout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100));
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    protected void hideAllLanguageColumns() {
        for (Map.Entry<String, TreeViewerColumn> entry : this.languageColumns.entrySet()) {
            TreeViewerColumn column = entry.getValue();
            this.tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(0, false));
            column.getColumn().setWidth(0);
        }
    }

    protected void createActions() {
        this.createShowInterfaceAction();
        this.createShowModelAction();
        this.createShowComputedAction();
        this.createHideFilledTranslationAction();
        this.createRefreshAction();
        this.createShowChildObjectsAction();
        this.createShowSubresourcesAction();
        this.createShowAllValuesAction();
        this.createExpandAllAction();
        this.createCollapseAllAction();
        this.createDefaultStorageAction();
        this.createFlatModeAction();
        this.createHierarhicalModeAction();
        this.createPinTranslationViewAction();
        this.createPreferencesAction();
        this.createCopyAction();
        this.createPasteAction();
        this.createFindAction();
        this.createDeleteAction();
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IContributionItem)new Separator("wbStart"));
        mgr.add(this.refreshAction);
        mgr.add((IContributionItem)new Separator("group.showIn"));
        mgr.add(this.showInterfaceAction);
        mgr.add(this.showModelAction);
        mgr.add(this.showComputedAction);
        mgr.add(this.hideFilledTranslationAction);
        mgr.add(this.showChildObjectsAction);
        mgr.add(this.showSubresourcesAction);
        mgr.add(this.showAllValuesAction);
        mgr.add((IContributionItem)new Separator(GROUP_SHOW));
        mgr.add(this.expandAllAction);
        mgr.add(this.collapseAllAction);
        mgr.add((IContributionItem)new Separator(GROUP_STORAGE));
        MenuManager storageMenuMgr = new MenuManager(Messages.TranslationsView_Menu_Translation_Storage_name, GROUP_TRANSLATION_STORAGE);
        storageMenuMgr.setRemoveAllWhenShown(true);
        storageMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TranslationsView.this.fillStorageMenu(mgr);
            }
        });
        mgr.add((IContributionItem)storageMenuMgr);
        mgr.add((IContributionItem)new Separator("show.ext"));
        mgr.add(this.flatModeAction);
        mgr.add(this.hierarhicalModeAction);
        mgr.add((IContributionItem)new Separator("pin.group"));
        mgr.add(this.pinTranslationViewAction);
        mgr.add((IContributionItem)new Separator("additions"));
        mgr.add((IContributionItem)new Separator(GROUP_PREFERENCES));
        mgr.add(this.preferencesAction);
        mgr.add((IContributionItem)new Separator("wbEnd"));
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add(this.showInterfaceAction);
        mgr.add(this.showModelAction);
        mgr.add(this.showComputedAction);
        mgr.add(this.hideFilledTranslationAction);
        mgr.add(this.pinTranslationViewAction);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(mgr -> this.fillContextMenu(mgr));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.findAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteTranslationAction);
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && TranslationsView.this.deleteTranslationAction.isEnabled()) {
                    TranslationsView.this.deleteTranslationAction.run();
                }
            }
        });
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new Separator("wbStart"));
        mgr.add(this.refreshAction);
        mgr.add((IContributionItem)new Separator("group.showIn"));
        mgr.add((IContributionItem)new Separator(GROUP_SHOW));
        mgr.add(this.expandAllAction);
        mgr.add(this.collapseAllAction);
        mgr.add((IContributionItem)new Separator("show.ext"));
        mgr.add(this.copyAction);
        mgr.add(this.pasteAction);
        mgr.add(this.findAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.deleteTranslationAction);
        mgr.add((IContributionItem)new Separator("additions"));
        mgr.add((IContributionItem)new Separator("wbEnd"));
    }

    private void fillStorageMenu(IMenuManager mgr) {
        mgr.add(this.defaultStorageAction);
        this.defaultStorageAction.setChecked(false);
        this.defaultStorageAction.setEnabled(true);
        mgr.add((IContributionItem)new Separator());
        if (this.isTranslating()) {
            ProjectStorageSettings settings = this.settingsManager.getSettingsOrDefault(this.getProject());
            String defaultPresentation = settings.getEdit().getPresentation();
            if (StringUtils.isBlank((String)defaultPresentation)) {
                defaultPresentation = Messages.TranslationsView_DefaultStorageAction_name;
            }
            this.defaultStorageAction.setText(defaultPresentation);
            StorageID current = settings.getEdit().getStorageId();
            this.defaultStorageAction.setChecked(current.equals((Object)this.currentStorage));
            for (StorageSettings storageSetting : settings.getReadStorageSettings()) {
                StorageAction storageAction = new StorageAction(storageSetting);
                storageAction.setChecked(storageSetting.getStorageId().equals((Object)this.currentStorage));
                mgr.add((IAction)storageAction);
            }
        } else {
            this.defaultStorageAction.setChecked(true);
            this.defaultStorageAction.setEnabled(false);
        }
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createPinTranslationViewAction() {
        this.pinTranslationViewAction = new PinTranslationViewAction();
        this.pinTranslationViewAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!"checked".equals(event.getProperty())) {
                    return;
                }
                if (Boolean.TRUE.equals(event.getNewValue())) {
                    TranslationsView.this.collectingService.removeRequester(TranslationsView.this);
                } else {
                    TranslationsView.this.collectingService.addRequester(TranslationsView.this, TranslationsView.this.getSite().getWorkbenchWindow());
                }
                TranslationsView.this.updateContentDescription();
            }
        });
    }

    private void updateContentDescription() {
        if (this.isPinned() && this.collectingResult != null && this.collectingResult.getSelectedPart() != null) {
            String title = this.collectingResult.getSelectedPart().getTitle();
            this.setContentDescription(MessageFormat.format(Messages.TranslationsView_Content_Description, title));
        } else {
            this.setContentDescription("");
        }
        this.firePropertyChange(257);
    }

    private void updateTreeMode() {
        this.pagebook.setCursor(this.waitCursor);
        ITreeItem sel = this.featureTree.getSelection();
        this.featureTree.getChildren().clear();
        boolean isHierarhical = this.hierarhicalModeAction.isChecked();
        if (this.collectingResult != null && !this.collectingResult.isDisposed()) {
            this.treeFactory.fillUpTree(this.featureTree, this.collectingResult.getValues(), isHierarhical);
        }
        boolean expand = TranslationPreferences.getKeyTreeExpanded();
        if (sel instanceof IFeatureValueItem) {
            FeatureValue fv = ((IFeatureValueItem)sel).getFeatureValue();
            ITreeItem newSel = this.findFeatureTreeItem(fv);
            this.featureTree.setSelection(newSel);
            if (newSel != null) {
                expand = true;
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)newSel));
            }
        }
        this.viewer.getControl().setRedraw(false);
        this.viewer.refresh();
        if (expand) {
            this.viewer.expandAll();
        }
        this.viewer.getControl().setRedraw(true);
        this.pagebook.setCursor(this.defaultCursor);
    }

    private @Nullable ITreeItem findFeatureTreeItem(FeatureValue fv) {
        if (fv == null) {
            return null;
        }
        ArrayList find = Lists.newArrayList();
        find.addAll(this.featureTree.getChildren());
        while (!find.isEmpty()) {
            ITreeItem item = (ITreeItem)find.get(0);
            find.remove(0);
            if (item instanceof IFeatureValueItem && fv.equals(((IFeatureValueItem)item).getFeatureValue())) {
                return item;
            }
            if (!(item instanceof ITreeItemContainer)) continue;
            find.addAll(((ITreeItemContainer)((Object)item)).getChildren());
        }
        return null;
    }

    private void createPreferencesAction() {
        this.preferencesAction = new Action(Messages.TranslationsView_PreferenceAction_name){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)TranslationsView.this.getSite().getShell(), (String)TranslationsView.PREFERENCE_PAGE_ID, null, null);
                dialog.open();
            }
        };
        this.preferencesAction.setToolTipText(Messages.TranslationsView_PreferenceAction_ToolTip);
        this.preferencesAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/translations_settings.png"));
    }

    private void createHierarhicalModeAction() {
        this.hierarhicalModeAction = new Action(Messages.TranslationsView_HierarhicalModeAction_name, 8){};
        this.hierarhicalModeAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty())) {
                    TranslationsView.this.updateTreeMode();
                    if (TranslationsView.this.flatModeAction != null && TranslationsView.this.hierarhicalModeAction.isChecked() == TranslationsView.this.flatModeAction.isChecked()) {
                        TranslationsView.this.flatModeAction.setChecked(!TranslationsView.this.hierarhicalModeAction.isChecked());
                    }
                }
            }
        });
        this.hierarhicalModeAction.setToolTipText(Messages.TranslationsView_HierarhicalModeAction_ToolTip);
        this.hierarhicalModeAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/hierarchical_mode.png"));
        this.hierarhicalModeAction.setChecked(TranslationPreferences.getKeyTreeHierarchical());
    }

    private void createFlatModeAction() {
        this.flatModeAction = new Action(Messages.TranslationsView_FlatModeAction_name, 8){};
        this.flatModeAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty()) && TranslationsView.this.hierarhicalModeAction != null && TranslationsView.this.hierarhicalModeAction.isChecked() == TranslationsView.this.flatModeAction.isChecked()) {
                    TranslationsView.this.hierarhicalModeAction.setChecked(!TranslationsView.this.flatModeAction.isChecked());
                }
            }
        });
        this.flatModeAction.setToolTipText(Messages.TranslationsView_FlatModeAction_ToolTip);
        this.flatModeAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/flat_mode.png"));
        this.flatModeAction.setChecked(!TranslationPreferences.getKeyTreeHierarchical());
    }

    private void createCollapseAllAction() {
        this.collapseAllAction = new Action(Messages.TranslationsView_CollapseAllAction_name){

            public void run() {
                TranslationsView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(Messages.TranslationsView_CollapseAllAction_ToolTip);
        this.collapseAllAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/collapse_all.gif"));
    }

    private void createExpandAllAction() {
        this.expandAllAction = new Action(Messages.TranslationsView_ExpandAllAction_name){

            public void run() {
                TranslationsView.this.viewer.expandAll();
            }
        };
        this.expandAllAction.setToolTipText(Messages.TranslationsView_ExpandAllAction_ToolTip);
        this.expandAllAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/expand_all.gif"));
    }

    private void createShowAllValuesAction() {
        this.showAllValuesAction = new ToggleUpdateValueAction(Messages.TranslationsView_ShowAllAction_name);
        this.showAllValuesAction.setToolTipText(Messages.TranslationsView_ShowAllAction_ToolTip);
        this.showAllValuesAction.setChecked(TranslationPreferences.getShowAllValues());
    }

    private void createShowSubresourcesAction() {
        this.showSubresourcesAction = new ToggleUpdateValueAction(Messages.TranslationsView_ShowSubresourcesAction_name);
        this.showSubresourcesAction.setToolTipText(Messages.TranslationsView_ShowSubresourcesAction_ToolTip);
        this.showSubresourcesAction.setChecked(TranslationPreferences.getShowSubresources());
    }

    private void createShowChildObjectsAction() {
        this.showChildObjectsAction = new ToggleUpdateValueAction(Messages.TranslationsView_ShowChildObjectsAction_name);
        this.showChildObjectsAction.setToolTipText(Messages.TranslationsView_ShowChildObjectsAction_ToolTip);
        this.showChildObjectsAction.setChecked(TranslationPreferences.getShowChildObjects());
    }

    private void createRefreshAction() {
        this.refreshAction = new Action(Messages.TranslationsView_RefreshAction_name){

            public void run() {
                if (!TranslationsView.this.isPinned() && TranslationsView.this.collectingResult != null && !TranslationsView.this.collectingResult.isDisposed()) {
                    TranslationsView.this.collectingService.refresh(TranslationsView.this, TranslationsView.this.collectingResult);
                }
            }
        };
        this.refreshAction.setToolTipText(Messages.TranslationsView_RefreshAction_ToolTip);
        this.refreshAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/refresh.png"));
    }

    private void createHideFilledTranslationAction() {
        this.hideFilledTranslationAction = new ToggleAction(this, Messages.TranslationsView_HideFilledTranslationAction_name){

            public void run() {
                pagebook.setCursor(waitCursor);
                viewer.getControl().setRedraw(false);
                searchFilter.setCheckFilledTranslation(this.isChecked());
                viewer.refresh();
                if (TranslationPreferences.getKeyTreeExpanded()) {
                    viewer.expandAll();
                }
                pagebook.setCursor(defaultCursor);
                viewer.getControl().setRedraw(true);
            }
        };
        this.hideFilledTranslationAction.setToolTipText(Messages.TranslationsView_HideFilledTranslationAction_ToolTip);
        this.hideFilledTranslationAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/hide_filled_translation.png"));
        this.hideFilledTranslationAction.setChecked(TranslationPreferences.getHideFilledTranslation());
        this.searchFilter.setCheckFilledTranslation(this.hideFilledTranslationAction.isChecked());
    }

    private void createShowComputedAction() {
        this.showComputedAction = new ToggleUpdateValueAction(Messages.TranslationsView_ShowAnyExtraStringsAction_name);
        this.showComputedAction.setToolTipText(Messages.TranslationsView_ShowAnyExtraStringsAction_ToolTip);
        this.showComputedAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/show_any.png"));
        this.showComputedAction.setChecked(TranslationPreferences.getShowComputed());
    }

    private void createShowModelAction() {
        this.showModelAction = new ToggleUpdateValueAction(Messages.TranslationsView_ShowModelAction_name);
        this.showModelAction.setToolTipText(Messages.TranslationsView_ShowModelAction_ToolTip);
        this.showModelAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/show_model.png"));
        this.showModelAction.setChecked(TranslationPreferences.getShowModel());
    }

    private void createShowInterfaceAction() {
        this.showInterfaceAction = new ToggleUpdateValueAction(Messages.TranslationsView_ShowInterfaceAction_name);
        this.showInterfaceAction.setToolTipText(Messages.TranslationsView_ShowInterfaceAction_ToolTip);
        this.showInterfaceAction.setImageDescriptor(TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/elcl16/show_interface.png"));
        this.showInterfaceAction.setChecked(TranslationPreferences.getShowInterface());
    }

    private void createDefaultStorageAction() {
        this.defaultStorageAction = new Action(Messages.TranslationsView_DefaultStorageAction_name, 8){

            public void run() {
                if (TranslationsView.this.getProject() != null) {
                    ProjectStorageSettings settings = TranslationsView.this.settingsManager.getSettingsOrDefault(TranslationsView.this.getProject());
                    TranslationsView.this.setCurrentStorageId(settings.getEdit().getStorageId());
                }
            }
        };
        this.defaultStorageAction.setToolTipText(Messages.TranslationsView_DefaultStorageAction_ToolTip);
        this.defaultStorageAction.setChecked(true);
    }

    private void createCopyAction() {
        this.copyAction = new CopyAction((ISelectionProvider)this.viewer);
    }

    private void createPasteAction() {
        this.pasteAction = new PasteAction((ISelectionProvider)this.viewer);
    }

    private void createFindAction() {
        this.findAction = new Action(Messages.TranslationsView_FindAction_name){

            public void run() {
                TranslationsView.this.searchText.setFocus();
            }
        };
        this.findAction.setToolTipText(Messages.TranslationsView_FindAction_ToolTip);
    }

    private void createDeleteAction() {
        this.deleteTranslationAction = new DelecteAction((ISelectionProvider)this.viewer);
    }

    private @Nullable IProject getProject() {
        if (this.getCurrentProject() == null) {
            return null;
        }
        return this.getCurrentProject().getProject();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IResource.class.isAssignableFrom(adapter)) {
            if (this.getProject() != null) {
                return adapter.cast(this.getProject());
            }
        } else if (TranslationSource.class.isAssignableFrom(adapter) && this.collectingResult != null) {
            return adapter.cast(this.collectingResult.getSourceObject());
        }
        return (T)super.getAdapter(adapter);
    }

    private class CopyAction
    extends SelectionProviderAction {
        protected CopyAction(ISelectionProvider provider) {
            super(provider, Messages.TranslationsView_CopyAction_name);
            this.setToolTipText(Messages.TranslationsView_CopyAction_ToolTip);
            ISharedImages sharedImages = TranslationsView.this.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            this.setEnabled(false);
        }

        public void run() {
            if (!TranslationsView.this.clipboard.isDisposed() && !this.getStructuredSelection().isEmpty()) {
                ArrayList copyText = Lists.newArrayList();
                for (Object sel : this.getStructuredSelection()) {
                    if (sel instanceof IFeatureValueItem && StringUtils.isNotEmpty((String)((IFeatureValueItem)sel).getFeatureValue().getContextKey().getValue())) {
                        copyText.add(((IFeatureValueItem)sel).getFeatureValue().getContextKey().getValue());
                        continue;
                    }
                    if (!(sel instanceof ITreeItem) || !StringUtils.isNotEmpty((String)((ITreeItem)sel).getPresentation())) continue;
                    copyText.add(((ITreeItem)sel).getPresentation());
                }
                LocalSelectionTransfer selectionTransfer = LocalSelectionTransfer.getTransfer();
                TextTransfer textTransfer = TextTransfer.getInstance();
                StructuredSelection newSelection = new StructuredSelection(this.getStructuredSelection().toArray());
                TranslationsView.this.clipboard.setContents(new Object[]{newSelection, String.join((CharSequence)", ", copyText)}, new Transfer[]{selectionTransfer, textTransfer});
                selectionTransfer.setSelection((ISelection)newSelection);
                selectionTransfer.setSelectionSetTime(System.currentTimeMillis());
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            boolean enable = false;
            if (!selection.isEmpty() && !TranslationsView.this.viewer.isCellEditorActive()) {
                for (Object sel : selection) {
                    if (!(sel instanceof ITreeItem)) continue;
                    enable = true;
                    break;
                }
            }
            this.setEnabled(enable);
        }
    }

    private class DelecteAction
    extends SelectionProviderAction {
        protected DelecteAction(ISelectionProvider provider) {
            super(provider, Messages.TranslationsView_DeleteAction_name);
            this.setToolTipText(Messages.TranslationsView_DeleteAction_ToolTip);
            ISharedImages sharedImages = TranslationsView.this.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            this.setEnabled(false);
        }

        public void run() {
            if (this.getStructuredSelection().isEmpty() || !this.isEnabled() || TranslationsView.this.getProject() == null || TranslationsView.this.currentStorage == null || TranslationsView.this.collectingResult == null) {
                return;
            }
            IEditingContext context = TranslationsView.this.collectingResult.getEditingContext();
            MessageDialog dialog = new MessageDialog(TranslationsView.this.getViewSite().getShell(), Messages.TranslationsView_Delete_question_title, null, Messages.TranslationsView_Delete_question_text, 3, 0, new String[]{this.getStructuredSelection().size() > 1 ? IDialogConstants.YES_TO_ALL_LABEL : IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            TranslationsView.this.getViewSite().getShell().getDisplay().syncExec(() -> {
                int n = dialog.open();
            });
            int result = dialog.getReturnCode();
            if (result == 1) {
                return;
            }
            for (ITreeItem sel : this.getStructuredSelection()) {
                if (sel instanceof LanguageFeatureValueItem) {
                    LanguageFeatureValueItem item = (LanguageFeatureValueItem)sel;
                    TranslateLanguage language = item.getLanguage();
                    if (!TranslationUtils.isValidFeatureForLanguage((FeatureSettings)item.getFeatureValue().getContextKey().getFeatureSettings(), (TranslateLanguage)language)) continue;
                    context.removeTranslation(TranslationsView.this.currentStorage, (TranslationKey)item.getFeatureValue(), language);
                    continue;
                }
                if (!(sel instanceof IFeatureValueItem)) continue;
                FeatureValue fv = ((IFeatureValueItem)sel).getFeatureValue();
                for (TranslateLanguage language : TranslationsView.this.languages) {
                    if (!TranslationUtils.isValidFeatureForLanguage((FeatureSettings)fv.getContextKey().getFeatureSettings(), (TranslateLanguage)language)) continue;
                    context.removeTranslation(TranslationsView.this.currentStorage, (TranslationKey)fv, language);
                }
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (!selection.isEmpty() && !TranslationsView.this.viewer.isCellEditorActive()) {
                for (ITreeItem sel : selection) {
                    if (!(sel instanceof IFeatureValueItem)) continue;
                    this.setEnabled(true);
                    return;
                }
            }
            this.setEnabled(false);
        }
    }

    private class NlsLableProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private NlsLableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            String columnName = (String)TranslationsView.this.viewer.getTree().getColumn(columnIndex).getData(TranslationsView.COLUMN_DATA_NAME);
            if (TranslationsView.COLUNM_NAME_KEY.equals(columnName)) {
                if (element instanceof LanguageFeatureValueItem) {
                    if (TranslationsView.this.getProject() == null) {
                        return SharedImages.getImage((String)"com.e1c.langtool.flags.ui/obj16/default.png");
                    }
                    String languageCode = ((LanguageFeatureValueItem)element).getTargetLanguage();
                    return SharedImages.getLanguageFlagImage((IProject)TranslationsView.this.getProject(), (String)languageCode);
                }
                if (element instanceof IFeatureValueItem) {
                    FeatureValue featureValue = ((IFeatureValueItem)element).getFeatureValue();
                    if (featureValue.isComputedValue() && !featureValue.getContextKey().getFeatureSettings().isInterface()) {
                        return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_model_computed_obj.png");
                    }
                    if (featureValue.isComputedValue() && featureValue.getContextKey().getFeatureSettings().isInterface()) {
                        return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_interface_computed_obj.png");
                    }
                    if (featureValue.isUnknown()) {
                        return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_model_unknown_obj.png");
                    }
                    if (!featureValue.getContextKey().getFeatureSettings().isInterface() && featureValue.getContextKey().getFeatureSettings().isUnique()) {
                        return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_model_key_obj.png");
                    }
                    if (!featureValue.getContextKey().getFeatureSettings().isInterface()) {
                        return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_model_obj.png");
                    }
                    if (featureValue.getContextKey().getFeatureSettings().isInterface()) {
                        return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_interface_obj.png");
                    }
                } else {
                    if (element instanceof GroupItem) {
                        return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_group_obj.png");
                    }
                    if (element instanceof ResourceItem) {
                        return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_resource_obj.png");
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String columnName;
            String result = null;
            switch (columnName = (String)TranslationsView.this.viewer.getTree().getColumn(columnIndex).getData(TranslationsView.COLUMN_DATA_NAME)) {
                case "key": {
                    if (!(element instanceof ITreeItem)) break;
                    result = ((ITreeItem)element).getPresentation();
                    break;
                }
                case "value": {
                    if (element instanceof LanguageFeatureValueItem) {
                        FeatureValue fv = ((LanguageFeatureValueItem)element).getFeatureValue();
                        return TranslationsView.this.getTranslation(fv, ((LanguageFeatureValueItem)element).getTargetLanguage());
                    }
                    if (!(element instanceof IFeatureValueItem)) break;
                    result = ((IFeatureValueItem)element).getFeatureValue().getContextKey().getValue();
                    break;
                }
                default: {
                    if (!(element instanceof IFeatureValueItem)) break;
                    FeatureValue fv = ((IFeatureValueItem)element).getFeatureValue();
                    result = TranslationsView.this.getTranslation(fv, columnName);
                }
            }
            return result != null ? result : "";
        }
    }

    private class PasteAction
    extends SelectionProviderAction {
        protected PasteAction(ISelectionProvider provider) {
            super(provider, Messages.TranslationsView_PasteAction_name);
            this.setToolTipText(Messages.TranslationsView_PasteAction_ToolTip);
            ISharedImages sharedImages = TranslationsView.this.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            this.setEnabled(false);
        }

        public void run() {
            if (this.getStructuredSelection().isEmpty() || !this.isEnabled() || TranslationsView.this.collectingResult == null || TranslationsView.this.currentStorage == null) {
                return;
            }
            IEditingContext context = TranslationsView.this.collectingResult.getEditingContext();
            MessageDialog dialog = new MessageDialog(TranslationsView.this.getViewSite().getShell(), Messages.TranslationsView_Replace_question_title, null, Messages.TranslationsView_Replace_question_text, 3, 0, new String[]{this.getStructuredSelection().size() > 1 ? IDialogConstants.YES_TO_ALL_LABEL : IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            TranslationsView.this.getViewSite().getShell().getDisplay().syncExec(() -> {
                int n = dialog.open();
            });
            int result = dialog.getReturnCode();
            if (result == 1) {
                return;
            }
            IFeatureValueItem source = null;
            ISelection copiedSelection = LocalSelectionTransfer.getTransfer().getSelection();
            if (copiedSelection instanceof IStructuredSelection) {
                for (Object sel : (IStructuredSelection)copiedSelection) {
                    if (!(sel instanceof IFeatureValueItem)) continue;
                    source = (IFeatureValueItem)sel;
                    break;
                }
            }
            if (source == null || TranslationsView.this.isReadOnly()) {
                return;
            }
            for (Object sel : this.getStructuredSelection()) {
                if (source.equals(sel) || !(sel instanceof IFeatureValueItem)) continue;
                this.copyTranslation(context, TranslationsView.this.currentStorage, source, (IFeatureValueItem)sel);
            }
        }

        private void copyTranslation(IEditingContext context, StorageID storageId, IFeatureValueItem source, IFeatureValueItem target) {
            TranslateLanguage language2;
            boolean singleLanguageSource = source instanceof LanguageFeatureValueItem;
            FeatureValue fv = target.getFeatureValue();
            String translation = null;
            if (singleLanguageSource) {
                language2 = ((LanguageFeatureValueItem)source).getLanguage();
                translation = context.getTranslation(storageId, (TranslationKey)source.getFeatureValue(), language2);
            }
            if (target instanceof LanguageFeatureValueItem) {
                language2 = ((LanguageFeatureValueItem)target).getLanguage();
                if (!singleLanguageSource) {
                    translation = context.getTranslation(storageId, (TranslationKey)source.getFeatureValue(), language2);
                }
                context.setTranslation(storageId, (TranslationKey)fv, language2, translation);
            } else {
                for (TranslateLanguage language2 : TranslationsView.this.languages) {
                    if (!singleLanguageSource) {
                        translation = context.getTranslation(storageId, (TranslationKey)source.getFeatureValue(), language2);
                    }
                    if (!TranslationUtils.isValidFeatureForLanguage((FeatureSettings)fv.getContextKey().getFeatureSettings(), (TranslateLanguage)language2)) continue;
                    context.setTranslation(storageId, (TranslationKey)fv, language2, translation);
                }
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            boolean enabled = false;
            if (!selection.isEmpty() && !TranslationsView.this.viewer.isCellEditorActive()) {
                boolean couldPaste = false;
                for (ITreeItem sel : selection) {
                    if (!(sel instanceof IFeatureValueItem)) continue;
                    couldPaste = true;
                    break;
                }
                TransferData[] available = TranslationsView.this.clipboard.getAvailableTypes();
                int i = 0;
                block1: while (i < available.length && couldPaste) {
                    if (TextTransfer.getInstance().isSupportedType(available[i])) {
                        ISelection copiedSelection = LocalSelectionTransfer.getTransfer().getSelection();
                        if (!(copiedSelection instanceof IStructuredSelection) || copiedSelection.isEmpty()) break;
                        for (Object sel : (IStructuredSelection)copiedSelection) {
                            if (!(sel instanceof IFeatureValueItem)) continue;
                            if (enabled) {
                                enabled = false;
                                break block1;
                            }
                            enabled = true;
                        }
                        break;
                    }
                    ++i;
                }
            }
            this.setEnabled(enabled);
        }
    }

    private class StorageAction
    extends Action {
        private final StorageID storageId;

        protected StorageAction(StorageSettings storageSetting) {
            super(storageSetting.getPresentation(), 8);
            this.storageId = storageSetting.getStorageId();
            this.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("checked".equals(event.getProperty())) {
                        TranslationsView.this.setCurrentStorageId(StorageAction.this.storageId);
                    }
                }
            });
        }
    }

    private class StorageValueChangedListener
    implements IStorageValueChangedListener {
        private StorageValueChangedListener() {
        }

        public void changed(StorageValueChangeEvent event) {
            Display display;
            if (!this.collectingResultIsEmpty() && this.eventHasCurrentStorageID(event) && this.collectingResultHasTranslationKey(event) && !TranslationsView.this.viewer.getTree().isDisposed() && !(display = TranslationsView.this.viewer.getTree().getDisplay()).isDisposed()) {
                display.asyncExec(() -> ((TreeViewer)TranslationsView.this.viewer).refresh());
            }
        }

        private boolean collectingResultHasTranslationKey(StorageValueChangeEvent event) {
            TranslationKey key = event.getTranslationKey();
            if (key instanceof FeatureValue) {
                return TranslationsView.this.collectingResult.getValues().contains(key);
            }
            return TranslationsView.this.collectingResult.getValues().stream().anyMatch(v -> v.getContextKey().equals(key));
        }

        private boolean collectingResultIsEmpty() {
            return TranslationsView.this.collectingResult == null || TranslationsView.this.collectingResult.getValues().isEmpty();
        }

        private boolean eventHasCurrentStorageID(StorageValueChangeEvent event) {
            return TranslationsView.this.currentStorage != null && event.getStorageID().equals((Object)TranslationsView.this.currentStorage);
        }
    }

    private class ToggleAction
    extends Action {
        public ToggleAction(String title) {
            super(title, 2);
        }
    }

    private class ToggleUpdateValueAction
    extends Action {
        public ToggleUpdateValueAction(String title) {
            super(title, 2);
        }

        public void run() {
            if (TranslationsView.this.collectingResult != null && !TranslationsView.this.collectingResult.isDisposed()) {
                TranslationsView.this.collectingService.refresh(TranslationsView.this, TranslationsView.this.collectingResult);
            }
        }
    }

    private class ViewerTreeFactory
    extends AbstractTreeFactory {
        private ViewerTreeFactory() {
        }

        @Override
        public IFeatureValueItem createFeatureValueItem(ITreeItem parent, FeatureValue value, int skipKeySegments) {
            IFeatureValueItem item;
            if (TranslationsView.this.getCurrentProject() == null) {
                return super.createFeatureValueItem(parent, value, skipKeySegments);
            }
            TranslateLanguage sourceLanguage = TranslationsView.this.getCurrentProject().getDefaultLanguage();
            if (TranslationsView.this.isSingleLanguage()) {
                TranslateLanguage language = TranslationsView.this.languages.get(0);
                item = new SingleLanguageFeatureValueItem(parent, value, skipKeySegments, sourceLanguage, language, TranslationsView.this.collectingResult.getEditingContext(), TranslationsView.this.getProject(), TranslationsView.this.currentStorage, TranslationsView.this.storageManager, TranslationsView.this.registry);
            } else if (TranslationsView.this.languagesInColumns) {
                item = super.createFeatureValueItem(parent, value, skipKeySegments);
            } else {
                item = new ContainerFeatureValueItem(parent, value, skipKeySegments);
                ITreeItemContainer container = (ITreeItemContainer)((Object)item);
                boolean isModel = value.getContextKey().getFeatureSettings().isModel();
                for (TranslateLanguage language : TranslationsView.this.languages) {
                    if (isModel && TranslationOption.INTERFACE_ONLY == language.getOption()) continue;
                    LanguageFeatureValueItem subItem = new LanguageFeatureValueItem((ITreeItem)item, value, skipKeySegments, sourceLanguage, language, TranslationsView.this.collectingResult.getEditingContext(), TranslationsView.this.currentStorage, TranslationsView.this.getProject(), TranslationsView.this.storageManager, TranslationsView.this.registry);
                    container.getChildren().add(subItem);
                }
            }
            return item;
        }
    }
}

