/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.collector;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.ui.collector.FeatureValueCollectingResult;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class CommonFeatureValueCollectingResult
implements FeatureValueCollectingResult {
    private final TranslationSource source;
    private final Function<TranslationSource, ITranslatingProject> projectProvider;
    private final Collection<FeatureValue> values;
    private final AtomicBoolean disposed = new AtomicBoolean();
    private IWorkbenchPart part;
    private ISelection selection;
    private IEditingContext context;

    public CommonFeatureValueCollectingResult(TranslationSource source, Collection<FeatureValue> values, IWorkbenchPart part, ISelection selection, IEditingContext context, Function<TranslationSource, ITranslatingProject> projectProvider) {
        this.source = source;
        this.values = values;
        this.part = part;
        this.selection = selection;
        this.context = context;
        this.projectProvider = projectProvider;
    }

    @Override
    public ITranslatingProject getProject() {
        return this.projectProvider.apply(this.getSourceObject());
    }

    @Override
    public TranslationSource getSourceObject() {
        return this.source;
    }

    @Override
    public IWorkbenchPart getSelectedPart() {
        return this.part;
    }

    @Override
    public ISelection getSelection() {
        return this.selection;
    }

    @Override
    public Collection<FeatureValue> getValues() {
        return this.values;
    }

    @Override
    public IEditingContext getEditingContext() {
        return this.context;
    }

    @Override
    public void dispose() {
        this.disposed.set(true);
        this.values.clear();
        this.part = null;
        this.selection = null;
        this.context = null;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed.get();
    }
}

