/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.common.memento;

import com.e1c.langtool.ui.common.memento.IPersistableComponent;
import com.e1c.langtool.ui.common.memento.IPersistableComponentFactory;
import com.e1c.langtool.ui.common.memento.annotation.PersistantAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;

public class PersistableActionFactory
implements IPersistableComponentFactory<PersistantAction, IAction> {
    @Override
    public IPersistableComponent create(PersistantAction annotation, IAction component) {
        return new ActionPersistableComponent(component, annotation.id());
    }

    public static class ActionPersistableComponent
    implements IPersistableComponent {
        public static final String CHECKED_KEY = "checked";
        private final String id;
        private final IAction component;

        public ActionPersistableComponent(IAction action, String id) {
            this.id = id;
            this.component = action;
        }

        @Override
        public void saveState(IDialogSettings settings) {
            settings.put(this.getCheckedKey(), this.component.isChecked());
        }

        @Override
        public void initState(IDialogSettings settings) {
            this.component.setChecked(settings.getBoolean(this.getCheckedKey()));
        }

        private String getCheckedKey() {
            return this.id + "_checked";
        }
    }
}

