/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.common.memento;

import com.e1c.langtool.ui.common.memento.IPersistableComponent;
import com.e1c.langtool.ui.common.memento.IPersistableComponentFactory;
import com.e1c.langtool.ui.common.memento.annotation.PersistantTable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Table;

public class PersistableTableFactory
implements IPersistableComponentFactory<PersistantTable, Table> {
    @Override
    public IPersistableComponent create(PersistantTable annotation, Table table) {
        return new TablePersistableComponent(annotation, table);
    }

    public static class TablePersistableComponent
    implements IPersistableComponent {
        private final PersistantTable annotation;
        private final Table table;
        private final Set<PersistantTable.TableAttribute> attrs;

        public TablePersistableComponent(PersistantTable annotation, Table table) {
            this.annotation = annotation;
            this.table = table;
            this.attrs = new HashSet<PersistantTable.TableAttribute>(Set.of(annotation.attrs()));
        }

        @Override
        public void initState(IDialogSettings settings) {
            for (PersistantTable.TableAttribute type : this.attrs) {
                if (type == PersistantTable.TableAttribute.COLUMN_ORDER) {
                    this.initColumnOrder(settings);
                    continue;
                }
                if (type != PersistantTable.TableAttribute.COLUMN_WIDTH) continue;
                this.initColumnWidth(settings);
            }
        }

        @Override
        public void saveState(IDialogSettings settings) {
            for (PersistantTable.TableAttribute type : this.attrs) {
                if (type == PersistantTable.TableAttribute.COLUMN_ORDER) {
                    this.saveColumnOrder(settings);
                    continue;
                }
                if (type != PersistantTable.TableAttribute.COLUMN_WIDTH) continue;
                this.saveColumnWidth(settings);
            }
        }

        private void saveColumnOrder(IDialogSettings settings) {
            String[] order = (String[])Arrays.stream(this.table.getColumnOrder()).mapToObj(String::valueOf).toArray(String[]::new);
            settings.put(this.getColumnOrderKey(), order);
        }

        private void initColumnOrder(IDialogSettings settings) {
            String[] order = settings.getArray(this.getColumnOrderKey());
            if (order != null) {
                int[] columnOrder = Stream.of(order).mapToInt(Integer::parseInt).toArray();
                this.table.setColumnOrder(columnOrder);
            }
        }

        private void saveColumnWidth(IDialogSettings settings) {
            int i = 0;
            while (i < this.table.getColumnCount()) {
                settings.put(this.getColumnWidthKey(i), this.table.getColumn(i).getWidth());
                ++i;
            }
        }

        private void initColumnWidth(IDialogSettings settings) {
            int i = 0;
            while (i < this.table.getColumnCount()) {
                try {
                    this.table.getColumn(i).setWidth(settings.getInt(this.getColumnWidthKey(i)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i;
            }
        }

        private String getColumnOrderKey() {
            return this.annotation.id() + "_column_order";
        }

        private String getColumnWidthKey(int column) {
            return this.annotation.id() + "_column_" + column + "_width";
        }
    }
}

