/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.common.memento.annotation;

import com.e1c.langtool.ui.common.memento.IPersistableComponent;
import com.e1c.langtool.ui.common.memento.IPersistableComponentFactory;
import com.e1c.langtool.ui.common.memento.PersistableActionFactory;
import com.e1c.langtool.ui.common.memento.PersistableTableFactory;
import com.e1c.langtool.ui.common.memento.annotation.IAnnotationEngine;
import com.e1c.langtool.ui.common.memento.annotation.PersistantAction;
import com.e1c.langtool.ui.common.memento.annotation.PersistantTable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;

public class AnnotationEngine
implements IAnnotationEngine {
    private final IPersistableComponentFactory<PersistantTable, Table> tableFactory = new PersistableTableFactory();
    private final IPersistableComponentFactory<PersistantAction, IAction> actionFactory = new PersistableActionFactory();

    @Override
    public IPersistableComponent process(Object object) {
        Class<?> rootCls = object.getClass();
        HashSet<IPersistableComponent> components = new HashSet<IPersistableComponent>();
        Field[] fieldArray = rootCls.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(PersistantTable.class)) {
                components.add(this.processTable(object, field));
            } else if (field.isAnnotationPresent(PersistantAction.class)) {
                components.add(this.proccessAction(object, field));
            }
            ++n2;
        }
        return new CompositePersistableComponent(components);
    }

    private IPersistableComponent processTable(Object object, Field field) {
        Table table;
        PersistantTable annotation = field.getAnnotation(PersistantTable.class);
        field.setAccessible(true);
        if (field.getType() == Table.class) {
            table = this.getFieldObject(() -> (Table)field.get(object));
        } else if (field.getType() == TableViewer.class) {
            table = this.getFieldObject(() -> ((TableViewer)field.get(object)).getTable());
        } else {
            throw this.createInvalidFieldTypeException(field, annotation.getClass());
        }
        return this.tableFactory.create(annotation, table);
    }

    private IPersistableComponent proccessAction(Object object, Field field) {
        PersistantAction annotation = field.getAnnotation(PersistantAction.class);
        field.setAccessible(true);
        if (field.getType() != IAction.class) {
            throw this.createInvalidFieldTypeException(field, annotation.getClass());
        }
        IAction action = this.getFieldObject(() -> (IAction)field.get(object));
        return this.actionFactory.create(annotation, action);
    }

    private IllegalArgumentException createInvalidFieldTypeException(Field field, Class<?> annotationClass) {
        return new IllegalArgumentException("[" + field.getName() + "] has invalid type for " + annotationClass.getName() + " annotation");
    }

    private <T> T getFieldObject(ThrowableSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final class CompositePersistableComponent
    implements IPersistableComponent {
        private final Set<IPersistableComponent> components = new HashSet<IPersistableComponent>();

        public CompositePersistableComponent(Set<IPersistableComponent> components) {
            this.components.addAll(components);
        }

        @Override
        public void saveState(IDialogSettings settings) {
            this.components.stream().forEach(component -> component.saveState(settings));
        }

        @Override
        public void initState(IDialogSettings settings) {
            this.components.stream().forEach(component -> component.initState(settings));
        }
    }

    private static interface ThrowableSupplier<T> {
        public T get() throws IllegalAccessException;
    }
}

