/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.common.tools;

import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.ui.common.combo.IComboBox;
import com.e1c.langtool.ui.common.tools.Messages;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;

public final class ToolBarBuilder {
    public static final String SOURCE_LANG_COMBO_ID = "sourceLanguageContributionItem";
    public static final String TARGET_LANG_COMBO_ID = "targetLanguageContributionItem";
    private final IToolBarManager tbm;

    public ToolBarBuilder(IToolBarManager tbm) {
        this.tbm = tbm;
    }

    public ToolBarBuilder separator() {
        this.tbm.add((IContributionItem)new Separator());
        return this;
    }

    public ToolBarBuilder item(ContributionItem item) {
        this.tbm.add((IContributionItem)item);
        return this;
    }

    public <T> ToolBarBuilder swapLanguagesAction(IComboBox<T> sourceCombo, IComboBox<T> targetCombo) {
        IAction changeLangAction = this.createAction(() -> {
            int temp = sourceCombo.getSelectionIndex();
            sourceCombo.select(targetCombo.getSelectionIndex());
            targetCombo.select(temp);
        }, this.getImgDescr("com.e1c.langtool.ui/elcl16/swap_lngs.png"), Messages.ToolBarBuilder_SwapLanguagesAction);
        this.tbm.add(changeLangAction);
        return this;
    }

    public ToolBarBuilder runTranslationAction(Runnable runner) {
        IAction action = this.createAction(runner, this.getImgDescr("com.e1c.langtool.ui/elcl16/run_trans_tsk.png"), Messages.ToolBarBuilder_RunTranslationAction);
        this.tbm.add(action);
        return this;
    }

    public ToolBarBuilder textProcessingAction(Consumer<IAction> initializer) {
        IAction action = this.createCheckBoxAction(this.getImgDescr("com.e1c.langtool.ui/elcl16/txt_proc_mode.png"), Messages.ToolBarBuilder_ProcessingAction);
        initializer.accept(action);
        this.tbm.add(action);
        return this;
    }

    public ToolBarBuilder autoTranslatableAction(Consumer<IAction> initializer) {
        IAction action = this.createCheckBoxAction(this.getImgDescr("com.e1c.langtool.ui/elcl16/auto_trans_mode.png"), Messages.ToolBarBuilder_AutoTranslatableAction);
        initializer.accept(action);
        this.tbm.add(action);
        return this;
    }

    public IToolBarManager build() {
        return this.tbm;
    }

    private ImageDescriptor getImgDescr(String symbolicName) {
        return TransSharedImages.getImageDescriptor(symbolicName);
    }

    private IAction createAction(final Runnable runnable, ImageDescriptor image, String text, int style) {
        Action action = new Action(text, style){

            public void run() {
                runnable.run();
            }
        };
        action.setImageDescriptor(image);
        return action;
    }

    private IAction createAction(Runnable runnable, ImageDescriptor imageDescriptor, String text) {
        return this.createAction(runnable, imageDescriptor, text, 1);
    }

    private IAction createCheckBoxAction(ImageDescriptor imageDescriptor, String text) {
        return this.createAction(() -> {}, imageDescriptor, text, 2);
    }
}

