/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.external;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.LocaleUtils;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.ui.external.ExternalTranslationView;
import com.e1c.langtool.ui.external.Messages;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.FrameworkUtil;

public class TranslationAssistView
extends ExternalTranslationView {
    public static final String ID = "com.e1c.langtool.ui.translationAssistView";
    private List<String> providerIds = new CopyOnWriteArrayList<String>();
    private IObservableList<Pair<String, Integer>> translations;
    private Composite top;
    private ObservableListContentProvider<Pair<String, Integer>> contentProvider;
    private IPropertyChangeListener settingsChangeListener;
    private IContextTranslationQuery activeQuery;

    @Inject
    public TranslationAssistView(IExternalTranslationManager manager) {
        super(manager, null, "com.e1c.langtool.ui.translationAssist");
    }

    @Override
    public void createPartControl(Composite parent) {
        this.translations = new WritableList(new CopyOnWriteArrayList(), null);
        super.createPartControl(parent);
        this.top = this.getTopComposite();
        this.loadProviders();
        this.settingsChangeListener = event -> {
            if (event.getProperty().equals("translationAssistProviders")) {
                this.loadProviders();
            }
        };
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.settingsChangeListener);
    }

    @Override
    public void dispose() {
        if (this.settingsChangeListener != null) {
            UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.settingsChangeListener);
        }
        super.dispose();
    }

    private void loadProviders() {
        String listOfIds = UiPlugin.getDefault().getPreferenceStore().getString("translationAssistProviders");
        if (listOfIds == null) {
            listOfIds = "";
        }
        String[] ids = listOfIds.split(",");
        boolean needUpdatelanguages = false;
        List<String> loaded = List.of(ids);
        if (!this.providerIds.equals(loaded)) {
            needUpdatelanguages = true;
        }
        this.providerIds.clear();
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            if (!id.isEmpty()) {
                this.providerIds.add(id);
            }
            ++i;
        }
        if (this.providerIds.isEmpty()) {
            this.isLangsInitialized = false;
            needUpdatelanguages = false;
            this.showProvidersEmptyError();
        } else {
            this.hideError();
        }
        if (needUpdatelanguages) {
            if (this.isLangsInitialized) {
                this.isLangsInitialized = false;
            }
            this.updateLanguages();
        }
    }

    @Override
    protected Object getTranslationInput() {
        return this.translations;
    }

    @Override
    protected IContentProvider getTranslationTableContentProvider() {
        this.contentProvider = new ObservableListContentProvider();
        return this.contentProvider;
    }

    @Override
    protected IBaseLabelProvider getTranslationTableLabelProvider() {
        return new ObservableMapLabelProvider(Properties.observeEach((IObservableSet)this.contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{Properties.convertedValue(Pair::getKey)})){

            public String getText(Object element) {
                if (element instanceof Pair && ((Pair)element).getKey() instanceof String) {
                    return (String)((Pair)element).getKey();
                }
                return super.getText(element);
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof Pair && ((Pair)element).getValue() instanceof Integer) {
                    int index = (Integer)((Pair)element).getValue();
                    if (index > -1 && index < TranslationAssistView.this.providerIds.size()) {
                        String providerId = TranslationAssistView.this.providerIds.get(index);
                        IExternalTranslationProvider provider = TranslationAssistView.this.translationManager.getTranslationProviderRegistry().getExternalTranslationProvider(providerId);
                        return this.getProviderTranslationItemImage(provider);
                    }
                    return null;
                }
                return null;
            }

            private Image getProviderTranslationItemImage(IExternalTranslationProvider provider) {
                String bundleName;
                Optional imageDescriptor;
                String name = provider.getTranslationItemImageName();
                if (name != null && (imageDescriptor = ResourceLocator.imageDescriptorFromBundle((String)(bundleName = FrameworkUtil.getBundle(provider.getClass()).getSymbolicName()), (String)name)).isPresent()) {
                    return imageDescriptor.map(d -> JFaceResources.getResources().createImageWithDefault(d)).orElse(null);
                }
                return null;
            }
        };
    }

    @Override
    protected Map<String, String> getSupportedLanguages() {
        HashMap<String, String> supportedLanguages = new HashMap<String, String>();
        boolean isThrowed = false;
        for (String providerId : this.providerIds) {
            IExternalTranslationProvider provider = this.translationManager.getTranslationProviderRegistry().getExternalTranslationProvider(providerId);
            if (provider == null) continue;
            String currentLocale = Locale.getDefault().toLanguageTag();
            try {
                Map langsMap = provider.getLanguages(LocaleUtils.getCode((String)currentLocale));
                if (langsMap == null && (langsMap = provider.getLanguages("en")) == null) {
                    try {
                        langsMap = provider.getLanguages((String)provider.getLanguageCodes().iterator().next());
                    }
                    catch (NoSuchElementException exc) {
                        throw new TranslationServiceException(Messages.ExternalTranslationView_NoSupportedLanguagesExceptionMsg, (Throwable)exc);
                    }
                    catch (TranslationServiceException e2) {
                        this.handleTranslationException(e2);
                    }
                }
                if (langsMap == null || langsMap.isEmpty()) continue;
                langsMap.entrySet().forEach(e -> {
                    String string = supportedLanguages.computeIfAbsent((String)e.getKey(), k -> (String)e.getValue());
                });
            }
            catch (TranslationServiceException e3) {
                isThrowed = true;
                this.handleTranslationException(e3);
            }
        }
        if (supportedLanguages.size() == 0 && !isThrowed) {
            throw new TranslationServiceException(Messages.ExternalTranslationView_NoSupportedLanguagesExceptionMsg);
        }
        this.isLangsInitialized = true;
        return supportedLanguages;
    }

    @Override
    protected Job createJobFromQuery(final ISingleTranslationQuery query) {
        return new Job(this.getTitle()){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)TranslationAssistView.this.providerIds.size());
                if (TranslationAssistView.this.top != null && !TranslationAssistView.this.top.isDisposed() && !TranslationAssistView.this.top.getDisplay().isDisposed()) {
                    TranslationAssistView.this.top.getDisplay().syncExec(() -> TranslationAssistView.this.translations.clear());
                }
                for (String providerId : TranslationAssistView.this.providerIds) {
                    if (subMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        int providerIndex = TranslationAssistView.this.providerIds.indexOf(providerId);
                        List res = TranslationAssistView.this.translationManager.translate(query, providerId, (IProgressMonitor)subMonitor);
                        if (!(res.isEmpty() || TranslationAssistView.this.top == null || TranslationAssistView.this.top.isDisposed() || TranslationAssistView.this.top.getDisplay().isDisposed())) {
                            TranslationAssistView.this.top.getDisplay().syncExec(() -> res.forEach(e -> {
                                boolean bl = TranslationAssistView.this.translations.add((Object)new Pair(e, (Object)providerIndex));
                            }));
                        }
                    }
                    catch (TranslationServiceException exc) {
                        TranslationAssistView.this.handleTranslationException(exc);
                    }
                    if (subMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    subMonitor.worked(1);
                }
                return Status.OK_STATUS;
            }
        };
    }

    @Override
    protected void clear() {
        this.activeQuery = null;
        super.clear();
    }

    @Override
    protected void setActiveQuery(ISingleTranslationQuery query) {
        this.activeQuery = null;
        super.setActiveQuery(query);
        if (query instanceof IContextTranslationQuery) {
            this.activeQuery = (IContextTranslationQuery)query;
        }
    }

    @Override
    protected Optional<ISingleTranslationQuery> createQueryFromState() {
        if (this.activeQuery != null) {
            return Optional.of(this.activeQuery);
        }
        return super.createQueryFromState();
    }

    private void showProvidersEmptyError() {
        this.showError(Messages.ExternalTranslationView_ProvidersEmptyErrorTitle, Messages.ExternalTranslationView_ProvidersEmptyErrorDetailMsg, null);
    }
}

