/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.generatestring;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.ui.generatestring.FilterSettingSection;
import com.e1c.langtool.ui.generatestring.FilterSettingsPageSectionFactory;
import com.e1c.langtool.ui.generatestring.Messages;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

public class FilterSettingsWizardPage
extends WizardPage
implements IPageChangedListener {
    private final FilterSettingsPageSectionFactory pageSectionFactory;
    private final List<FilterSettingSection> sections = new ArrayList<FilterSettingSection>();
    private TranslationStringsGenerator generator;

    @Inject
    protected FilterSettingsWizardPage(FilterSettingsPageSectionFactory pageSectionFactory) {
        super("FilterSettingsPage", Messages.FilterSettingsWizardPage_title, TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/wizban/generatestring_settings_wizard.png"));
        this.setDescription(Messages.FilterSettingsWizardPage_description);
        this.pageSectionFactory = pageSectionFactory;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        List<FilterSettingSection> createdSections = this.pageSectionFactory.createPageSections(this.generator.getTranslatingProject());
        this.sections.addAll(createdSections);
        for (FilterSettingSection filterSettingSection : this.sections) {
            String description = filterSettingSection.getDescription();
            Section section = new Section(topLevel, (StringUtils.isNotEmpty((String)description) ? 128 : 0) | 0x100 | 0x40 | 2);
            section.setText(filterSettingSection.getTitle());
            if (StringUtils.isNotEmpty((String)description)) {
                section.setDescription(description);
            }
            Composite content = new Composite((Composite)section, 0);
            GridLayoutFactory.fillDefaults().applyTo(content);
            section.setClient((Control)content);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
            content.setLayout((Layout)new GridLayout(1, false));
            content.setLayoutData((Object)new GridData(768));
            if (this.sections.size() > 2 && this.sections.indexOf(filterSettingSection) > 2) {
                section.setExpanded(false);
            }
            filterSettingSection.createContent(this.generator, this, content, section);
        }
        if (!this.sections.isEmpty() && this.getContainer() instanceof IPageChangeProvider) {
            IPageChangeProvider provider = (IPageChangeProvider)this.getContainer();
            provider.addPageChangedListener((IPageChangedListener)this);
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
        this.setPageComplete(true);
    }

    public void dispose() {
        this.sections.forEach(FilterSettingSection::dispose);
        super.dispose();
    }

    public void setGenerator(TranslationStringsGenerator generator) {
        this.generator = generator;
    }

    public void setErrorMessage(String newMessage) {
        List newMessages = this.sections.stream().map(FilterSettingSection::getErrorMessage).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (newMessages.isEmpty()) {
            super.setErrorMessage(null);
        } else {
            super.setErrorMessage(String.join((CharSequence)"; ", newMessages));
        }
    }

    public boolean isPageComplete() {
        return this.sections.stream().allMatch(FilterSettingSection::isSectionComplete) && this.generator != null && this.generator.checkSettings();
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(this.isPageComplete());
    }

    public void updateFilterParameters() {
        this.generator.enableCache();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (FilterSettingSection filterSettingSection : this.sections) {
            filterSettingSection.updateFilterParameters(parameters);
        }
        this.generator.setFilterParameters(parameters);
    }

    public void pageChanged(PageChangedEvent event) {
        if (((Object)((Object)this)).equals(event.getSelectedPage())) {
            this.generator.enableCache();
        }
        if (event.getSelectedPage() instanceof IWizardPage && ((Object)((Object)this)).equals(this.getWizard().getPreviousPage((IWizardPage)event.getSelectedPage()))) {
            this.updateFilterParameters();
        }
    }
}

