/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.generatestring;

import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.ExternalTranslationProviderAttrs;
import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.ITranslationProviderRegistry;
import com.e1c.langtool.generatestring.FillUpType;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.ui.generatestring.Messages;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class GenerateSettingsWizardPage
extends WizardPage {
    @Inject
    protected ITranslationStorageManager storageManager;
    @Inject
    protected IExternalTranslationManager translationManager;
    protected Button collectInterfaceStringsCheckbox;
    protected Button collectModelStringsCheckbox;
    protected Button collectModelTypeAnyRadio;
    protected Button collectModelTypeNoneRadio;
    protected Button collectModelTypeOnlyRadio;
    protected Button collectUnknownMethodOnlyRadio;
    protected Button collectTagsOnlyRadio;
    protected Button fillupByBlankRadio;
    protected Button fillupFromSourceLanguageCheckbox;
    protected Button fillupFromExternalProviderCheckbox;
    protected CheckboxTableViewer languagesViewer;
    protected ComboViewer storageCombobox;
    protected ComboViewer externalProviderCombobox;
    protected ILabelProvider lableProvider = new LanguageLableProvider();
    protected ILabelProvider storageLabelProvider = new StorageLabelProvider();
    protected ILabelProvider externalProviderLabelProvider = new ExternalProviderLableProvider();
    protected SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == null) {
                return;
            }
            if (source.equals(GenerateSettingsWizardPage.this.collectInterfaceStringsCheckbox)) {
                GenerateSettingsWizardPage.this.getGenerator().setCollectInterfaceStrings(GenerateSettingsWizardPage.this.collectInterfaceStringsCheckbox.getSelection());
            } else if (source.equals(GenerateSettingsWizardPage.this.collectModelStringsCheckbox)) {
                GenerateSettingsWizardPage.this.getGenerator().setCollectModelStrings(GenerateSettingsWizardPage.this.collectModelStringsCheckbox.getSelection());
            } else if (source.equals(GenerateSettingsWizardPage.this.collectModelTypeAnyRadio) || source.equals(GenerateSettingsWizardPage.this.collectModelTypeNoneRadio) || source.equals(GenerateSettingsWizardPage.this.collectModelTypeOnlyRadio) || source.equals(GenerateSettingsWizardPage.this.collectUnknownMethodOnlyRadio) || source.equals(GenerateSettingsWizardPage.this.collectTagsOnlyRadio)) {
                if (source.equals(GenerateSettingsWizardPage.this.collectModelTypeAnyRadio)) {
                    GenerateSettingsWizardPage.this.getGenerator().setCollectModelType(ICollectingParameters.CollectModelType.ANY);
                } else if (source.equals(GenerateSettingsWizardPage.this.collectModelTypeOnlyRadio)) {
                    GenerateSettingsWizardPage.this.getGenerator().setCollectModelType(ICollectingParameters.CollectModelType.COMPUTED_ONLY);
                } else if (source.equals(GenerateSettingsWizardPage.this.collectUnknownMethodOnlyRadio)) {
                    GenerateSettingsWizardPage.this.getGenerator().setCollectModelType(ICollectingParameters.CollectModelType.UNKNOWN_ONLY);
                } else if (source.equals(GenerateSettingsWizardPage.this.collectTagsOnlyRadio)) {
                    GenerateSettingsWizardPage.this.getGenerator().setCollectModelType(ICollectingParameters.CollectModelType.TAGS_ONLY);
                } else {
                    GenerateSettingsWizardPage.this.getGenerator().setCollectModelType(ICollectingParameters.CollectModelType.NONE);
                }
            } else if (source.equals(GenerateSettingsWizardPage.this.fillupFromSourceLanguageCheckbox) || source.equals(GenerateSettingsWizardPage.this.fillupFromExternalProviderCheckbox) || source.equals(GenerateSettingsWizardPage.this.fillupByBlankRadio)) {
                if (GenerateSettingsWizardPage.this.fillupFromSourceLanguageCheckbox.getSelection()) {
                    GenerateSettingsWizardPage.this.getGenerator().setFillUpType(FillUpType.FROM_SOURCE_LANGUAGE);
                } else if (GenerateSettingsWizardPage.this.fillupFromExternalProviderCheckbox.getSelection()) {
                    GenerateSettingsWizardPage.this.getGenerator().setFillUpType(FillUpType.FROM_PROVIDER);
                } else {
                    GenerateSettingsWizardPage.this.getGenerator().setFillUpType(FillUpType.NOT_FILLUP);
                }
            }
            GenerateSettingsWizardPage.this.setPageComplete(GenerateSettingsWizardPage.this.validatePage());
        }
    };
    protected TranslationStringsGenerator generator;

    public GenerateSettingsWizardPage() {
        super("GenerateSettingsPage", Messages.GenerateSettingsWizardPage_Settings, TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/wizban/generatestring_settings_wizard.png"));
        this.setDescription(Messages.GenerateSettingsWizardPage_Description);
    }

    public TranslationStringsGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(TranslationStringsGenerator generator) {
        this.generator = generator;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        this.createCollectCheckbox(topLevel);
        this.createLanguageTable(topLevel);
        this.createStorageControl(topLevel);
        this.createFillupControl(topLevel);
        this.addLanguagesToTable();
        List storageIds = this.storageManager.getStorageIds(this.getGenerator().getProject());
        storageIds = storageIds.stream().filter(s -> {
            IProject project = this.getGenerator().getProject();
            if (project == null) {
                return false;
            }
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, s);
            return storage == null ? false : !storage.isReadOnly();
        }).collect(Collectors.toList());
        this.storageCombobox.setInput(storageIds);
        if (this.getGenerator().getStorageId() != null && storageIds.contains(this.getGenerator().getStorageId())) {
            this.storageCombobox.setSelection((ISelection)new StructuredSelection((Object)this.getGenerator().getStorageId()));
        } else if (!storageIds.isEmpty()) {
            this.storageCombobox.setSelection((ISelection)new StructuredSelection(storageIds.get(0)));
        } else {
            this.storageCombobox.setSelection((ISelection)new StructuredSelection());
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
        this.setPageComplete(this.validatePage());
    }

    protected void createFillupControl(Composite parent) {
        Font font = parent.getFont();
        Group fillUpGroup = new Group(parent, 0);
        fillUpGroup.setText(Messages.GenerateSettingsWizardPage_Fill_up_blank_translations);
        fillUpGroup.setLayout((Layout)new GridLayout(2, false));
        fillUpGroup.setLayoutData((Object)new GridData(768));
        this.fillupByBlankRadio = new Button((Composite)fillUpGroup, 16);
        this.fillupByBlankRadio.setText(Messages.GenerateSettingsWizardPage_do_not_fill_up);
        this.fillupByBlankRadio.setSelection(this.getGenerator().getFillUpType() == FillUpType.NOT_FILLUP);
        this.fillupByBlankRadio.addSelectionListener(this.listener);
        GridData fillUpByBlankGridData = new GridData();
        fillUpByBlankGridData.horizontalSpan = 2;
        this.fillupByBlankRadio.setLayoutData((Object)fillUpByBlankGridData);
        this.fillupFromSourceLanguageCheckbox = new Button((Composite)fillUpGroup, 16);
        this.fillupFromSourceLanguageCheckbox.setText(Messages.GenerateSettingsWizardPage_from_source_language_if_exist);
        this.fillupFromSourceLanguageCheckbox.setSelection(this.getGenerator().getFillUpType() == FillUpType.FROM_SOURCE_LANGUAGE);
        this.fillupFromSourceLanguageCheckbox.addSelectionListener(this.listener);
        GridData fillUpfromSourceGridData = new GridData();
        fillUpfromSourceGridData.horizontalSpan = 2;
        this.fillupFromSourceLanguageCheckbox.setLayoutData((Object)fillUpfromSourceGridData);
        this.fillupFromExternalProviderCheckbox = new Button((Composite)fillUpGroup, 16);
        this.fillupFromExternalProviderCheckbox.setText(Messages.GenerateSettingsWizardPage_translate_with);
        this.fillupFromExternalProviderCheckbox.setSelection(this.getGenerator().getFillUpType() == FillUpType.FROM_PROVIDER);
        this.fillupFromExternalProviderCheckbox.addSelectionListener(this.listener);
        this.externalProviderCombobox = new ComboViewer((Composite)fillUpGroup, 2056);
        this.externalProviderCombobox.setLabelProvider((IBaseLabelProvider)this.externalProviderLabelProvider);
        this.externalProviderCombobox.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Combo externalCombo = this.externalProviderCombobox.getCombo();
        GridData gridData = new GridData(768);
        externalCombo.setLayoutData((Object)gridData);
        externalCombo.setFont(font);
        Group checkTranslationsGroup = new Group((Composite)fillUpGroup, 0);
        checkTranslationsGroup.setLayout((Layout)new GridLayout(1, false));
        checkTranslationsGroup.setLayoutData((Object)new GridData(1040));
        checkTranslationsGroup.setText(Messages.GenerateSettingsWizardPage_Check_translations_in_storage);
        boolean editable = this.getGenerator().getFillUpType() != FillUpType.NOT_FILLUP;
        Button checkInAny = new Button((Composite)checkTranslationsGroup, 16);
        checkInAny.setText(Messages.GenerateSettingsWizardPage_any_avalabele);
        checkInAny.setSelection(this.getGenerator().isCheckTranslationsInAnyAvailableStorage());
        checkInAny.setEnabled(editable);
        Button checkInCurrent = new Button((Composite)checkTranslationsGroup, 16);
        checkInCurrent.setText(Messages.GenerateSettingsWizardPage_only_selected_to_store_to);
        checkInCurrent.setSelection(!this.getGenerator().isCheckTranslationsInAnyAvailableStorage());
        checkInCurrent.setEnabled(editable);
        SelectionListener radioSelectionadapter = SelectionListener.widgetSelectedAdapter(e -> this.getGenerator().setCheckTranslationsInAnyAvailableStorage(checkInAny.getSelection()));
        checkInAny.addSelectionListener(radioSelectionadapter);
        checkInCurrent.addSelectionListener(radioSelectionadapter);
        SelectionListener adapter = SelectionListener.widgetSelectedAdapter(e -> {
            boolean enabled = this.getGenerator().getFillUpType() != FillUpType.NOT_FILLUP;
            checkInAny.setEnabled(enabled);
            checkInCurrent.setEnabled(enabled);
            if (!enabled) {
                checkInCurrent.setSelection(true);
                checkInAny.setSelection(false);
            }
        });
        this.fillupByBlankRadio.addSelectionListener(adapter);
        this.fillupFromSourceLanguageCheckbox.addSelectionListener(adapter);
        this.fillupFromExternalProviderCheckbox.addSelectionListener(adapter);
        this.initFillUpFromExternalTranslationProvider();
    }

    protected void createStorageControl(Composite parent) {
        Font font = parent.getFont();
        Group storageGroup = new Group(parent, 0);
        storageGroup.setLayout((Layout)new GridLayout(1, false));
        storageGroup.setLayoutData((Object)new GridData(1296));
        storageGroup.setFont(font);
        storageGroup.setText(Messages.GenerateSettingsWizardPage_Store_translation_to);
        this.storageCombobox = new ComboViewer((Composite)storageGroup, 2056);
        this.storageCombobox.setLabelProvider((IBaseLabelProvider)this.storageLabelProvider);
        this.storageCombobox.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Combo combo = this.storageCombobox.getCombo();
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(font);
        this.storageCombobox.addSelectionChangedListener(event -> {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof StorageID) {
                this.getGenerator().setStorageId((StorageID)element);
            }
        });
    }

    protected void createCollectCheckbox(Composite parent) {
        if (!this.getGenerator().getTranslatingProject().getModelLanguages().isEmpty() || this.getGenerator().getTranslatingProject().getDefaultLanguage() != null) {
            Layout layout = parent.getLayout();
            if (layout instanceof GridLayout) {
                GridLayout parentGrid = (GridLayout)layout;
                parentGrid.verticalSpacing = 10;
            }
            Font font = parent.getFont();
            Group collectGroup = new Group(parent, 32);
            collectGroup.setText(Messages.GenerateSettingsWizardPage_Collect);
            collectGroup.setLayout((Layout)new GridLayout(1, false));
            collectGroup.setLayoutData((Object)new GridData(1296));
            collectGroup.setFont(font);
            this.collectInterfaceStringsCheckbox = new Button((Composite)collectGroup, 32);
            this.collectInterfaceStringsCheckbox.setText(Messages.GenerateSettingsWizardPage_Collect_Interface_strings);
            this.collectInterfaceStringsCheckbox.setSelection(this.getGenerator().isCollectInterfaceStrings());
            this.collectInterfaceStringsCheckbox.addSelectionListener(this.listener);
            this.collectModelStringsCheckbox = new Button((Composite)collectGroup, 32);
            this.collectModelStringsCheckbox.setText(Messages.GenerateSettingsWizardPage_Collect_Model_strings);
            this.collectModelStringsCheckbox.addSelectionListener(this.listener);
            Group collectModelTypeGroup = new Group(parent, 32);
            collectModelTypeGroup.setText(Messages.GenerateSettingsWizardPage_Collect_strings);
            collectModelTypeGroup.setLayout((Layout)new GridLayout(1, false));
            collectModelTypeGroup.setLayoutData((Object)new GridData(1296));
            collectModelTypeGroup.setFont(font);
            this.collectModelTypeAnyRadio = new Button((Composite)collectModelTypeGroup, 16);
            this.collectModelTypeAnyRadio.setText(Messages.GenerateSettingsWizardPage_Any);
            this.collectModelTypeAnyRadio.setSelection(this.getGenerator().getCollectModelType() == ICollectingParameters.CollectModelType.ANY);
            this.collectModelTypeAnyRadio.addSelectionListener(this.listener);
            this.collectModelTypeNoneRadio = new Button((Composite)collectModelTypeGroup, 16);
            this.collectModelTypeNoneRadio.setText(Messages.GenerateSettingsWizardPage_None);
            this.collectModelTypeNoneRadio.setSelection(this.getGenerator().getCollectModelType() == ICollectingParameters.CollectModelType.NONE);
            this.collectModelTypeNoneRadio.addSelectionListener(this.listener);
            this.collectModelTypeOnlyRadio = new Button((Composite)collectModelTypeGroup, 16);
            this.collectModelTypeOnlyRadio.setText(Messages.GenerateSettingsWizardPage_Only_computed);
            this.collectModelTypeOnlyRadio.setSelection(this.getGenerator().getCollectModelType() == ICollectingParameters.CollectModelType.COMPUTED_ONLY);
            this.collectModelTypeOnlyRadio.addSelectionListener(this.listener);
            this.collectUnknownMethodOnlyRadio = new Button((Composite)collectModelTypeGroup, 16);
            this.collectUnknownMethodOnlyRadio.setText(Messages.GenerateSettingsWizardPage_Only_unknowns);
            this.collectUnknownMethodOnlyRadio.setSelection(this.getGenerator().getCollectModelType() == ICollectingParameters.CollectModelType.UNKNOWN_ONLY);
            this.collectUnknownMethodOnlyRadio.addSelectionListener(this.listener);
            this.collectTagsOnlyRadio = new Button((Composite)collectModelTypeGroup, 16);
            this.collectTagsOnlyRadio.setText(Messages.GenerateSettingsWizardPage_Only_tags);
            this.collectTagsOnlyRadio.setSelection(this.getGenerator().getCollectModelType() == ICollectingParameters.CollectModelType.TAGS_ONLY);
            this.collectTagsOnlyRadio.addSelectionListener(this.listener);
            SelectionListener adapter = SelectionListener.widgetSelectedAdapter(e -> {
                boolean enabled = this.getGenerator().isCollectModelStrings();
                this.collectModelTypeAnyRadio.setEnabled(enabled);
                this.collectModelTypeNoneRadio.setEnabled(enabled);
                this.collectModelTypeOnlyRadio.setEnabled(enabled);
                this.collectUnknownMethodOnlyRadio.setEnabled(enabled);
                this.collectTagsOnlyRadio.setEnabled(enabled);
            });
            this.collectModelStringsCheckbox.addSelectionListener(adapter);
            this.collectModelStringsCheckbox.setSelection(this.getGenerator().isCollectModelStrings());
            adapter.widgetSelected(null);
        } else {
            this.getGenerator().setCollectInterfaceStrings(true);
            this.getGenerator().setCollectModelStrings(false);
        }
    }

    protected void createLanguageTable(Composite parent) {
        Font font = parent.getFont();
        Label languagesDescription = new Label(parent, 64);
        languagesDescription.setText(Messages.GenerateSettingsWizardPage_Generate_for_languages);
        languagesDescription.setLayoutData((Object)new GridData(768));
        languagesDescription.setFont(font);
        this.languagesViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        this.languagesViewer.setLabelProvider((IBaseLabelProvider)this.lableProvider);
        this.languagesViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            if (element instanceof TranslateLanguage) {
                TranslateLanguage langauge = (TranslateLanguage)element;
                if (checked) {
                    this.getGenerator().addLanguage(langauge);
                } else {
                    this.getGenerator().removeLanguage(langauge);
                }
            }
            this.setPageComplete(this.validatePage());
        });
        this.languagesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table storageTable = this.languagesViewer.getTable();
        storageTable.setLayoutData((Object)new GridData(1808));
        storageTable.setFont(font);
    }

    private void initFillUpFromExternalTranslationProvider() {
        ITranslationProviderRegistry registry = this.translationManager.getTranslationProviderRegistry();
        registry.getExternalTranslationProvidersIds().forEach(id -> {
            ExternalTranslationProviderAttrs attrs = registry.getExternalTranslationProviderAttrs(id);
            this.externalProviderCombobox.add((Object)attrs);
        });
        String providerId = this.getGenerator().getTranslationProviderId();
        if (StringUtils.isNotEmpty((String)providerId)) {
            ExternalTranslationProviderAttrs attrs = registry.getExternalTranslationProviderAttrs(providerId);
            if (attrs == null) {
                UiPlugin.log((IStatus)new Status(4, "com.e1c.langtool.ui", "Translation attributes for the given [id:" + providerId + "] have not been found."));
                this.externalProviderCombobox.setSelection((ISelection)new StructuredSelection());
            } else {
                this.externalProviderCombobox.setSelection((ISelection)new StructuredSelection((Object)attrs));
            }
        } else {
            this.externalProviderCombobox.setSelection((ISelection)new StructuredSelection());
        }
        if (!this.fillupFromExternalProviderCheckbox.getSelection()) {
            this.externalProviderCombobox.getCombo().setEnabled(false);
        }
        this.externalProviderCombobox.addSelectionChangedListener(event -> {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof ExternalTranslationProviderAttrs) {
                ExternalTranslationProviderAttrs attrs = (ExternalTranslationProviderAttrs)element;
                this.getGenerator().setTranslationProviderId(attrs.getId());
            }
            this.setPageComplete(this.validatePage());
        });
        this.fillupFromExternalProviderCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GenerateSettingsWizardPage.this.fillupFromSourceLanguageCheckbox.getSelection()) {
                    GenerateSettingsWizardPage.this.externalProviderCombobox.getCombo().setEnabled(false);
                } else {
                    GenerateSettingsWizardPage.this.externalProviderCombobox.getCombo().setEnabled(true);
                }
            }
        });
    }

    protected boolean validatePage() {
        return this.getGenerator().checkSettings();
    }

    protected void addLanguagesToTable() {
        ArrayList languages = Lists.newArrayList((Iterable)this.getGenerator().getTranslatingProject().getInterfaceLanguages());
        TranslateLanguage defaultLanguage = this.getGenerator().getTranslatingProject().getDefaultLanguage();
        if (defaultLanguage != null && !languages.contains(defaultLanguage)) {
            languages.add(defaultLanguage);
        }
        this.languagesViewer.setInput((Object)languages);
        for (TranslateLanguage language : languages) {
            this.languagesViewer.setChecked((Object)language, this.getGenerator().getLanguages().contains(language));
        }
    }

    private class ExternalProviderLableProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private ExternalProviderLableProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ExternalTranslationProviderAttrs) {
                ExternalTranslationProviderAttrs attrs = (ExternalTranslationProviderAttrs)element;
                return attrs.getName();
            }
            return null;
        }
    }

    private class LanguageLableProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private LanguageLableProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TranslateLanguage) {
                TranslateLanguage language = (TranslateLanguage)element;
                String name = language.getPresentation();
                if (StringUtils.isNullOrEmpty((String)name)) {
                    name = language.getName();
                }
                return name;
            }
            return null;
        }
    }

    private class StorageLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private StorageLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof StorageID) {
                StorageID id = (StorageID)element;
                return GenerateSettingsWizardPage.this.storageManager.getStorageProvider(id).getStorageDescription(GenerateSettingsWizardPage.this.getGenerator().getProject(), id.getSegment());
            }
            return null;
        }
    }
}

