/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.generatestring;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.generatestring.FillUpType;
import com.e1c.langtool.generatestring.ProjectGenerateTranslationStrings;
import com.e1c.langtool.generatestring.ProjectObjectsGenerateTranslationStrings;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.ui.generatestring.FilterSettingsPageSectionFactory;
import com.e1c.langtool.ui.generatestring.FilterSettingsWizardPage;
import com.e1c.langtool.ui.generatestring.GenerateSettingsWizardPage;
import com.e1c.langtool.ui.generatestring.Messages;
import com.e1c.langtool.ui.generatestring.PreviewStringsWizardPage;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GenerateTranslationStringsWizard
extends Wizard
implements IWizard {
    private static final String SETTINGS_COLLECT_MODEL_STRINGS = "collectModelStrings";
    private static final String SETTINGS_COLLECT_INTERFACE_STRINGS = "collectInterfaceStrings";
    private static final String SETTINGS_COLLECT_MODEL_TYPE = "collectModelType";
    private static final String SETTINGS_LANGUAGES = "languages";
    private static final String SETTINGS_STORAGE_ID = "storageId";
    private static final String SETTINGS_FILLUP_TYPE = "fillUpType";
    private static final String SETTINGS_TRANS_PROVIDER_ID = "translationProviderId";
    private static final String SETTINGS_TRANS_CHECK_ANY_AVAILABLE = "checkTranslationsInAnyAvailableStorage";
    @Inject
    private ITranslatingProjectManager projectManager;
    @Inject
    private IStorageSettingsManager settingsManager;
    @Inject
    private FilterSettingsPageSectionFactory pageSectionFactory;
    @Inject
    private Provider<PreviewStringsWizardPage> previewStringsPageProvider;
    @Inject
    private Provider<GenerateSettingsWizardPage> settingsPageProvider;
    @Inject
    private Provider<FilterSettingsWizardPage> filterSettingsPageProvider;
    private GenerateSettingsWizardPage settingsPage;
    private FilterSettingsWizardPage filterSettingsPage;
    private PreviewStringsWizardPage previewPage;
    protected TranslationStringsGenerator generator;

    public void addPages() {
        super.addPages();
        this.settingsPage = this.getSettingsPage();
        this.settingsPage.setGenerator(this.generator);
        this.addPage((IWizardPage)this.settingsPage);
        if (this.pageSectionFactory.hasSections(this.generator.getTranslatingProject())) {
            this.filterSettingsPage = this.getFilterSettingsPage();
            this.filterSettingsPage.setGenerator(this.generator);
            this.addPage((IWizardPage)this.filterSettingsPage);
        }
        this.previewPage = this.getPreviewStringsPage();
        this.previewPage.setGenerator(this.generator);
        this.addPage((IWizardPage)this.previewPage);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().equals((Object)this.settingsPage)) {
            return this.settingsPage.isPageComplete();
        }
        if (this.filterSettingsPage != null && this.getContainer().getCurrentPage().equals((Object)this.filterSettingsPage)) {
            return this.filterSettingsPage.isPageComplete();
        }
        if (this.getContainer().getCurrentPage().equals((Object)this.previewPage)) {
            return this.previewPage.isPageComplete();
        }
        return false;
    }

    public boolean performFinish() {
        if (!this.generator.checkSettings() && !this.showTranslationErrorDialog(this.generator.getErrors())) {
            return false;
        }
        if (this.filterSettingsPage != null && this.getContainer().getCurrentPage().equals((Object)this.filterSettingsPage)) {
            this.filterSettingsPage.updateFilterParameters();
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (GenerateTranslationStringsWizard.this.getContainer().getCurrentPage().equals((Object)GenerateTranslationStringsWizard.this.settingsPage)) {
                        GenerateTranslationStringsWizard.this.collectAndSaveTranslationStrings(monitor);
                    } else {
                        monitor.beginTask(Messages.GenerateTranslationStringsWizard_Saving_translations, GenerateTranslationStringsWizard.this.generator.getCollectedValues().size());
                        GenerateTranslationStringsWizard.this.generator.saveCollectedStrings((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)GenerateTranslationStringsWizard.this.generator.getCollectedValues().size()));
                    }
                    monitor.done();
                }
            });
            if (!this.generator.getErrors().isEmpty()) {
                this.showTranslationErrorDialog(this.generator.getErrors());
            }
        }
        catch (InvocationTargetException e) {
            UiPlugin.logError(e);
        }
        catch (InterruptedException e) {
            return false;
        }
        this.saveSettings();
        return true;
    }

    public void init(IProject project, Collection<TranslationSource> projectObjects) {
        Assert.isNotNull((Object)project, (String)"Project cannot be null");
        Assert.isNotNull(projectObjects, (String)"Project object collection cannot be null");
        this.setWindowTitle(Messages.GenerateTranslationStringsWizard_WindowTitle);
        this.createGenerator(projectObjects);
        this.generator.setTranslatingProject(this.projectManager.getProject(project));
        this.generator.setContinueAfterFirstError(true);
        if (this.generator.getTranslatingProject().isTranslating()) {
            this.generator.setLanguages((List)Lists.newArrayList((Iterable)this.generator.getTranslatingProject().getInterfaceLanguages()));
            this.setNeedsProgressMonitor(true);
        }
        this.generator.setStorageId(this.settingsManager.getSettingsOrDefault(project).getEdit().getStorageId());
        IDialogSettings settings = this.getDialogSettings().getSection(project.getName());
        if (settings != null) {
            this.generator.setCollectInterfaceStrings(settings.getBoolean(SETTINGS_COLLECT_INTERFACE_STRINGS));
            ICollectingParameters.CollectModelType type = ICollectingParameters.CollectModelType.forName((String)settings.get(SETTINGS_COLLECT_MODEL_TYPE));
            if (type == null) {
                type = ICollectingParameters.CollectModelType.NONE;
            }
            this.generator.setCollectModelType(type);
            ArrayList languageCodes = Lists.newArrayList((Object[])settings.getArray(SETTINGS_LANGUAGES));
            this.generator.setLanguages((List)Lists.newArrayList());
            for (TranslateLanguage language : this.generator.getTranslatingProject().getInterfaceLanguages()) {
                if (!languageCodes.contains(language.getLanguageCode())) continue;
                this.generator.addLanguage(language);
            }
            if (this.generator.getTranslatingProject().getDefaultLanguage() != null && languageCodes.contains(this.generator.getTranslatingProject().getDefaultLanguage().getLanguageCode())) {
                this.generator.addLanguage(this.generator.getTranslatingProject().getDefaultLanguage());
            }
            this.generator.setCollectModelStrings(settings.getBoolean(SETTINGS_COLLECT_MODEL_STRINGS));
            StorageID storageId = StorageID.create((String)settings.get(SETTINGS_STORAGE_ID));
            this.generator.setStorageId(storageId);
            this.generator.setFillUpType(FillUpType.fromString((String)settings.get(SETTINGS_FILLUP_TYPE)));
            this.generator.setTranslationProviderId(settings.get(SETTINGS_TRANS_PROVIDER_ID));
            this.generator.setCheckTranslationsInAnyAvailableStorage(settings.getBoolean(SETTINGS_TRANS_CHECK_ANY_AVAILABLE));
        }
    }

    public void dispose() {
        if (this.generator != null) {
            this.generator.dispose();
        }
        super.dispose();
    }

    public IDialogSettings getDialogSettings() {
        return DialogSettings.getOrCreateSection((IDialogSettings)UiPlugin.getDefault().getDialogSettings(), (String)GenerateTranslationStringsWizard.class.getName());
    }

    protected void createGenerator(Collection<TranslationSource> projectObjects) {
        if (projectObjects.isEmpty()) {
            this.generator = (TranslationStringsGenerator)UiPlugin.getDefault().getInjector().getInstance(ProjectGenerateTranslationStrings.class);
        } else {
            this.generator = (TranslationStringsGenerator)UiPlugin.getDefault().getInjector().getInstance(ProjectObjectsGenerateTranslationStrings.class);
            ((ProjectObjectsGenerateTranslationStrings)this.generator).setProjectObjects(projectObjects);
        }
    }

    protected PreviewStringsWizardPage getPreviewStringsPage() {
        return (PreviewStringsWizardPage)((Object)this.previewStringsPageProvider.get());
    }

    protected GenerateSettingsWizardPage getSettingsPage() {
        return (GenerateSettingsWizardPage)((Object)this.settingsPageProvider.get());
    }

    protected FilterSettingsWizardPage getFilterSettingsPage() {
        return (FilterSettingsWizardPage)((Object)this.filterSettingsPageProvider.get());
    }

    protected void collectAndSaveTranslationStrings(IProgressMonitor monitor) {
        this.generator.collectAndSaveStrings(monitor);
    }

    private void saveSettings() {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)this.getDialogSettings(), (String)this.generator.getProject().getName());
        settings.put(SETTINGS_COLLECT_MODEL_STRINGS, this.generator.isCollectModelStrings());
        settings.put(SETTINGS_COLLECT_INTERFACE_STRINGS, this.generator.isCollectInterfaceStrings());
        settings.put(SETTINGS_COLLECT_MODEL_TYPE, this.generator.getCollectModelType().toString());
        String[] languageArray = new String[this.generator.getLanguages().size()];
        int i = 0;
        while (i < languageArray.length) {
            TranslateLanguage language = (TranslateLanguage)this.generator.getLanguages().get(i);
            languageArray[i] = language.getLanguageCode();
            ++i;
        }
        settings.put(SETTINGS_LANGUAGES, languageArray);
        settings.put(SETTINGS_STORAGE_ID, this.generator.getStorageId().toString());
        settings.put(SETTINGS_FILLUP_TYPE, this.generator.getFillUpType().toString());
        settings.put(SETTINGS_TRANS_PROVIDER_ID, this.generator.getTranslationProviderId());
    }

    private boolean showTranslationErrorDialog(Collection<Exception> errors) {
        if (errors.isEmpty()) {
            return true;
        }
        Exception exc = errors.iterator().next();
        errors.size();
        FutureTask<Integer> futureTask = new FutureTask<Integer>(() -> new SkipErrorDialog(this.getShell(), Messages.GenerateTranslationStringsWizard_ErrorDialogTitle, Messages.GenerateTranslationStringsWizard_ErrorDialogMsgWhileTranslating, (IStatus)new Status(4, "com.e1c.langtool.ui", exc.getMessage(), (Throwable)exc), 4).open());
        Display.getDefault().syncExec(futureTask);
        try {
            return futureTask.get() == 47;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class SkipErrorDialog
    extends ErrorDialog {
        public static final int SKIP_ID = 47;

        public SkipErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.createButton(parent, 47, Messages.GenerateTranslationStringsWizard_ErrorDialogSkipButton, false);
        }

        protected void buttonPressed(int id) {
            super.buttonPressed(id);
            if (id == 47) {
                this.setReturnCode(47);
                this.close();
            }
        }
    }
}

