/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.storage;

import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.ui.storage.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;

public class FeatureValueEditorValidator
implements IInputValidator {
    private final ValidatorRegistry registry;
    private final FeatureValueValidator.ValidationContext validationContext;

    public FeatureValueEditorValidator(ValidatorRegistry registry, FeatureValueValidator.ValidationContext validationContext) {
        this.registry = registry;
        this.validationContext = validationContext;
    }

    public String isValid(String newValue) {
        FeatureValueValidator validator = this.registry.getValidator(this.validationContext.getTranslationKey().getFeatureSettings());
        IStatus status = validator.isValid(newValue, this.validationContext);
        if (!status.isOK()) {
            if (!status.isMultiStatus()) {
                return status.getMessage();
            }
            if (status.isMultiStatus() && status.getChildren().length == 1) {
                return status.getChildren()[0].getMessage();
            }
            StringBuilder errors = new StringBuilder(Messages.FeatureValueEditorValidator_Multiple_errors);
            int i = 0;
            while (i < status.getChildren().length) {
                IStatus child = status.getChildren()[i];
                errors.append("\n -").append(child.getMessage());
                ++i;
            }
            return errors.toString();
        }
        return null;
    }
}

