/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.storage;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.EditSettings;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.e1c.langtool.ui.storage.FeatureValueEditorValidator;
import com.e1c.langtool.ui.storage.Messages;
import com.e1c.langtool.ui.storage.StorageEntryComposite;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MultiStorageEditorDialog
extends TitleAreaDialog {
    private final IStorageSettingsManager storageSettingsManager;
    private final ValidatorRegistry registry;
    private final ITranslationStorageManager sorageManager;
    private final IEditingContext editingContext;
    private final TranslateLanguage language;
    private final ContextTranslationKey contextKey;
    private final Supplier<StorageID> currentStorageId;
    private final Map<StorageSettings, StorageEntryComposite> entries = new HashMap<StorageSettings, StorageEntryComposite>();
    private String errorMessage;

    public static MultiStorageEditorDialog create(Shell parentShell, IEditingContext editingContext, ContextTranslationKey contextKey, TranslateLanguage language, Supplier<StorageID> storageId) {
        IStorageSettingsManager storageSettingsManager = (IStorageSettingsManager)UiPlugin.getDefault().getInjector().getInstance(IStorageSettingsManager.class);
        ValidatorRegistry registry = (ValidatorRegistry)UiPlugin.getDefault().getInjector().getInstance(ValidatorRegistry.class);
        ITranslationStorageManager sorageManager = (ITranslationStorageManager)UiPlugin.getDefault().getInjector().getInstance(ITranslationStorageManager.class);
        MultiStorageEditorDialog editorDialog = new MultiStorageEditorDialog(parentShell, editingContext, contextKey, language, storageId, storageSettingsManager, registry, sorageManager);
        return editorDialog;
    }

    protected MultiStorageEditorDialog(Shell parentShell, IEditingContext editingContext, ContextTranslationKey contextKey, TranslateLanguage language, Supplier<StorageID> storageId, IStorageSettingsManager storageSettingsManager, ValidatorRegistry registry, ITranslationStorageManager sorageManager) {
        super(parentShell);
        this.editingContext = editingContext;
        this.contextKey = contextKey;
        this.language = language;
        this.currentStorageId = storageId;
        this.storageSettingsManager = storageSettingsManager;
        this.registry = registry;
        this.sorageManager = sorageManager;
        this.setShellStyle(0xC70 | MultiStorageEditorDialog.getDefaultOrientation());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.MultiStorageEditorDialog_Edit_translation);
        String description = MessageFormat.format(Messages.MultiStorageEditorDialog_Edit_translation_into__0__Context_ID_1_2, this.language.getName(), this.contextKey.getResourceId(), this.contextKey.getFeatureKey());
        this.setMessage(description);
        ScrolledComposite scrolled = new ScrolledComposite(composite, 512);
        GridLayoutFactory.fillDefaults().applyTo((Composite)scrolled);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolled);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite top = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 4;
        layout.marginTop = 4;
        layout.marginLeft = 4;
        layout.marginRight = 4;
        top.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)top);
        scrolled.setContent((Control)top);
        ProjectStorageSettings projectSettings = this.storageSettingsManager.getSettingsOrDefault(this.editingContext.getProject());
        List storages = projectSettings.getReadStorageSettings();
        EditSettings edit = projectSettings.getEdit();
        scrolled.setRedraw(false);
        this.createStorageEntry(top, (StorageSettings)edit);
        for (StorageSettings settings : storages) {
            if (!StorageSettingsUtils.canStoreFeature((StorageSettings)settings, (FeatureSettings)this.contextKey.getFeatureSettings())) continue;
            this.createStorageEntry(top, settings);
        }
        scrolled.setMinHeight(200);
        top.layout();
        scrolled.setMinSize(top.computeSize(-1, -1));
        scrolled.setRedraw(true);
        this.getShell().getDisplay().asyncExec(() -> this.entries.forEach((k, v) -> v.refresh()));
        this.setErrorMessage(this.errorMessage);
        MultiStorageEditorDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createStorageEntry(Composite parent, final StorageSettings settings) {
        FeatureValueEditorValidator validator = new FeatureValueEditorValidator(this.registry, new FeatureValueValidator.ValidationContext(){

            public IProject getProject() {
                return MultiStorageEditorDialog.this.contextKey.getSourceProject();
            }

            public TranslationKey getTranslationKey() {
                return MultiStorageEditorDialog.this.contextKey;
            }

            public TranslateLanguage getLanguage() {
                return MultiStorageEditorDialog.this.language;
            }

            public ITranslationStorageProvider.Storage getStorage() {
                return MultiStorageEditorDialog.this.sorageManager.getStorage(MultiStorageEditorDialog.this.contextKey.getSourceProject(), settings.getStorageId());
            }
        });
        StorageEntryComposite editEntry = new StorageEntryComposite(parent, this.editingContext, settings, this.contextKey, this.language, validator);
        this.entries.put(settings, editEntry);
        if (this.currentStorageId.get() != null && this.currentStorageId.get().equals((Object)settings.getStorageId())) {
            editEntry.setFocus();
        }
    }

    protected void okPressed() {
        for (Map.Entry<StorageSettings, StorageEntryComposite> entry : this.entries.entrySet()) {
            try {
                if (!entry.getValue().isDirty()) continue;
                this.editingContext.setTranslation(entry.getKey().getStorageId(), (TranslationKey)this.contextKey, this.language, entry.getValue().getTextValue());
            }
            catch (Exception e) {
                UiPlugin.logError(e);
            }
        }
        super.okPressed();
    }
}

