/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.md.sync;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.common.Pair;
import com._1c.g5.v8.dt.mcore.DerivedField;
import com._1c.g5.v8.dt.mcore.Field;
import com._1c.g5.v8.dt.mcore.StandardTabularPart;
import com._1c.g5.v8.dt.mcore.StyleAppearanceItem;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.metadata.common.CommonPackage;
import com._1c.g5.v8.dt.metadata.mdclass.InformationRegister;
import com._1c.g5.v8.dt.metadata.mdclass.InformationRegisterDimension;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.PaletteColor;
import com._1c.g5.v8.dt.metadata.mdclass.PredefinedItem;
import com._1c.g5.v8.dt.metadata.mdclass.StandardCommand;
import com._1c.g5.v8.dt.metadata.mdclass.StyleItem;
import com._1c.g5.v8.dt.metadata.mdclass.Subsystem;
import com._1c.g5.v8.dt.metadata.mdtype.EmptyRef;
import com.e1c.langtool.v8.dt.md.MdTranslateUtil;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameServiceDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.base.Splitter;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public final class MdSymbolicNameServiceDelegate
implements ITranslatedSymbolicNameServiceDelegate {
    private static final Splitter symbolicNameSplitter = Splitter.on((char)'.');

    public String generateCommonSymbolicName(EObject targetObject, EObject contextObject, IProjectTranslationProvider translationProvider) {
        if (targetObject instanceof IBmObject) {
            return this.generateCommonSymbolicName((IBmObject)targetObject, translationProvider);
        }
        return null;
    }

    public String convertUriToCommonSymbolicName(URI targetUri) {
        if (!BmUriUtil.isBmUri((URI)targetUri)) {
            return null;
        }
        String topObjectFqn = BmUriUtil.extractTopObjectFqn((URI)targetUri);
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        if (BmUriUtil.isTopObjectFragment((String)path)) {
            return topObjectFqn;
        }
        String result = this.generateCommonSymbolicNameTryStyleAppearanceItem(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryTopMdObjectProducedTypeOrEmptyRef(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryAddressingAttribute(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryAttribute(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryChartOfAccountsAccountingFlag(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryCommand(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryEnumValue(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryForm(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryTemplate(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryOperation(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryRecalculation(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryDimension(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryResource(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryStandardAttribute(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryStandardCommand(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryStandardTabularPart(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryTabularSectionOrNestedObject(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryMethod(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryPredefinedItem(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryLanguage(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryField(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryTableField(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryFunction(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        result = this.generateCommonSymbolicNameTryIntegrationServiceChannel(topObjectFqn, path);
        if (result != null) {
            return result;
        }
        return null;
    }

    public String generateContextSpecificSymbolicName(EObject targetObject, EObject contextObject, EReference contextFeature, IProjectTranslationProvider translationProvider) {
        if (contextFeature == MdClassPackage.Literals.CONFIGURATION__DEFAULT_LANGUAGE) {
            return this.generateConfigurationDefaultLanguageSymbolicName((Language)targetObject, translationProvider);
        }
        if (contextFeature == CommonPackage.Literals.CHOICE_PARAMETER_LINK__FIELD || contextFeature == CommonPackage.Literals.TYPE_LINK__FIELD || contextFeature == MdClassPackage.Literals.BASIC_DB_OBJECT__INPUT_BY_STRING || contextFeature == MdClassPackage.Literals.BASIC_DB_OBJECT__DATA_LOCK_FIELDS || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__KEY_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__TYPES_FILTER_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__MULTIPLE_VALUES_USE_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__OBJECT_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__TYPE_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__VALUE_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__MULTIPLE_VALUES_KEY_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__MULTIPLE_VALUES_ORDER_FIELD || contextFeature == MdClassPackage.Literals.TABLE__KEY_FIELDS || contextFeature == MdClassPackage.Literals.TABLE__INPUT_BY_STRING || contextFeature == MdClassPackage.Literals.TABLE__DATA_LOCK_FIELDS) {
            return this.generateFieldSymbolicName((Field)targetObject, translationProvider);
        }
        if (contextFeature == MdClassPackage.Literals.SUBSYSTEM__SUBSYSTEMS) {
            return this.generateSubordinateSubsystemSymbolicName((Subsystem)targetObject, translationProvider);
        }
        return null;
    }

    public String convertUriToContextSpecificSymbolicName(URI targetUri, EObject contextObject, EReference contextFeature) {
        if (contextFeature == MdClassPackage.Literals.CONFIGURATION__DEFAULT_LANGUAGE) {
            return this.generateConfigurationDefaultLanguageSymbolicName(targetUri);
        }
        if (contextFeature == CommonPackage.Literals.CHOICE_PARAMETER_LINK__FIELD || contextFeature == CommonPackage.Literals.TYPE_LINK__FIELD || contextFeature == MdClassPackage.Literals.BASIC_DB_OBJECT__INPUT_BY_STRING || contextFeature == MdClassPackage.Literals.BASIC_DB_OBJECT__DATA_LOCK_FIELDS || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__KEY_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__TYPES_FILTER_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__MULTIPLE_VALUES_USE_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__OBJECT_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__TYPE_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__VALUE_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__MULTIPLE_VALUES_KEY_FIELD || contextFeature == MdClassPackage.Literals.CHARACTERISTICS_DESCRIPTION__MULTIPLE_VALUES_ORDER_FIELD || contextFeature == MdClassPackage.Literals.TABLE__INPUT_BY_STRING || contextFeature == MdClassPackage.Literals.TABLE__DATA_LOCK_FIELDS) {
            return this.generateFieldSymbolicName(targetUri);
        }
        if (contextFeature == MdClassPackage.Literals.SUBSYSTEM__SUBSYSTEMS) {
            return this.generateSubordinateSubsystemSymbolicName(targetUri);
        }
        return null;
    }

    private String generateCommonSymbolicNameTryMethod(String topObjectFqn, String path) {
        if (!path.startsWith("/urlTemplates:")) {
            return null;
        }
        int urlTemplateNameStartIndex = "/urlTemplates:".length();
        int urlTemplateNameEndIndex = path.indexOf(47, urlTemplateNameStartIndex);
        if (urlTemplateNameEndIndex == -1) {
            return null;
        }
        String subpath = path.substring(urlTemplateNameEndIndex);
        if (!subpath.startsWith("/methods:")) {
            return null;
        }
        String urlTemplateName = BmUriUtil.decodeCollectionItemId((String)path.substring(urlTemplateNameStartIndex, urlTemplateNameEndIndex));
        String methodName = BmUriUtil.decodeCollectionItemId((String)subpath.substring("/methods:".length()));
        return topObjectFqn + ".URLTemplate." + urlTemplateName + ".Method." + methodName;
    }

    private String generateCommonSymbolicNameTryAddressingAttribute(String topObjectFqn, String path) {
        if (path.startsWith("/addressingAttributes:")) {
            return topObjectFqn + ".AddressingAttribute." + BmUriUtil.decodeCollectionItemId((String)path.substring("/addressingAttributes:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryAttribute(String topObjectFqn, String path) {
        if (path.startsWith("/attributes:")) {
            return topObjectFqn + ".Attribute." + BmUriUtil.decodeCollectionItemId((String)path.substring("/attributes:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryChartOfAccountsAccountingFlag(String topObjectFqn, String path) {
        if (path.startsWith("/extDimensionAccountingFlags:")) {
            return topObjectFqn + ".ExtDimensionAccountingFlag." + BmUriUtil.decodeCollectionItemId((String)path.substring("/extDimensionAccountingFlags:".length()));
        }
        if (path.startsWith("/accountingFlags:")) {
            return topObjectFqn + ".AccountingFlag." + BmUriUtil.decodeCollectionItemId((String)path.substring("/accountingFlags:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryCommand(String topObjectFqn, String path) {
        if (path.startsWith("/commands:")) {
            return topObjectFqn + ".Command." + BmUriUtil.decodeCollectionItemId((String)path.substring("/commands:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryEnumValue(String topObjectFqn, String path) {
        if (path.startsWith("/enumValues:")) {
            return topObjectFqn + ".EnumValue." + BmUriUtil.decodeCollectionItemId((String)path.substring("/enumValues:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryForm(String topObjectFqn, String path) {
        if (path.startsWith("/forms:")) {
            return topObjectFqn + ".Form." + BmUriUtil.decodeCollectionItemId((String)path.substring("/forms:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryTemplate(String topObjectFqn, String path) {
        if (path.startsWith("/templates:")) {
            return topObjectFqn + ".Template." + BmUriUtil.decodeCollectionItemId((String)path.substring("/templates:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryOperation(String topObjectFqn, String path) {
        if (path.startsWith("/operations:")) {
            return topObjectFqn + ".Operation." + BmUriUtil.decodeCollectionItemId((String)path.substring("/operations:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryRecalculation(String topObjectFqn, String path) {
        if (path.startsWith("/recalculations:")) {
            return topObjectFqn + ".Recalculation." + BmUriUtil.decodeCollectionItemId((String)path.substring("/recalculations:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryDimension(String topObjectFqn, String path) {
        if (path.startsWith("/dimensions:")) {
            return topObjectFqn + ".Dimension." + BmUriUtil.decodeCollectionItemId((String)path.substring("/dimensions:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryResource(String topObjectFqn, String path) {
        if (path.startsWith("/resources:")) {
            return topObjectFqn + ".Resource." + BmUriUtil.decodeCollectionItemId((String)path.substring("/resources:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryStandardAttribute(String topObjectFqn, String path) {
        if (path.startsWith("/standardAttributes:")) {
            return topObjectFqn + ".StandardAttribute." + BmUriUtil.decodeCollectionItemId((String)path.substring("/standardAttributes:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryStandardCommand(String topObjectFqn, String path) {
        if (path.startsWith("/standardCommands:")) {
            return topObjectFqn + ".StandardCommand." + BmUriUtil.decodeCollectionItemId((String)path.substring("/standardCommands:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryStandardTabularPart(String topObjectFqn, String path) {
        if (path.startsWith("/tabularParts:")) {
            return topObjectFqn + ".StandardTabularSection." + BmUriUtil.decodeCollectionItemId((String)path.substring("/tabularParts:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryField(String topObjectFqn, String path) {
        if (path.startsWith("/fields:")) {
            return topObjectFqn + ".Field." + BmUriUtil.decodeCollectionItemId((String)path.substring("/fields:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryTableField(String topObjectFqn, String path) {
        if (path.startsWith("/tableFields:")) {
            return topObjectFqn + ".Field." + BmUriUtil.decodeCollectionItemId((String)path.substring("/tableFields:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryFunction(String topObjectFqn, String path) {
        if (path.startsWith("/functions:")) {
            return topObjectFqn + ".Function." + BmUriUtil.decodeCollectionItemId((String)path.substring("/functions:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryTabularSectionOrNestedObject(String topObjectFqn, String path) {
        if (path.startsWith("/tabularSections:")) {
            int tabularSectionNameStartIndex = "/tabularSections:".length();
            int tabularSectionNameEndIndex = path.indexOf(47, tabularSectionNameStartIndex);
            if (tabularSectionNameEndIndex == -1) {
                return topObjectFqn + ".TabularSection." + BmUriUtil.decodeCollectionItemId((String)path.substring(tabularSectionNameStartIndex));
            }
            String subpath = path.substring(tabularSectionNameEndIndex);
            if (subpath.startsWith("/attributes:")) {
                String tabularSectionName = BmUriUtil.decodeCollectionItemId((String)path.substring(tabularSectionNameStartIndex, tabularSectionNameEndIndex));
                String attributeName = BmUriUtil.decodeCollectionItemId((String)subpath.substring("/attributes:".length()));
                return topObjectFqn + ".TabularSection." + tabularSectionName + ".Attribute." + attributeName;
            }
            if (subpath.equals("/producedTypes/objectType/type")) {
                int topObjectFqnDelimiterIndex = topObjectFqn.indexOf(46);
                String topObjectType = topObjectFqn.substring(0, topObjectFqnDelimiterIndex);
                String topObjectName = topObjectFqn.substring(topObjectFqnDelimiterIndex + 1);
                String tabularSectionName = BmUriUtil.decodeCollectionItemId((String)path.substring(tabularSectionNameStartIndex, tabularSectionNameEndIndex));
                return topObjectType + "TabularSection." + topObjectName + "." + tabularSectionName;
            }
            if (subpath.equals("/producedTypes/rowType/type")) {
                int topObjectFqnDelimiterIndex = topObjectFqn.indexOf(46);
                String topObjectType = topObjectFqn.substring(0, topObjectFqnDelimiterIndex);
                String topObjectName = topObjectFqn.substring(topObjectFqnDelimiterIndex + 1);
                String tabularSectionName = BmUriUtil.decodeCollectionItemId((String)path.substring(tabularSectionNameStartIndex, tabularSectionNameEndIndex));
                return topObjectType + "TabularSectionRow." + topObjectName + "." + tabularSectionName;
            }
        }
        return null;
    }

    private String generateCommonSymbolicNameTryPredefinedItem(String topObjectFqn, String path) {
        if (!path.startsWith("/predefined")) {
            return null;
        }
        String subpath = path.substring("/predefined".length());
        if (subpath.startsWith("/@findByNameInSubtree:")) {
            return topObjectFqn + "." + BmUriUtil.decodeCollectionItemId((String)subpath.substring("/@findByNameInSubtree:".length()));
        }
        if (subpath.startsWith("/items:")) {
            return topObjectFqn + "." + BmUriUtil.decodeCollectionItemId((String)subpath.substring("/items:".length()));
        }
        return null;
    }

    private String generateCommonSymbolicNameTryStyleAppearanceItem(String topObjectFqn, String path) {
        if (topObjectFqn.startsWith("StyleItem.") && path.equals("/appearanceItem")) {
            return "Style." + topObjectFqn.substring("StyleItem.".length());
        }
        if (topObjectFqn.startsWith("PaletteColor.") && path.equals("/appearanceItem")) {
            return "Palette." + topObjectFqn.substring("PaletteColor.".length());
        }
        return null;
    }

    private String generateCommonSymbolicNameTryTopMdObjectProducedTypeOrEmptyRef(String topObjectFqn, String path) {
        if (!path.startsWith("/producedTypes")) {
            return null;
        }
        int topObjectFqnDelimiterIndex = topObjectFqn.indexOf(46);
        String topObjectType = topObjectFqn.substring(0, topObjectFqnDelimiterIndex);
        String topObjectName = topObjectFqn.substring(topObjectFqnDelimiterIndex + 1);
        String subpath = path.substring("/producedTypes".length());
        if ("ExternalDataSource".equals(topObjectType)) {
            return this.generateCommonSymbolicNameTryExternalDataSourceProducedTypeOrEmptyRef(topObjectFqn, subpath);
        }
        switch (subpath) {
            case "/valueManagerType/type": {
                return topObjectType + "ValueManager." + topObjectName;
            }
            case "/recordType/type": {
                return topObjectType + "Record." + topObjectName;
            }
            case "/recordSetType/type": {
                return topObjectType + "RecordSet." + topObjectName;
            }
            case "/recordKeyType/type": {
                return topObjectType + "RecordKey." + topObjectName;
            }
            case "/recordManagerType/type": {
                return topObjectType + "RecordManager." + topObjectName;
            }
            case "/refType/type": {
                return topObjectType + "Ref." + topObjectName;
            }
            case "/objectType/type": {
                if (topObjectType.equals("ExternalDataProcessor") || topObjectType.equals("ExternalReport")) {
                    return topObjectFqn;
                }
                return topObjectType + "Object." + topObjectName;
            }
            case "/selectionType/type": {
                return topObjectType + "Selection." + topObjectName;
            }
            case "/listType/type": {
                return topObjectType + "List." + topObjectName;
            }
            case "/managerType/type": {
                return topObjectType + "Manager." + topObjectName;
            }
            case "/recalcsType/type": {
                return "RecalculationsManager." + topObjectName;
            }
            case "/displacingCalculationTypesType/type": {
                return "DisplacingCalculationTypes." + topObjectName;
            }
            case "/displacingCalculationTypesRowType/type": {
                return "DisplacingCalculationTypesRow." + topObjectName;
            }
            case "/baseCalculationTypesType/type": {
                return "BaseCalculationTypes." + topObjectName;
            }
            case "/baseCalculationTypesRowType/type": {
                return "BaseCalculationTypesRow." + topObjectName;
            }
            case "/leadingCalculationTypesType/type": {
                return "LeadingCalculationTypes." + topObjectName;
            }
            case "/leadingCalculationTypesRowType/type": {
                return "LeadingCalculationTypesRow." + topObjectName;
            }
            case "/containerType/typeSet": {
                if (topObjectType.equals("ChartOfCharacteristicTypes")) {
                    return "Characteristic." + topObjectName;
                }
                if (topObjectType.equals("DefinedType")) {
                    return topObjectFqn;
                }
                return null;
            }
            case "/routePointRef/type": {
                return topObjectType + "RoutePointRef." + topObjectName;
            }
            case "/extDimensionTypes/type": {
                return "ChartOfAccountsExtDimensionTypes." + topObjectName;
            }
            case "/extDimensionTypesRow/type": {
                return "ChartOfAccountsExtDimensionTypesRow." + topObjectName;
            }
            case "/refType/emptyRef": {
                return topObjectFqn + ".EmptyRef";
            }
        }
        return null;
    }

    private String generateCommonSymbolicNameTryExternalDataSourceProducedTypeOrEmptyRef(String topObjectFqn, String subpath) {
        List segments = symbolicNameSplitter.splitToList((CharSequence)topObjectFqn);
        boolean isExternalDataSourceType = segments.size() == 2;
        boolean isCubeType = segments.size() == 4 && "Cube".equals(segments.get(2));
        boolean isTableType = segments.size() == 4 && "Table".equals(segments.get(2));
        boolean isDimensionTableType = segments.size() == 6 && "Cube".equals(segments.get(2)) && "DimensionTable".equals(segments.get(4));
        String externalDataSourceName = isExternalDataSourceType ? (String)segments.get(1) : "";
        String externalTableName = isTableType ? (String)segments.get(1) + "." + (String)segments.get(3) : "";
        String externalCubeName = isCubeType ? (String)segments.get(1) + "." + (String)segments.get(3) : "";
        String externalDimensionTableName = isDimensionTableType ? (String)segments.get(1) + "." + (String)segments.get(3) + "." + (String)segments.get(5) : "";
        switch (subpath) {
            case "/managerType/type": {
                if (isTableType) {
                    return "ExternalDataSourceTableManager." + externalTableName;
                }
                if (isCubeType) {
                    return "ExternalDataSourceCubeManager." + externalCubeName;
                }
                if (isDimensionTableType) {
                    return "ExternalDataSourceCubeDimensionTableManager." + externalDimensionTableName;
                }
                if (isExternalDataSourceType) {
                    return "ExternalDataSourceManager." + externalDataSourceName;
                }
                return null;
            }
            case "/listType/type": {
                if (isTableType) {
                    return "ExternalDataSourceTableList." + externalTableName;
                }
                if (isCubeType) {
                    return "ExternalDataSourceCubeList." + externalCubeName;
                }
                if (isDimensionTableType) {
                    return "ExternalDataSourceCubeDimensionTableList." + externalDimensionTableName;
                }
                return null;
            }
            case "/objectType/type": {
                if (isTableType) {
                    return "ExternalDataSourceTableObject." + externalTableName;
                }
                if (isDimensionTableType) {
                    return "ExternalDataSourceCubeDimensionTableObject." + externalDimensionTableName;
                }
                return null;
            }
            case "/refType/type": {
                if (isTableType) {
                    return "ExternalDataSourceTableRef." + externalTableName;
                }
                if (isDimensionTableType) {
                    return "ExternalDataSourceCubeDimensionTableRef." + externalDimensionTableName;
                }
                return null;
            }
            case "/recordSetType/type": {
                if (isTableType) {
                    return "ExternalDataSourceTableRecordSet." + externalTableName;
                }
                if (isCubeType) {
                    return "ExternalDataSourceCubeRecordSet." + externalCubeName;
                }
                return null;
            }
            case "/recordType/type": {
                if (isTableType) {
                    return "ExternalDataSourceTableRecord." + externalTableName;
                }
                if (isCubeType) {
                    return "ExternalDataSourceCubeRecord." + externalCubeName;
                }
                return null;
            }
            case "/recordKeyType/type": {
                if (isTableType) {
                    return "ExternalDataSourceTableRecordKey." + externalTableName;
                }
                if (isCubeType) {
                    return "ExternalDataSourceCubeRecordKey." + externalCubeName;
                }
                return null;
            }
            case "/recordManagerType/type": {
                if (isTableType) {
                    return "ExternalDataSourceTableRecordManager." + externalTableName;
                }
                if (isCubeType) {
                    return "ExternalDataSourceCubeRecordManager." + externalCubeName;
                }
                return null;
            }
            case "/tablesManagerType/type": {
                if (isDimensionTableType) {
                    return "ExternalDataSourceTablesManager." + externalDataSourceName;
                }
                return null;
            }
            case "/cubesManagerType/type": {
                if (isDimensionTableType) {
                    return "ExternalDataSourceCubesManager." + externalDataSourceName;
                }
                return null;
            }
            case "/dimensionTablesManagerType/type": {
                if (isCubeType) {
                    return "ExternalDataSourceCubeDimensionsTablesManager." + externalCubeName;
                }
                return null;
            }
            case "/refType/emptyRef": {
                return topObjectFqn + ".EmptyRef";
            }
        }
        return null;
    }

    private String generateSubordinateSubsystemSymbolicName(Subsystem subsystem, IProjectTranslationProvider translationProvider) {
        return MdTranslateUtil.getMdObjectNameTranslation((MdObject)subsystem, translationProvider).orElse(subsystem.getName());
    }

    private String generateSubordinateSubsystemSymbolicName(URI targetUri) {
        String fqn = BmUriUtil.extractTopObjectFqn((URI)targetUri);
        return fqn.substring(fqn.lastIndexOf(46) + 1);
    }

    private String generateConfigurationDefaultLanguageSymbolicName(Language language, IProjectTranslationProvider translationProvider) {
        return "Language." + MdTranslateUtil.getMdObjectNameTranslation((MdObject)language, translationProvider).orElse(language.getName());
    }

    private String generateConfigurationDefaultLanguageSymbolicName(URI targetUri) {
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        return "Language." + BmUriUtil.decodeCollectionItemId((String)path.substring("/languages:".length()));
    }

    private String generateFieldSymbolicName(Field field, IProjectTranslationProvider translationProvider) {
        if (field instanceof DerivedField) {
            return MdTranslateUtil.getFullyQualifiedName((MdObject)((DerivedField)field).getSource(), translationProvider).toString();
        }
        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)field, MdObject.class);
        if (mdObject != null) {
            return MdTranslateUtil.getFullyQualifiedName(mdObject, translationProvider).append("StandardAttribute").append(field.getName()).toString();
        }
        return null;
    }

    private Pair<String, String> parseFieldId(String id) {
        int typeDiscriminatorSeparatorIndex = id.indexOf(58);
        Assert.isTrue((typeDiscriminatorSeparatorIndex > 0 ? 1 : 0) != 0);
        return Pair.newPair((Object)id.substring(0, typeDiscriminatorSeparatorIndex), (Object)id.substring(typeDiscriminatorSeparatorIndex + 1));
    }

    private String generateFieldSymbolicName(URI targetUri) {
        String topObjectName = BmUriUtil.extractTopObjectFqn((URI)targetUri);
        String path = BmUriUtil.extractContainmentPath((URI)targetUri);
        if (path.startsWith("/tabularSections:")) {
            int tabularSectionNameStart = "/tabularSections:".length();
            int tabularSectionNameEnd = path.indexOf(47, tabularSectionNameStart);
            String tabularSectionName = BmUriUtil.decodeCollectionItemId((String)path.substring(tabularSectionNameStart, tabularSectionNameEnd));
            Pair<String, String> fieldId = this.parseFieldId(BmUriUtil.decodeCollectionItemId((String)path.substring(tabularSectionNameEnd + "/fields:".length())));
            return topObjectName + ".TabularSection." + tabularSectionName + "." + (String)fieldId.first + "." + (String)fieldId.second;
        }
        if (path.startsWith("/tabularParts:")) {
            int tabularSectionNameStart = "/tabularParts:".length();
            int tabularSectionNameEnd = path.indexOf(47, tabularSectionNameStart);
            String tabularSectionName = BmUriUtil.decodeCollectionItemId((String)path.substring(tabularSectionNameStart, tabularSectionNameEnd));
            Pair<String, String> fieldId = this.parseFieldId(BmUriUtil.decodeCollectionItemId((String)path.substring(tabularSectionNameEnd + "/fields:".length())));
            return topObjectName + ".StandardTabularSection." + tabularSectionName + ".StandardAttribute." + (String)fieldId.second;
        }
        Pair<String, String> fieldId = this.parseFieldId(BmUriUtil.decodeCollectionItemId((String)path.substring("/fields:".length())));
        if (((String)fieldId.first).equals("Constant")) {
            return (String)fieldId.second;
        }
        if (((String)fieldId.first).equals("CommonAttribute")) {
            return "CommonAttribute." + (String)fieldId.second;
        }
        return topObjectName + "." + (String)fieldId.first + "." + (String)fieldId.second;
    }

    private String generateCommonSymbolicName(IBmObject targetObject, IProjectTranslationProvider translationProvider) {
        if (targetObject instanceof StyleAppearanceItem) {
            return this.generateStyleAppearanceItemCommonSymbolicName((StyleAppearanceItem)targetObject, translationProvider);
        }
        if (targetObject instanceof TypeItem) {
            return this.generateProducedTypeName((TypeItem)targetObject, translationProvider);
        }
        if (targetObject instanceof EmptyRef) {
            return this.generateEmptyRefCommonSymbolicName((EmptyRef)targetObject, translationProvider);
        }
        if (targetObject instanceof PredefinedItem) {
            return this.generatePredefinedCommonSymbolicItemName((PredefinedItem)targetObject, translationProvider);
        }
        if (targetObject instanceof StandardTabularPart) {
            return this.generateStandardTabularPartCommonSymbolicName((StandardTabularPart)targetObject, translationProvider);
        }
        if (targetObject instanceof StandardCommand) {
            return this.generateStandardCommandCommonSymbolicName((StandardCommand)targetObject, translationProvider);
        }
        if (targetObject instanceof MdObject) {
            return this.generateMdObjectCommonSymbolicName((MdObject)targetObject, translationProvider);
        }
        if (targetObject.bmIsTop()) {
            return targetObject.bmGetFqn();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String generateStyleAppearanceItemCommonSymbolicName(StyleAppearanceItem styleAppearanceItem, IProjectTranslationProvider translationProvider) {
        EObject container = styleAppearanceItem.eContainer();
        EObject eObject = container;
        if (eObject instanceof StyleItem) {
            void styleItem;
            StyleItem styleItem2 = (StyleItem)eObject;
            StyleItem cfr_ignored_0 = (StyleItem)eObject;
            return "Style." + MdTranslateUtil.getMdObjectNameTranslation((MdObject)styleItem, translationProvider).orElse(styleAppearanceItem.getName());
        }
        EObject eObject2 = container;
        if (eObject2 instanceof PaletteColor) {
            void paletteColor;
            PaletteColor paletteColor2 = (PaletteColor)eObject2;
            PaletteColor cfr_ignored_1 = (PaletteColor)eObject2;
            return "Palette." + MdTranslateUtil.getMdObjectNameTranslation((MdObject)paletteColor, translationProvider).orElse(styleAppearanceItem.getName());
        }
        return "Style." + styleAppearanceItem.getName();
    }

    private String generateProducedTypeName(TypeItem producedType, IProjectTranslationProvider translationProvider) {
        EObject parent = producedType.eContainer();
        MdObject container = null;
        CharSequence[] typeParts = producedType.getName().split("\\.");
        int lastPart = typeParts.length - 1;
        while ((container = (MdObject)EcoreUtil2.getContainerOfType((EObject)parent, MdObject.class)) != null) {
            if (lastPart >= 0 && ((String)typeParts[lastPart]).equalsIgnoreCase(container.getName())) {
                Optional<String> trans = MdTranslateUtil.getMdObjectNameTranslation(container, translationProvider);
                typeParts[lastPart] = trans.orElse(container.getName());
                --lastPart;
            }
            parent = container.eContainer();
        }
        return String.join((CharSequence)".", typeParts);
    }

    private String generateEmptyRefCommonSymbolicName(EmptyRef emptyRef, IProjectTranslationProvider translationProvider) {
        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)emptyRef, MdObject.class);
        if (mdObject == null) {
            return null;
        }
        QualifiedName mdObjectFqn = MdTranslateUtil.getFullyQualifiedName(mdObject, translationProvider);
        if (mdObjectFqn == null) {
            return null;
        }
        return mdObjectFqn.append("EmptyRef").toString();
    }

    private String generatePredefinedCommonSymbolicItemName(PredefinedItem predefinedItem, IProjectTranslationProvider translationProvider) {
        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)predefinedItem, MdObject.class);
        if (mdObject == null) {
            return null;
        }
        QualifiedName mdObjectFqn = MdTranslateUtil.getFullyQualifiedName(mdObject, translationProvider);
        if (mdObjectFqn == null) {
            return null;
        }
        Optional<String> trans = Optional.ofNullable(translationProvider.getTranslation((EObject)predefinedItem, MdFeatureSettings.Literals.PREDEFINED_ITEM__NAME, translationProvider.getProject().getDefaultLanguage()));
        return mdObjectFqn.append(trans.orElse(predefinedItem.getName())).toString();
    }

    private String generateStandardTabularPartCommonSymbolicName(StandardTabularPart standardTabularPart, IProjectTranslationProvider translationProvider) {
        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)standardTabularPart, MdObject.class);
        if (mdObject == null) {
            return null;
        }
        QualifiedName mdObjectFqn = MdTranslateUtil.getFullyQualifiedName(mdObject, translationProvider);
        if (mdObjectFqn == null) {
            return null;
        }
        return mdObjectFqn.append("StandardTabularSection").append(standardTabularPart.getName()).toString();
    }

    private String generateStandardCommandCommonSymbolicName(StandardCommand standardCommand, IProjectTranslationProvider translationProvider) {
        CharSequence[] segments;
        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)standardCommand, MdObject.class);
        if (mdObject == null) {
            return null;
        }
        QualifiedName mdObjectFqn = MdTranslateUtil.getFullyQualifiedName(mdObject, translationProvider);
        if (mdObjectFqn == null) {
            return null;
        }
        String commandName = standardCommand.getName();
        if (mdObject instanceof InformationRegister && (segments = commandName.split("\\.")).length == 2) {
            String dimName = segments[1];
            for (InformationRegisterDimension dimension : ((InformationRegister)mdObject).getDimensions()) {
                if (!dimension.getName().equals(dimName)) continue;
                segments[1] = MdTranslateUtil.getMdObjectNameTranslation((MdObject)dimension, translationProvider).orElse(dimName);
                commandName = String.join((CharSequence)".", segments);
                break;
            }
        }
        return mdObjectFqn.append("StandardCommand").append(commandName).toString();
    }

    private String generateMdObjectCommonSymbolicName(MdObject mdObject, IProjectTranslationProvider translationProvider) {
        QualifiedName mdObjectFqn = MdTranslateUtil.getFullyQualifiedName(mdObject, translationProvider);
        if (mdObjectFqn == null) {
            return null;
        }
        return mdObjectFqn.toString();
    }

    private String generateCommonSymbolicNameTryLanguage(String topObjectFqn, String path) {
        return "Language." + BmUriUtil.decodeCollectionItemId((String)path.substring("/languages:".length()));
    }

    private String generateCommonSymbolicNameTryIntegrationServiceChannel(String topObjectFqn, String path) {
        if (path.startsWith("/integrationServiceChannels:")) {
            int integrationServiceChannelNameStartIndex = "/integrationServiceChannels:".length();
            int integrationServiceChannelNameEndIndex = path.indexOf(47, integrationServiceChannelNameStartIndex);
            if (integrationServiceChannelNameEndIndex == -1) {
                return topObjectFqn + ".IntegrationServiceChannel." + BmUriUtil.decodeCollectionItemId((String)path.substring(integrationServiceChannelNameStartIndex));
            }
            String subpath = path.substring(integrationServiceChannelNameEndIndex);
            if (subpath.equals("/producedTypes/managerType/type")) {
                int topObjectFqnDelimiterIndex = topObjectFqn.indexOf(46);
                String topObjectType = topObjectFqn.substring(0, topObjectFqnDelimiterIndex);
                String topObjectName = topObjectFqn.substring(topObjectFqnDelimiterIndex + 1);
                String integrationServiceName = BmUriUtil.decodeCollectionItemId((String)path.substring(integrationServiceChannelNameStartIndex, integrationServiceChannelNameEndIndex));
                return topObjectType + "ChannelManager." + topObjectName + "." + integrationServiceName;
            }
        }
        return null;
    }
}

