/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.style;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.style.model.Style;
import com._1c.g5.v8.dt.style.model.StyleItem;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.internal.md.MdPlugin;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;

public class StyleFeatureCollector
implements FeatureValueCollector {
    @Inject
    private IFeatureSettingsService settingsService;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IComputedNameService computedNameService;
    @Inject
    private IFeatureValueCollectingService collectingService;
    private ICollectingParameters parameters;
    private CollectingContext context;
    private BiConsumer<Object, FeatureValue> addAction;
    private String defaultLanguageCode;
    private EObject object;
    private IProgressMonitor monitor;

    public static StyleFeatureCollector create(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        StyleFeatureCollector collector = new StyleFeatureCollector(object, parameters, addAction);
        MdPlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    protected StyleFeatureCollector(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        this.object = object;
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        this.addAction = addAction;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.doProcessInternal((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), this.object);
    }

    private void doProcessInternal(IProgressMonitor monitor, EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj instanceof Style) {
            this.doProcessInternal(monitor, (Style)obj);
        } else if (obj instanceof StyleItem) {
            this.doProcessInternal(monitor, (StyleItem)obj);
        }
    }

    private void doProcessInternal(IProgressMonitor monitor, Collection<? extends EObject> objects) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)objects.size());
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal((IProgressMonitor)subMonitor.newChild(1), eObject);
        }
        monitor.done();
    }

    private void doProcessInternal(IProgressMonitor monitor, Style obj) {
        int total = 1 + obj.getItems().size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
        this.doProcess(obj, Style.class, (IProgressMonitor)subMonitor.newChild(1));
        this.doProcessInternal((IProgressMonitor)subMonitor.newChild(obj.getItems().size()), (Collection<? extends EObject>)obj.getItems());
    }

    private void doProcessInternal(IProgressMonitor monitor, StyleItem obj) {
        this.doProcess(obj, StyleItem.class, monitor);
    }

    protected <T extends EObject> void doProcess(T object, Class<T> clazz, IProgressMonitor monitor) {
        if (object == null) {
            return;
        }
        if (object instanceof IBmObject && ((IBmObject)object).bmIsTop() && ((IBmObject)object).bmGetEngine() != null) {
            monitor.subTask(((IBmObject)object).bmGetFqn());
        }
        FeaturesCollectorUtil.collectFeatures(object, (CollectingContext)this.getContext(), (IProgressMonitor)monitor);
        monitor.done();
    }

    private CollectingContext getContext() {
        if (this.context == null) {
            this.context = new CollectingContext(this.parameters, this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, this.getDefaultLanguageCode(this.object), this.addAction);
        }
        return this.context;
    }

    private String getDefaultLanguageCode(EObject context) {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)context, (IV8ProjectManager)this.v8ProjectManager);
        }
        return this.defaultLanguageCode;
    }
}

