/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.sync;

import com._1c.g5.v8.dt.core.platform.IConfigurationAware;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.mcore.DerivedField;
import com._1c.g5.v8.dt.mcore.DuallyNamedElement;
import com._1c.g5.v8.dt.mcore.Field;
import com._1c.g5.v8.dt.mcore.FieldSource;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com._1c.g5.v8.dt.mcore.TypeDescription;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.util.McoreUtil;
import com._1c.g5.v8.dt.md.typeinfo.IMdTypeIndex;
import com._1c.g5.v8.dt.metadata.mdclass.BasicFeature;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Constant;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.metadata.mdclass.StandardAttribute;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.md.MdTranslateUtil;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public abstract class AbstractChoiceParameterFilterTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    protected static final String FILTER_PREFFIX_RU = "\u041e\u0442\u0431\u043e\u0440.";
    protected static final String FILTER_PREFFIX = "Filter.";
    protected static final String REF = "Ref";
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IMdTypeIndex mdTypeIndex;
    private ElementProvider elementProvider = new ElementProvider();
    private NameProvider nameProvider = new NameProvider();

    protected EObject getSourceObject(Field field) {
        if (field instanceof DerivedField) {
            return ((DerivedField)field).getSource();
        }
        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)field, MdObject.class);
        return mdObject != null ? field : null;
    }

    protected Field getFilterField(EObject object) {
        TypeDescription td = this.getTypeDescription(object);
        if (td == null || td.eIsProxy()) {
            return null;
        }
        IV8Project v8project = this.getV8Project(object);
        if (v8project == null) {
            return null;
        }
        String prefix = MdTranslateUtil.getFilterPreffix(v8project.getScriptVariant());
        String name = this.getFilterName(object);
        if (name == null || !name.startsWith(prefix)) {
            return null;
        }
        for (TypeItem typeItem : td.getTypes()) {
            Collection<TypeItem> accessibleTypeItems = this.getChoiceParameterTypesForAllowedNames(v8project, typeItem);
            for (TypeItem item : accessibleTypeItems) {
                MdObject typeContainer = (MdObject)EcoreUtil2.getContainerOfType((EObject)item, MdObject.class);
                Object[] elements = this.elementProvider.apply(typeContainer);
                if (elements == null) continue;
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    if (element instanceof Field) {
                        Field field = (Field)element;
                        if (field.eIsProxy()) {
                            field = (Field)EcoreUtil.resolve((EObject)field, (Resource)((IConfigurationAware)v8project).getConfiguration().eResource());
                        }
                        if (!field.isReadOnly() && name.equals(prefix + this.nameProvider.apply(v8project, field))) {
                            return field;
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    protected abstract String getFilterName(EObject var1);

    private IV8Project getV8Project(EObject object) {
        return this.v8ProjectManager.getProject(object);
    }

    protected TypeDescription getTypeDescription(EObject object) {
        EObject container = this.getObject(object);
        if (container instanceof BasicFeature) {
            return ((BasicFeature)container).getType();
        }
        if (container instanceof Constant) {
            return ((Constant)container).getType();
        }
        if (container instanceof StandardAttribute) {
            String name = ((StandardAttribute)container).getName();
            FieldSource source = (FieldSource)EcoreUtil2.getContainerOfType((EObject)container, FieldSource.class);
            if (source != null) {
                Optional<Field> field = source.getFields().stream().filter(f -> name.equals(f.getName())).findAny();
                return field.map(Field::getType).orElse(null);
            }
        }
        return null;
    }

    protected EObject getObject(EObject object) {
        return object.eContainer();
    }

    protected Collection<TypeItem> getChoiceParameterTypesForAllowedNames(IV8Project v8project, TypeItem item) {
        Configuration configuration;
        List result;
        if (item == null) {
            return Collections.emptyList();
        }
        String typeCategory = McoreUtil.getTypeCategory((TypeItem)item);
        String typeName = McoreUtil.getTypeName((TypeItem)item);
        if (typeCategory == null || typeName == null || !typeCategory.endsWith(REF)) {
            return Collections.emptyList();
        }
        HashSet<TypeItem> typeItems = new HashSet<TypeItem>();
        if (!typeCategory.equals(typeName)) {
            typeItems.add(item);
            return typeItems;
        }
        if (v8project instanceof IConfigurationAware && !(result = this.mdTypeIndex.getRefTypes((EObject)(configuration = ((IConfigurationAware)v8project).getConfiguration()), typeCategory)).isEmpty()) {
            typeItems.addAll(result);
        }
        return typeItems;
    }

    protected String computeTranslatedString(Field sourceField, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (sourceField == null) {
            return null;
        }
        boolean isRussian = translationProvider.getProject().getScriptVariant() == ScriptVariant.RUSSIAN;
        String prefix = MdTranslateUtil.getFilterPreffix(translationProvider.getProject().getScriptVariant());
        EObject source = this.getSourceObject(sourceField);
        if (source instanceof MdObject) {
            ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
            URI objectUri = EcoreUtil.getURI((EObject)source);
            Provider provider = () -> {
                String translation = null;
                if (translationProvider.getProject().isChangeDefaultLanguage()) {
                    translation = translationProvider.getTranslation(source, MdFeatureSettings.Literals.MD_OBJECT__NAME, language);
                }
                return Optional.ofNullable(translation).orElse(((MdObject)source).getName());
            };
            return prefix + cache.getTranslation(objectUri, provider);
        }
        if (source instanceof DuallyNamedElement) {
            return prefix + (isRussian ? ((DuallyNamedElement)source).getNameRu() : ((DuallyNamedElement)source).getName());
        }
        if (source instanceof NamedElement) {
            ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
            URI objectUri = EcoreUtil.getURI((EObject)source);
            Provider provider = () -> {
                String translation = null;
                if (translationProvider.getProject().isChangeDefaultLanguage()) {
                    translation = translationProvider.getTranslation(source, McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, language);
                }
                return Optional.ofNullable(translation).orElse(((NamedElement)source).getName());
            };
            return prefix + cache.getTranslation(objectUri, provider);
        }
        return null;
    }

    class ElementProvider
    implements Function<MdObject, Object[]> {
        ElementProvider() {
        }

        @Override
        public Object[] apply(MdObject inputElement) {
            if (inputElement instanceof FieldSource) {
                return ((FieldSource)inputElement).getFields().toArray();
            }
            return new Object[0];
        }
    }

    class NameProvider
    implements BiFunction<IV8Project, Field, String> {
        NameProvider() {
        }

        @Override
        public String apply(IV8Project project, Field field) {
            String englishName = field.getName();
            if (project.getScriptVariant() == ScriptVariant.ENGLISH) {
                return englishName;
            }
            String russianName = field.getNameRu();
            if (StringUtils.isNullOrEmpty((String)russianName)) {
                return englishName;
            }
            return russianName;
        }
    }
}

