/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.sync;

import com._1c.g5.v8.dt.metadata.dbview.DbViewFieldDef;
import com._1c.g5.v8.dt.metadata.dbview.Table;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com.e1c.g5.v8.dt.md.aindex.model.AdditionalIndex;
import com.e1c.g5.v8.dt.md.aindex.model.IndexField;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.internal.md.MdPlugin;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class IndexedFieldPathTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(MdFeatureSettings.Literals.INDEX_FIELD__PATH)) {
            return false;
        }
        Object value = object.eGet(stringFeature.getEFeature());
        if (!(value instanceof String)) {
            return false;
        }
        return !((String)value).isEmpty();
    }

    public boolean isSupported(EObject object) {
        return object instanceof IndexField;
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        IndexField indexField = (IndexField)object;
        AdditionalIndex additionalIndex = (AdditionalIndex)EcoreUtil2.getContainerOfType((EObject)indexField, AdditionalIndex.class);
        String path = indexField.getPath();
        Table table = additionalIndex.getTable();
        List<DbViewFieldDef> fields = table.getFields().stream().filter(field -> field.getName().contains(path)).toList();
        if (fields.isEmpty()) {
            MdPlugin.createWarningStatus(String.format("Cannot tranlate additional index field's %s path %s", indexField.getName(), path));
            return path;
        }
        DbViewFieldDef field2 = fields.get(0);
        EObject mdObject = field2.getMdObject();
        MdObject md = (MdObject)mdObject;
        Pair translation = this.namedEObjectNameProvider.getTranslatedName((EObject)md, translationProvider);
        if (translation != null && path.equals(translation.getKey())) {
            return (String)translation.getValue();
        }
        return path;
    }
}

