/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.translator;

import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProviderDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MdObjectNameProvider
implements INamedEObjectNameProviderDelegate {
    public Pair<String, String> getTranslatedName(EObject object, IProjectTranslationProvider translationProvider) {
        if (object instanceof MdObject) {
            String name = this.getName(object);
            if (name == null) {
                return null;
            }
            Provider provider = () -> {
                if (!translationProvider.getProject().isChangeDefaultLanguage()) {
                    return name;
                }
                TranslateLanguage language = translationProvider.getProject().getDefaultLanguage();
                Optional newName = translationProvider.getOptionalTranslation(object, MdFeatureSettings.Literals.MD_OBJECT__NAME, language);
                return newName.orElse(name);
            };
            URI objectUri = EcoreUtil.getURI((EObject)object);
            ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
            String translation = cache.getTranslation(objectUri, provider);
            return new Pair((Object)name, (Object)translation);
        }
        return null;
    }

    public String getName(EObject object) {
        if (object instanceof MdObject) {
            MdObject mdObject = (MdObject)object;
            return mdObject.getName();
        }
        return null;
    }

    public Collection<EClass> getSupportEClass() {
        return List.of(MdClassPackage.Literals.MD_OBJECT);
    }
}

