/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.settings.FeatureSettings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class TranslationUtils {
    private static final long SINGLE_THREAD_DEMANDS = 0x40000000L;
    private static final long CLEANUP_MAPDB_THREAD_SLEEP = 500L;

    private TranslationUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static TranslationSource getTranslationSource(Object object) {
        if (object == null) {
            return null;
        }
        TranslationSource translationSource = null;
        if (object instanceof TranslationSource) {
            translationSource = (TranslationSource)object;
        } else if (object instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)object;
            translationSource = (TranslationSource)a.getAdapter(TranslationSource.class);
        }
        if (translationSource == null) {
            translationSource = (TranslationSource)Platform.getAdapterManager().loadAdapter(object, TranslationSource.class.getName());
        }
        return translationSource;
    }

    public static boolean isModelLanguage(TranslateLanguage language) {
        return language != null && language.getOption().equals((Object)TranslationOption.MODEL_AND_INTERFACE);
    }

    public static boolean isValidFeatureForLanguage(FeatureSettings featureSettings, TranslateLanguage language) {
        return featureSettings.isInterface() || TranslationUtils.isModelLanguage(language);
    }

    public static boolean isValidValueForCollectModelType(boolean isComputed, boolean isUnknown, boolean isTag, ICollectingParameters.CollectModelType collectModelType) {
        boolean isValidTag;
        boolean isValidComputed = collectModelType == ICollectingParameters.CollectModelType.ANY || isComputed && collectModelType == ICollectingParameters.CollectModelType.COMPUTED_ONLY || !isComputed && collectModelType == ICollectingParameters.CollectModelType.NONE || !isComputed && collectModelType == ICollectingParameters.CollectModelType.TAGS_ONLY || !isComputed && collectModelType == ICollectingParameters.CollectModelType.UNKNOWN_ONLY;
        boolean isValidUnknown = collectModelType == ICollectingParameters.CollectModelType.ANY || isUnknown && collectModelType == ICollectingParameters.CollectModelType.UNKNOWN_ONLY || !isUnknown && collectModelType == ICollectingParameters.CollectModelType.NONE || !isUnknown && collectModelType == ICollectingParameters.CollectModelType.TAGS_ONLY || !isUnknown && collectModelType == ICollectingParameters.CollectModelType.COMPUTED_ONLY;
        boolean bl = isValidTag = collectModelType == ICollectingParameters.CollectModelType.ANY || isTag && collectModelType == ICollectingParameters.CollectModelType.TAGS_ONLY || !isTag && collectModelType == ICollectingParameters.CollectModelType.UNKNOWN_ONLY || !isTag && collectModelType == ICollectingParameters.CollectModelType.NONE || !isTag && collectModelType == ICollectingParameters.CollectModelType.COMPUTED_ONLY;
        return isValidComputed && isValidUnknown && isValidTag;
    }

    public static Set<String> getProjectInterfaceLanguageCodes(ITranslatingProject project) {
        return project.getInterfaceLanguages().stream().map(TranslateLanguage::getLanguageCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
    }

    public static int computePoolSize(boolean forced) {
        if (forced) {
            return Runtime.getRuntime().availableProcessors();
        }
        int cores = Math.min(8, Runtime.getRuntime().availableProcessors() - 1);
        long availableMemory = Runtime.getRuntime().maxMemory() - 0x40000000L;
        int permittedCores = Math.round((float)availableMemory / 1.0737418E9f);
        if (permittedCores == 0) {
            permittedCores = 1;
        }
        return Math.min(permittedCores, cores);
    }

    public static IFile getTranslationSourceFile(ContextTranslationKey contextKey) {
        return contextKey.getSourceProject().getFile(contextKey.getResourceId());
    }

    public static void startCleanUpMapDbFiles(File file) {
        Job job = Job.create((String)"Clean-up LT MapDB Memory-mapped files", monitor -> {
            TranslationUtils.cleanUpMabDbFiles(file);
            return Status.OK_STATUS;
        });
        job.setSystem(true);
        job.schedule();
    }

    public static void cleanUpMabDbFiles(File file) {
        int total = 10;
        Path path = file.toPath();
        Path pPath = path.resolveSibling(String.valueOf(path.getFileName()) + ".p");
        File pFile = pPath.toFile();
        int tries = 0;
        do {
            block8: {
                if (++tries > 1) {
                    try {
                        System.gc();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        CorePlugin.logError(e);
                    }
                }
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    if (tries != total) break block8;
                    CorePlugin.logError(e);
                }
            }
            try {
                Files.deleteIfExists(pPath);
            }
            catch (IOException e) {
                if (tries != total) continue;
                CorePlugin.logError(e);
            }
        } while (tries < total && (file.exists() || pFile.exists()));
    }
}

