/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.collector;

import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.platform.TranslateLanguage;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CollectingParameters
implements ICollectingParameters {
    private final boolean collectModel;
    private final boolean collectInterface;
    private final boolean collectSubResources;
    private final ICollectingParameters.CollectModelType collectModelType;
    private final Set<TranslateLanguage> languages;
    private final boolean collectEmptyValue;
    private final boolean collectChildObjects;
    private final boolean continueAfterFirstError;
    private final Collection<Exception> errors = Lists.newCopyOnWriteArrayList();
    private final Map<String, Object> filterParameters = Maps.newConcurrentMap();
    private final boolean useCache;
    private final boolean keepLanguagesMode;

    public static Builder builder() {
        return new Builder();
    }

    public CollectingParameters(boolean collectChildObjects, boolean collectModel, boolean collectInterface, boolean collectSubResources, ICollectingParameters.CollectModelType collectModelType, boolean collectEmptyValue, Set<TranslateLanguage> languages, boolean continueAfterFirstError, boolean useCache, boolean keepLanguagesMode) {
        this.collectChildObjects = collectChildObjects;
        this.collectModel = collectModel;
        this.collectInterface = collectInterface;
        this.collectSubResources = collectSubResources;
        this.collectModelType = collectModelType;
        this.collectEmptyValue = collectEmptyValue;
        this.languages = languages == null ? ImmutableSet.of() : languages;
        this.continueAfterFirstError = continueAfterFirstError;
        this.useCache = useCache;
        this.keepLanguagesMode = keepLanguagesMode;
    }

    @Override
    public boolean isCollectChildObjects() {
        return this.collectChildObjects;
    }

    @Override
    public boolean isCollectModelStrings() {
        return this.collectModel;
    }

    @Override
    public boolean isCollectInterfaceStrings() {
        return this.collectInterface;
    }

    @Override
    public ICollectingParameters.CollectModelType getCollectModelType() {
        return this.collectModelType;
    }

    @Override
    public boolean isCollectSubResources() {
        return this.collectSubResources;
    }

    @Override
    public Set<TranslateLanguage> getLanguages() {
        return this.languages;
    }

    @Override
    public boolean isCollectEmptyValue() {
        return this.collectEmptyValue;
    }

    @Override
    public boolean isContinueAfterFirstError() {
        return this.continueAfterFirstError;
    }

    @Override
    public Collection<Exception> getErrors() {
        return this.errors;
    }

    @Override
    public Map<String, Object> getFilterParameters() {
        return this.filterParameters;
    }

    @Override
    public boolean isKeepLanguagesMode() {
        return this.keepLanguagesMode;
    }

    @Override
    public boolean useCache() {
        return this.useCache;
    }

    public static class Builder {
        private boolean collectModel;
        private boolean collectInterface;
        private boolean collectSubResources;
        private ICollectingParameters.CollectModelType collectModelType = ICollectingParameters.CollectModelType.NONE;
        private Set<TranslateLanguage> languages;
        private boolean collectEmptyValue;
        private boolean collectChildObjects;
        private boolean continueAfterFirstError;
        private Map<String, ? extends Object> filterParameters;
        private boolean useCache;
        private boolean keepLanguagesMode;

        public CollectingParameters build() {
            CollectingParameters parameters = new CollectingParameters(this.collectChildObjects, this.collectModel, this.collectInterface, this.collectSubResources, this.collectModelType, this.collectEmptyValue, this.languages, this.continueAfterFirstError, this.useCache && this.collectChildObjects && !this.collectEmptyValue, this.keepLanguagesMode);
            if (this.filterParameters != null && !this.filterParameters.isEmpty()) {
                parameters.filterParameters.putAll(this.filterParameters);
            }
            return parameters;
        }

        public Builder collectModel() {
            this.collectModel = true;
            return this;
        }

        public Builder collectInterface() {
            this.collectInterface = true;
            return this;
        }

        public Builder collectSubResources() {
            this.collectSubResources = true;
            return this;
        }

        public Builder collectComputedStrings() {
            this.collectModelType = ICollectingParameters.CollectModelType.ANY;
            return this;
        }

        public Builder collectEmptyValue() {
            this.collectEmptyValue = true;
            return this;
        }

        public Builder collectChildObjects() {
            this.collectChildObjects = true;
            return this;
        }

        public Builder continueAfterFirstError() {
            this.continueAfterFirstError = true;
            return this;
        }

        public Set<TranslateLanguage> getLanguages() {
            if (this.languages == null) {
                this.languages = new HashSet<TranslateLanguage>();
            }
            return this.languages;
        }

        public Builder setLanguages(Set<TranslateLanguage> languages) {
            this.languages = languages;
            return this;
        }

        public Builder setFilterParameters(Map<String, ? extends Object> filterParameters) {
            this.filterParameters = filterParameters;
            return this;
        }

        public Builder enableCache() {
            this.useCache = true;
            return this;
        }

        public Builder disableCache() {
            this.useCache = false;
            return this;
        }

        public Builder setKeepLanguagesMode(boolean keepLanguagesMode) {
            this.keepLanguagesMode = keepLanguagesMode;
            return this;
        }

        public Builder setCollectModelType(ICollectingParameters.CollectModelType collectModelType) {
            if (collectModelType == null) {
                collectModelType = ICollectingParameters.CollectModelType.NONE;
            }
            this.collectModelType = collectModelType;
            return this;
        }
    }
}

