/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.collector;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.CollectingFilterParticipant;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.settings.FeatureSettings;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;

public class FeatureSettingsFilter
implements CollectingFilterParticipant {
    public static final String PARAM_FEATURE_SETTINGS_ID = "feature-settigs-id";
    public static final String PARAM_FEATURE_SETTINGS_UNIQUE = "feature-settigs-unique";
    public static final String PARAM_FEATURE_SETTINGS_CAMELCASE = "feature-settigs-camelcase";
    public static final String PARAM_FEATURE_SETTINGS_MULTILIE = "feature-settigs-miltiline";
    public static final String PARAM_FEATURE_SETTINGS_PREFERCONTEXT = "feature-settigs-prefercontext";
    public static final String FALSE_VALUE = "false";
    public static final String TRUE_VALUE = "true";

    @Override
    public boolean needCollectRaw(TranslationSource source, Object sourceObject, FeatureValue value, Map<String, Object> parameters, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public boolean needCollect(TranslationSource source, FeatureValue value, Map<String, Object> parameters, IProgressMonitor monitor) {
        FeatureSettings settings = value.getContextKey().getFeatureSettings();
        return this.checkSettings(parameters, PARAM_FEATURE_SETTINGS_ID, settings, FeatureSettings::isId) && this.checkSettings(parameters, PARAM_FEATURE_SETTINGS_UNIQUE, settings, FeatureSettings::isUnique) && this.checkSettings(parameters, PARAM_FEATURE_SETTINGS_CAMELCASE, settings, FeatureSettings::isCamelCase) && this.checkSettings(parameters, PARAM_FEATURE_SETTINGS_MULTILIE, settings, FeatureSettings::isMultiLine) && this.checkSettings(parameters, PARAM_FEATURE_SETTINGS_PREFERCONTEXT, settings, FeatureSettings::isPreferContext);
    }

    private boolean checkSettings(Map<String, Object> parameters, String key, FeatureSettings settings, Function<FeatureSettings, Boolean> checker) {
        if (!parameters.containsKey(key)) {
            return true;
        }
        Object value = parameters.get(key);
        if (value instanceof Boolean) {
            return checker.apply(settings).equals(value);
        }
        if (value instanceof String && StringUtils.isNotEmpty((String)value)) {
            if (TRUE_VALUE.equalsIgnoreCase((String)value)) {
                return checker.apply(settings);
            }
            if (FALSE_VALUE.equalsIgnoreCase((String)value)) {
                return checker.apply(settings) == false;
            }
            parameters.put(key, "");
        }
        return true;
    }
}

