/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.collector;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.settings.FeatureSettings;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;

public final class PersistableFeatureValue
implements FeatureValue,
Comparable<FeatureValue> {
    private static final long serialVersionUID = -5013348200988178844L;
    private final ContextTranslationKey contextKey;
    private final boolean computedValue;
    private final boolean unknown;
    private final boolean tag;
    private final Map<String, String> localStrings = new ConcurrentHashMap<String, String>();
    private final String comment;
    private final int hashCode;

    public PersistableFeatureValue(IFile file, FeatureKey featureKey, FeatureSettings settings, String value, boolean computedValue) {
        this(new ContextTranslationKeyImpl(file, featureKey, settings, value), computedValue);
    }

    public PersistableFeatureValue(IFile file, FeatureKey featureKey, FeatureSettings settings, String value, boolean computedValue, boolean unknownValue, boolean tagValue) {
        this(new ContextTranslationKeyImpl(file, featureKey, settings, value), computedValue, unknownValue, tagValue);
    }

    public PersistableFeatureValue(String fullPath, FeatureKey featureKey, FeatureSettings settings, String featureValue, boolean computedValue) {
        this(new ContextTranslationKeyImpl(fullPath, featureKey, settings, featureValue), computedValue);
    }

    public PersistableFeatureValue(ContextTranslationKey contextKey) {
        this(contextKey, false, null);
    }

    public PersistableFeatureValue(ContextTranslationKey contextKey, boolean computedValue) {
        this(contextKey, computedValue, null);
    }

    public PersistableFeatureValue(ContextTranslationKey contextKey, boolean computedValue, boolean unknownValue, boolean tagValue) {
        this(contextKey, null, computedValue, unknownValue, tagValue);
    }

    public PersistableFeatureValue(ContextTranslationKey contextKey, boolean computedValue, String comment) {
        this.contextKey = contextKey;
        this.computedValue = computedValue;
        this.unknown = false;
        this.tag = false;
        this.comment = comment;
        this.hashCode = Objects.hash(comment, computedValue, contextKey);
    }

    public PersistableFeatureValue(ContextTranslationKey contextKey, String comment, boolean computedValue, boolean unknownValue, boolean tagValue) {
        this.contextKey = contextKey;
        this.computedValue = computedValue;
        this.unknown = unknownValue;
        this.tag = tagValue;
        this.comment = comment;
        this.hashCode = Objects.hash(comment, computedValue, contextKey);
    }

    @Override
    public ContextTranslationKey getContextKey() {
        return this.contextKey;
    }

    @Override
    public boolean isComputedValue() {
        return this.computedValue;
    }

    @Override
    public boolean isUnknown() {
        return this.unknown;
    }

    @Override
    public boolean isTag() {
        return this.tag;
    }

    @Override
    public Map<String, String> getLocalStrings() {
        return this.localStrings;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistableFeatureValue other = (PersistableFeatureValue)obj;
        return Objects.equals(this.comment, other.comment) && this.computedValue == other.computedValue && this.tag == other.tag && this.unknown == other.unknown && Objects.equals(this.contextKey, other.contextKey);
    }

    @Override
    public int compareTo(FeatureValue o) {
        int result = this.contextKey.getFullPath().compareTo(o.getContextKey().getFullPath());
        if (result == 0) {
            result = this.contextKey.getFeatureKey().compareTo(o.getContextKey().getFeatureKey());
        }
        if (result == 0) {
            result = this.contextKey.getFeatureSettings().getName().compareTo(o.getContextKey().getFeatureSettings().getName());
        }
        if (result == 0) {
            result = this.contextKey.getValue().compareTo(o.getContextKey().getValue());
        }
        if (result == 0 && this.comment != null && o.getComment() != null) {
            result = this.comment.compareTo(o.getComment());
        }
        return result;
    }

    public String toString() {
        return "PersistableFeatureValue [contextKey=" + String.valueOf(this.contextKey) + ", computedValue=" + this.computedValue + ", localStrings=" + String.valueOf(this.localStrings) + ", comment=" + this.comment + "]";
    }
}

