/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.collector;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SegmentFeatureKey
implements FeatureKey {
    private static final long serialVersionUID = 5331859302425928943L;
    public static final SegmentFeatureKey EMPTY = new SegmentFeatureKey(new String[0]){
        private static final long serialVersionUID = 4661553439753010357L;

        @Override
        public FeatureKey append(FeatureKey relativeFeatureKey) {
            return relativeFeatureKey;
        }

        @Override
        public FeatureKey append(String segment) {
            return SegmentFeatureKey.create(segment);
        }

        @Override
        public FeatureKey toLowerCase() {
            return this;
        }

        @Override
        public FeatureKey toUpperCase() {
            return this;
        }

        @Override
        public String toString(String delimiter) {
            return "";
        }
    };
    private final int hash;
    private final String[] segments;
    private transient FeatureKey lowerCase;

    public static SegmentFeatureKey create(String singleSegment) {
        if (singleSegment == null) {
            throw new IllegalArgumentException("Segment cannot be null");
        }
        return new SegmentFeatureKey(singleSegment);
    }

    public static SegmentFeatureKey create(String ... segments) {
        if (segments == null || segments.length == 0) {
            return EMPTY;
        }
        if (segments.length == 1) {
            return SegmentFeatureKey.create(segments[0]);
        }
        String[] newArray = new String[segments.length];
        int i = 0;
        while (i < segments.length) {
            String string = segments[i];
            if (string == null) {
                throw new IllegalArgumentException("Segment cannot be null");
            }
            newArray[i] = string;
            ++i;
        }
        return new SegmentFeatureKey(newArray);
    }

    public static SegmentFeatureKey create(List<String> segments) {
        if (segments == null || segments.isEmpty()) {
            return EMPTY;
        }
        if (segments.size() == 1) {
            String singleSegment = segments.get(0);
            return SegmentFeatureKey.create(singleSegment);
        }
        String[] segmentArray = new String[segments.size()];
        int i = 0;
        while (i < segments.size()) {
            String string = segments.get(i);
            if (string == null) {
                throw new IllegalArgumentException("Segment cannot be null");
            }
            segmentArray[i] = string;
            ++i;
        }
        return new SegmentFeatureKey(segmentArray);
    }

    protected SegmentFeatureKey(String ... segments) {
        this.segments = segments == null || segments.length == 0 ? StringUtils.EMPTY_ARRAY : segments;
        this.hash = Arrays.hashCode(this.segments);
    }

    @Override
    public int compareTo(FeatureKey key) {
        return this.compareTo(key, false);
    }

    @Override
    public int compareToIgnoreCase(FeatureKey key) {
        return this.compareTo(key, true);
    }

    protected int compareTo(FeatureKey key, boolean ignoreCase) {
        if (ignoreCase) {
            int i = 0;
            int upTo = Math.min(this.getSegmentCount(), key.getSegmentCount());
            while (i < upTo) {
                int result = this.getSegment(i).compareToIgnoreCase(key.getSegment(i));
                if (result != 0) {
                    return result;
                }
                ++i;
            }
        } else {
            int i = 0;
            int upTo = Math.min(this.getSegmentCount(), key.getSegmentCount());
            while (i < upTo) {
                int result = this.getSegment(i).compareTo(key.getSegment(i));
                if (result != 0) {
                    return result;
                }
                ++i;
            }
        }
        return this.getSegmentCount() - key.getSegmentCount();
    }

    @Override
    public String getId() {
        return this.toString();
    }

    @Override
    public List<String> getSegments() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    @Override
    public boolean isEmpty() {
        return this.segments.length == 0;
    }

    @Override
    public int getSegmentCount() {
        return this.segments.length;
    }

    @Override
    public String getSegment(int index) {
        return this.segments[index];
    }

    @Override
    public String getLastSegment() {
        return this.segments[this.segments.length - 1];
    }

    @Override
    public String getFirstSegment() {
        return this.segments[0];
    }

    @Override
    public FeatureKey append(String segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Segment cannot be null");
        }
        String[] newSegments = new String[this.getSegmentCount() + 1];
        System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
        newSegments[this.segments.length] = segment;
        return new SegmentFeatureKey(newSegments);
    }

    @Override
    public FeatureKey append(FeatureKey relativeFeatureKey) {
        String[] newSegments = new String[this.getSegmentCount() + relativeFeatureKey.getSegmentCount()];
        int i = 0;
        while (i < this.getSegmentCount()) {
            newSegments[i] = this.getSegment(i);
            ++i;
        }
        i = 0;
        while (i < relativeFeatureKey.getSegmentCount()) {
            newSegments[i + this.getSegmentCount()] = relativeFeatureKey.getSegment(i);
            ++i;
        }
        return new SegmentFeatureKey(newSegments);
    }

    @Override
    public FeatureKey skipFirst(int skipCount) {
        if (skipCount == this.getSegmentCount()) {
            return EMPTY;
        }
        if (skipCount == 0) {
            return this;
        }
        if (skipCount > this.getSegmentCount() || skipCount < 0) {
            throw new IllegalArgumentException("Cannot skip " + skipCount + " fragments from FeatureKey with " + this.getSegmentCount() + " segments");
        }
        String[] newSegments = new String[this.segments.length - skipCount];
        System.arraycopy(this.segments, skipCount, newSegments, 0, newSegments.length);
        return new SegmentFeatureKey(newSegments);
    }

    @Override
    public FeatureKey skipLast(int skipCount) {
        if (skipCount == this.getSegmentCount()) {
            return EMPTY;
        }
        if (skipCount == 0) {
            return this;
        }
        if (skipCount > this.getSegmentCount() || skipCount < 0) {
            throw new IllegalArgumentException("Cannot skip " + skipCount + " fragments from FeatureKey with " + this.getSegmentCount() + " segments");
        }
        String[] newSegments = new String[this.segments.length - skipCount];
        System.arraycopy(this.segments, 0, newSegments, 0, newSegments.length);
        return new SegmentFeatureKey(newSegments);
    }

    @Override
    public boolean startsWith(FeatureKey prefix) {
        return this.startsWith(prefix, false);
    }

    @Override
    public boolean startsWithIgnoreCase(FeatureKey prefix) {
        return this.startsWith(prefix, true);
    }

    @Override
    public FeatureKey toLowerCase() {
        if (this.lowerCase != null) {
            return this.lowerCase;
        }
        String[] newSegments = new String[this.segments.length];
        boolean isLowerCase = true;
        int i = 0;
        while (i < this.getSegmentCount()) {
            String segment = this.segments[i];
            String lowerCaseSegment = segment.toLowerCase();
            isLowerCase = isLowerCase && segment == lowerCaseSegment;
            newSegments[i] = lowerCaseSegment;
            ++i;
        }
        this.lowerCase = isLowerCase ? this : new SegmentFeatureKeyLowerCase(newSegments);
        return this.lowerCase;
    }

    @Override
    public FeatureKey toUpperCase() {
        String[] newSegments = new String[this.getSegmentCount()];
        int i = 0;
        while (i < this.getSegmentCount()) {
            newSegments[i] = this.segments[i].toUpperCase();
            ++i;
        }
        SegmentFeatureKey result = new SegmentFeatureKey(newSegments);
        result.lowerCase = this.lowerCase;
        return result;
    }

    protected boolean startsWith(FeatureKey prefix, boolean ignoreCase) {
        if (prefix.getSegmentCount() > this.getSegmentCount()) {
            return false;
        }
        if (ignoreCase) {
            int i = 0;
            while (i < prefix.getSegmentCount()) {
                if (!this.getSegment(i).equalsIgnoreCase(prefix.getSegment(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < prefix.getSegmentCount()) {
            if (!this.getSegment(i).equals(prefix.getSegment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SegmentFeatureKey) {
            SegmentFeatureKey other = (SegmentFeatureKey)obj;
            if (this.hash != other.hash) {
                return false;
            }
            return Arrays.equals(this.segments, other.segments);
        }
        return false;
    }

    public String toString() {
        return this.toString(".");
    }

    public String toString(String delimiter) {
        int segmentCount = this.getSegmentCount();
        switch (segmentCount) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getFirstSegment();
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFirstSegment());
        int i = 1;
        while (i < segmentCount) {
            builder.append(delimiter);
            builder.append(this.segments[i]);
            ++i;
        }
        return builder.toString();
    }

    private static class SegmentFeatureKeyLowerCase
    extends SegmentFeatureKey {
        public SegmentFeatureKeyLowerCase(String[] segments) {
            super(segments);
        }

        @Override
        public FeatureKey toLowerCase() {
            return this;
        }
    }
}

